/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.crusher;

import crazypants.enderio.Config;
import crazypants.enderio.Log;
import crazypants.enderio.machine.crusher.CrusherOutput;
import crazypants.enderio.machine.crusher.CrusherRecipe;
import crazypants.enderio.machine.crusher.RecipeConfig;
import crazypants.enderio.machine.crusher.RecipeConfigParser;
import crazypants.util.IOUtils;
import crazypants.util.Util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class CrusherRecipeManager {
    public static final int ORE_ENERGY_COST = 400;
    public static final int INGOT_ENERGY_COST = 240;
    private static final String CUSTOM_DEF_FILE_NAME = "EnderIoCrusherRecipes.xml";
    static final CrusherRecipeManager instance = new CrusherRecipeManager();
    private final List recipes = new ArrayList();

    public static CrusherRecipeManager getInstance() {
        return instance;
    }

    public void loadRecipesFromConfig() {
        RecipeConfig config;
        File customDefFile = new File(Config.configDirectory, CUSTOM_DEF_FILE_NAME);
        String defaultVals = null;
        if (!customDefFile.exists()) {
            try {
                defaultVals = this.createCustomDefFileFromDefault(customDefFile);
            }
            catch (IOException e) {
                Log.error("Could load default SAG Mill from EnderIO jar: " + e.getMessage());
                e.printStackTrace();
                return;
            }
        }
        if (!customDefFile.exists()) {
            Log.error("Could load default SAG Mill recipes from " + customDefFile + " as the file does not exist.");
            return;
        }
        try {
            config = defaultVals != null ? RecipeConfigParser.parse(defaultVals) : RecipeConfigParser.parse(customDefFile);
        }
        catch (Exception e) {
            Log.error("Error parsing EnderIoCrusherRecipes.xml");
            return;
        }
        if (config == null) {
            Log.error("Could not load EnderIoCrusherRecipes.xml");
            return;
        }
        this.processConfig(config);
    }

    public void addCustumRecipes(String xmlDef) {
        RecipeConfig config;
        try {
            config = RecipeConfigParser.parse(xmlDef);
        }
        catch (Exception e) {
            Log.error("Error parsing custom xml");
            return;
        }
        if (config == null) {
            Log.error("Could process custom XML");
            return;
        }
        this.processConfig(config);
    }

    public CrusherRecipe getRecipeForInput(wm input) {
        if (input == null) {
            return null;
        }
        for (CrusherRecipe recipe : this.recipes) {
            if (!recipe.isInput(input)) continue;
            return recipe;
        }
        return null;
    }

    private void processConfig(RecipeConfig config) {
        if (config.isDumpItemRegistery()) {
            Util.dumpModObjects(new File(Config.configDirectory, "modObjectsRegistery.txt"));
        }
        if (config.isDumpOreDictionary()) {
            Util.dumpOreNames(new File(Config.configDirectory, "oreDictionaryRegistery.txt"));
        }
        List newRecipes = config.getRecipes();
        Log.info("Added " + newRecipes.size() + " SAG Mill recipes from config.");
        for (CrusherRecipe rec : newRecipes) {
            this.addRecipe(rec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createCustomDefFileFromDefault(File customDefFile) throws IOException {
        InputStream in = this.getClass().getResourceAsStream("/mods/enderio/config/EnderIoCrusherRecipes.xml");
        if (in == null) {
            Log.error("Could load default SAG Mill recipes.");
            throw new IOException("Could not resource /assets/enderio/config/EnderIoCrusherRecipes.xml form classpath. ");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuilder output = new StringBuilder();
        try {
            String line = reader.readLine();
            while (line != null) {
                output.append(line);
                output.append("\n");
                line = reader.readLine();
            }
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(customDefFile, false));
            writer.write(output.toString());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            throw throwable;
        }
        IOUtils.closeQuietly(writer);
        return output.toString();
    }

    public void addRecipe(wm input, float energyCost, wm output) {
        this.addRecipe(input, energyCost, new CrusherOutput(output, 1.0f));
    }

    public void addRecipe(wm input, float energyCost, CrusherOutput ... output) {
        if (input == null || output == null) {
            return;
        }
        this.addRecipe(new CrusherRecipe(input, energyCost, output));
    }

    public void addRecipe(CrusherRecipe recipe) {
        if (recipe == null || !recipe.isValid()) {
            Log.warn("Could not invalid recipe: " + recipe);
            return;
        }
        CrusherRecipe rec = this.getRecipeForInput(recipe.getInput());
        if (rec != null) {
            Log.warn("Not adding supplied recipe as a recipe already exists for the input: " + recipe.getInput());
            return;
        }
        this.recipes.add(recipe);
    }
}

