/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.crusher;

import crazypants.enderio.machine.crusher.CrusherOutput;
import crazypants.enderio.machine.crusher.CrusherRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RecipeConfig {
    private boolean dumpItemRegistery = false;
    private boolean dumpOreDictionary = false;
    private boolean enabled = true;
    private Map recipeGroups = new HashMap();

    public RecipeGroup createRecipeGroup(String name) {
        return new RecipeGroup(name);
    }

    public void addRecipeGroup(RecipeGroup group) {
        if (group.isValid()) {
            this.recipeGroups.put(group.getName(), group);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setRecipeGroups(Map recipeGroups) {
        this.recipeGroups = recipeGroups;
    }

    public boolean isDumpItemRegistery() {
        return this.dumpItemRegistery;
    }

    public void setDumpItemRegistery(boolean dumpItemRegistery) {
        this.dumpItemRegistery = dumpItemRegistery;
    }

    public boolean isDumpOreDictionary() {
        return this.dumpOreDictionary;
    }

    public void setDumpOreDictionary(boolean dumpOreDictionary) {
        this.dumpOreDictionary = dumpOreDictionary;
    }

    public List getRecipes() {
        ArrayList result = new ArrayList(32);
        for (RecipeGroup rg : this.recipeGroups.values()) {
            if (!rg.isEnabled()) continue;
            result.addAll(rg.createRecipes());
        }
        return result;
    }

    public List getRecipesForGroup(String group) {
        RecipeGroup grp = (RecipeGroup)this.recipeGroups.get(group);
        if (grp == null) {
            return Collections.emptyList();
        }
        return grp.createRecipes();
    }

    public Map getRecipeGroups() {
        return this.recipeGroups;
    }

    public static class Recipe {
        private List inputs = new ArrayList();
        private List outputs = new ArrayList();
        private int energyRequired;

        public void addInput(wm stack) {
            this.inputs.add(stack);
        }

        public void addOutput(CrusherOutput output) {
            this.outputs.add(output);
        }

        public List createRecipes() {
            CrusherOutput[] output = this.outputs.toArray(new CrusherOutput[this.outputs.size()]);
            ArrayList<CrusherRecipe> result = new ArrayList<CrusherRecipe>();
            for (wm input : this.inputs) {
                result.add(new CrusherRecipe(input, this.energyRequired, output));
            }
            return result;
        }

        public boolean isValid() {
            return !this.inputs.isEmpty() && !this.outputs.isEmpty();
        }

        public float getEnergyRequired() {
            return this.energyRequired;
        }

        public void setEnergyRequired(int energyRequired) {
            this.energyRequired = energyRequired;
        }

        public String toString() {
            return "Recipe [input=" + this.inputs + ", outputs=" + this.outputs + ", energyRequired=" + this.energyRequired + "]";
        }
    }

    public static class RecipeGroup {
        private final String name;
        private List recipes = new ArrayList();
        private boolean enabled = true;

        public RecipeGroup(String name) {
            if (name != null) {
                name = name.trim();
            }
            if (name.length() <= 0) {
                name = null;
            }
            this.name = name;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public Recipe createRecipe() {
            return new Recipe();
        }

        public void addRecipe(Recipe recipe) {
            if (recipe.isValid()) {
                this.recipes.add(recipe);
            }
        }

        public String getName() {
            return this.name;
        }

        public List createRecipes() {
            ArrayList result = new ArrayList(this.recipes.size());
            for (Recipe recipe : this.recipes) {
                result.addAll(recipe.createRecipes());
            }
            return result;
        }

        public boolean isValid() {
            return this.isNameValid() && !this.recipes.isEmpty();
        }

        public boolean isNameValid() {
            return this.name != null;
        }

        public String toString() {
            return "RecipeGroup [name=" + this.name + ", recipes=" + this.recipes + ", enabled=" + this.enabled + "]";
        }
    }
}

