/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.crusher;

import cpw.mods.fml.common.registry.GameRegistry;
import crazypants.enderio.Log;
import crazypants.enderio.machine.crusher.CrusherOutput;
import crazypants.enderio.machine.crusher.RecipeConfig;
import crazypants.util.IOUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.minecraftforge.oredict.OreDictionary;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class RecipeConfigParser
extends DefaultHandler {
    public static final String ELEMENT_ROOT = "SAGMillRecipes";
    public static final String ELEMENT_RECIPE_GROUP = "recipeGroup";
    public static final String ELEMENT_RECIPE = "recipe";
    public static final String ELEMENT_INPUT = "input";
    public static final String ELEMENT_OUTPUT = "output";
    public static final String ELEMENT_ITEM_STACK = "itemStack";
    public static final String ELEMENT_DUMP_REGISTERY = "dumpRegistery";
    public static final String AT_NAME = "name";
    public static final String AT_ENABLED = "enabled";
    public static final String AT_DUMP_ITEMS = "modObjects";
    public static final String AT_ORE_DICT = "oreDictionary";
    public static final String AT_ENERGY_COST = "energyCost";
    public static final String AT_ITEM_ID = "itemID";
    public static final String AT_ITEM_META = "itemMeta";
    public static final String AT_ITEM_NAME = "itemName";
    public static final String AT_MOD_ID = "modID";
    public static final String AT_NUMBER = "number";
    public static final String AT_CHANCE = "chance";
    private static final String LP = "SAGMillRecipeParser: ";
    private RecipeConfig result = null;
    private RecipeConfig root = null;
    private RecipeConfig.RecipeGroup recipeGroup = null;
    private RecipeConfig.Recipe recipe = null;
    private boolean outputTagOpen = false;
    private boolean inputTagOpen = false;
    private boolean debug = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RecipeConfig parse(String str) throws Exception {
        StringReader reader = new StringReader(str);
        InputSource is = new InputSource(reader);
        try {
            RecipeConfig recipeConfig = RecipeConfigParser.parse(is);
            return recipeConfig;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RecipeConfig parse(File file) throws Exception {
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        InputSource is = new InputSource(bis);
        try {
            RecipeConfig recipeConfig = RecipeConfigParser.parse(is);
            return recipeConfig;
        }
        finally {
            IOUtils.closeQuietly(bis);
        }
    }

    public static RecipeConfig parse(InputSource is) throws Exception {
        RecipeConfigParser parser = new RecipeConfigParser();
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        SAXParser saxParser = spf.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        xmlReader.setContentHandler(parser);
        xmlReader.parse(is);
        return parser.getResult();
    }

    RecipeConfigParser() {
    }

    RecipeConfig getResult() {
        return this.result != null ? this.result : this.root;
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        Log.warn("Warning parsing SAG Mill config file: " + e.getMessage());
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        Log.error("Error parsing SAG Mill config file: " + e.getMessage());
        e.printStackTrace();
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        Log.error("Error parsing SAG Mill config file: " + e.getMessage());
        e.printStackTrace();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (ELEMENT_ROOT.equals(localName)) {
            this.result = this.root;
            this.root = null;
            if (this.debug) {
                Log.debug("SAGMillRecipeParser: Closing root");
            }
            return;
        }
        if (ELEMENT_RECIPE_GROUP.equals(localName)) {
            if (this.debug) {
                Log.debug("SAGMillRecipeParser: Closing recipe group");
            }
            if (this.recipeGroup != null && this.recipeGroup.isValid() && this.root != null) {
                this.root.addRecipeGroup(this.recipeGroup);
            } else {
                Log.warn("SAGMillRecipeParser: Could not add recipe group " + this.recipeGroup + " to root " + this.root);
            }
            this.recipeGroup = null;
            return;
        }
        if (ELEMENT_RECIPE.equals(localName)) {
            if (this.debug) {
                Log.debug("SAGMillRecipeParser: Closing recipe");
            }
            if (this.recipe != null && this.recipeGroup != null) {
                this.recipeGroup.addRecipe(this.recipe);
            } else {
                Log.warn("SAGMillRecipeParser: Could not add recipe " + this.recipe + " to group " + this.recipeGroup);
            }
            this.recipe = null;
            return;
        }
        if (ELEMENT_OUTPUT.equals(localName)) {
            this.outputTagOpen = false;
            if (this.debug) {
                Log.debug("SAGMillRecipeParser: Closing output");
            }
            return;
        }
        if (ELEMENT_INPUT.equals(localName)) {
            this.inputTagOpen = false;
            if (this.debug) {
                Log.debug("SAGMillRecipeParser: Closing input");
            }
            return;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.debug) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < attributes.getLength(); ++i) {
                sb.append("[" + attributes.getQName(i) + "=" + attributes.getValue(i) + "]");
            }
            Log.debug("SAGMillRecipeParser: RecipeConfigParser.startElement: localName:" + localName + " attrs:" + sb);
        }
        if (ELEMENT_ROOT.equals(localName)) {
            if (this.root != null) {
                Log.warn("SAGMillRecipeParser: Multiple SAGMillRecipes elements found.");
            } else {
                this.root = new RecipeConfig();
            }
            return;
        }
        if (this.root == null) {
            Log.warn("SAGMillRecipeParser: <SAGMillRecipes> not specified before element " + localName + ".");
            this.root = new RecipeConfig();
        }
        if (ELEMENT_DUMP_REGISTERY.equals(localName)) {
            this.root.setDumpOreDictionary(this.getBooleanValue(AT_ORE_DICT, attributes, false));
            this.root.setDumpItemRegistery(this.getBooleanValue(AT_DUMP_ITEMS, attributes, false));
            return;
        }
        if (ELEMENT_RECIPE_GROUP.equals(localName)) {
            if (this.recipeGroup != null) {
                Log.warn("SAGMillRecipeParser: Recipe group " + this.recipeGroup.getName() + " not closed before encountering a new recipe group.");
            }
            this.recipeGroup = this.root.createRecipeGroup(attributes.getValue(AT_NAME));
            this.recipeGroup.setEnabled(this.getBooleanValue(AT_ENABLED, attributes, true));
            if (!this.recipeGroup.isNameValid()) {
                Log.warn("SAGMillRecipeParser: A recipe group was found with an invalid name: " + attributes.getValue(AT_NAME));
                this.recipeGroup = null;
            }
            return;
        }
        if (ELEMENT_RECIPE.equals(localName)) {
            if (this.recipeGroup == null) {
                Log.warn("SAGMillRecipeParser: A recipe was found outside of a recipe groups tags.");
                return;
            }
            if (this.recipe != null) {
                Log.warn("SAGMillRecipeParser: A new recipe was started before the recipe was closed.");
            }
            this.recipe = this.recipeGroup.createRecipe();
            this.recipe.setEnergyRequired(this.getIntValue(AT_ENERGY_COST, attributes, 400));
            return;
        }
        if (this.recipe == null) {
            Log.warn("SAGMillRecipeParser: Found element <" + localName + "> outside of a recipe decleration.");
            return;
        }
        if (ELEMENT_OUTPUT.equals(localName)) {
            if (this.inputTagOpen) {
                Log.warn("SAGMillRecipeParser: <output> encounterd before <input> closed.");
                this.inputTagOpen = false;
            }
            if (this.outputTagOpen) {
                Log.warn("SAGMillRecipeParser: <output> encounterd before previous <output> closed.");
            }
            this.outputTagOpen = true;
            return;
        }
        if (ELEMENT_INPUT.equals(localName)) {
            if (this.outputTagOpen) {
                Log.warn("SAGMillRecipeParser: <input> encounterd before <output> closed.");
                this.outputTagOpen = false;
            }
            if (this.inputTagOpen) {
                Log.warn("SAGMillRecipeParser: <input> encounterd before previous <input> closed.");
            }
            this.inputTagOpen = true;
            return;
        }
        if (ELEMENT_ITEM_STACK.equals(localName)) {
            if (!this.inputTagOpen && !this.outputTagOpen) {
                Log.warn("SAGMillRecipeParser: Encounterd an item stack outside of either an <input> or <output> tag.");
                return;
            }
            if (this.inputTagOpen && this.outputTagOpen) {
                Log.warn("SAGMillRecipeParser: Encounterd an item stack within both an <input> and <output> tag.");
                return;
            }
            if (this.inputTagOpen) {
                this.addInputStack(attributes);
            } else {
                this.addOutputStack(attributes);
            }
        }
    }

    private void addOutputStack(Attributes attributes) {
        wm stack = this.getItemStack(attributes);
        if (stack == null) {
            return;
        }
        this.recipe.addOutput(new CrusherOutput(stack, this.getFloatValue(AT_CHANCE, attributes, 1.0f)));
    }

    private void addInputStack(Attributes attributes) {
        String oreDict = this.getStringValue(AT_ORE_DICT, attributes, null);
        if (oreDict != null) {
            ArrayList ores = OreDictionary.getOres((String)oreDict);
            if (ores == null) {
                return;
            }
            int stackSize = this.getIntValue(AT_NUMBER, attributes, 1);
            for (wm st : ores) {
                if (st == null) continue;
                wm stack = st.m();
                stack.a = stackSize;
                if (stack.k() == Short.MAX_VALUE) {
                    for (int i = 0; i < 16; ++i) {
                        stack = stack.m();
                        stack.b(i);
                        this.recipe.addInput(stack);
                    }
                    continue;
                }
                this.recipe.addInput(stack);
            }
        } else {
            wm stack = this.getItemStack(attributes);
            if (stack == null) {
                return;
            }
            stack.a = 1;
            this.recipe.addInput(stack);
        }
    }

    private wm getItemStack(Attributes attributes) {
        String oreDict = this.getStringValue(AT_ORE_DICT, attributes, null);
        if (oreDict != null) {
            ArrayList ores = OreDictionary.getOres((String)oreDict);
            if (ores == null || ores.isEmpty() || ores.get(0) == null) {
                Log.warn("SAGMillRecipeParser: Could not find an entry in the ore dictionary for " + oreDict);
                return null;
            }
            wm stack = ((wm)ores.get(0)).m();
            stack.a = this.getIntValue(AT_NUMBER, attributes, 1);
            if (stack.k() == Short.MAX_VALUE) {
                stack.b(0);
            }
            return stack;
        }
        int itemID = this.getIntValue(AT_ITEM_ID, attributes, -1);
        if (itemID <= 0) {
            String modId = this.getStringValue(AT_MOD_ID, attributes, null);
            String name = this.getStringValue(AT_ITEM_NAME, attributes, null);
            if (modId != null && name != null) {
                wk i = GameRegistry.findItem((String)modId, (String)name);
                if (i != null) {
                    itemID = i.cp;
                } else {
                    apa b = GameRegistry.findBlock((String)modId, (String)name);
                    if (b != null) {
                        itemID = b.cz;
                    }
                }
            }
        }
        if (itemID <= 0) {
            Log.warn("Could not create an item stack from the attributes " + this.toString(attributes));
            return null;
        }
        int itemMeta = this.getIntValue(AT_ITEM_META, attributes, 0);
        int stackSize = this.getIntValue(AT_NUMBER, attributes, 1);
        return new wm(itemID, stackSize, itemMeta);
    }

    private boolean getBooleanValue(String qName, Attributes attributes, boolean def) {
        String val = attributes.getValue(qName);
        if (val == null) {
            return def;
        }
        return (val = val.toLowerCase().trim()).equals("false") ? false : (val.equals("true") ? true : def);
    }

    private int getIntValue(String qName, Attributes attributes, int def) {
        try {
            return Integer.parseInt(this.getStringValue(qName, attributes, def + ""));
        }
        catch (Exception e) {
            Log.warn("SAGMillRecipeParser: Could not parse a valid int for attribute " + qName + " with value " + this.getStringValue(qName, attributes, null));
            return def;
        }
    }

    private float getFloatValue(String qName, Attributes attributes, float def) {
        try {
            return Float.parseFloat(this.getStringValue(qName, attributes, def + ""));
        }
        catch (Exception e) {
            Log.warn("SAGMillRecipeParser: Could not parse a valid float for attribute " + qName + " with value " + this.getStringValue(qName, attributes, null));
            return def;
        }
    }

    private String getStringValue(String qName, Attributes attributes, String def) {
        String val = attributes.getValue(qName);
        if (val == null) {
            return def;
        }
        if ((val = val.trim()).length() <= 0) {
            return null;
        }
        return val;
    }

    private String toString(Attributes attributes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < attributes.getLength(); ++i) {
            sb.append("[" + attributes.getQName(i) + "=" + attributes.getValue(i) + "]");
        }
        return sb.toString();
    }
}

