/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.generator;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.power.Capacitors;
import crazypants.enderio.power.IInternalPowerReceptor;
import crazypants.enderio.power.PowerHandlerUtil;
import crazypants.util.BlockCoord;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityStirlingGenerator
extends AbstractMachineEntity
implements md {
    public static final float ENERGY_PER_TICK = 1.0f;
    private int burnTime = 0;
    private int totalBurnTime;
    private final List receptors = new ArrayList();
    private ListIterator receptorIterator = this.receptors.listIterator();
    private boolean receptorsDirty = true;

    public TileEntityStirlingGenerator() {
        super(new SlotDefinition(1, 0));
        this.configurePowerHandler();
    }

    @Override
    public void setCapacitor(Capacitors capacitorType) {
        super.setCapacitor(capacitorType);
        this.configurePowerHandler();
    }

    void configurePowerHandler() {
        this.powerHandler.configure(0, 0, 0, 0, this.capacitorType.capacitor.getMaxEnergyStored());
    }

    @Override
    public String getMachineName() {
        return ModObject.blockStirlingGenerator.unlocalisedName;
    }

    public String b() {
        return "Stirling Generator";
    }

    @Override
    public boolean isMachineItemValidForSlot(int i, wm itemstack) {
        return aqg.b((wm)itemstack);
    }

    public int[] c(int var1) {
        return new int[]{0};
    }

    public boolean a(int i, wm itemstack, int j) {
        return this.b(i, itemstack);
    }

    public boolean b(int i, wm itemstack, int j) {
        return false;
    }

    @Override
    public boolean isActive() {
        return this.burnTime > 0;
    }

    @Override
    public float getProgress() {
        if (this.totalBurnTime <= 0) {
            return 0.0f;
        }
        return (float)this.burnTime / (float)this.totalBurnTime;
    }

    @Override
    public void a(bs nbtRoot) {
        super.a(nbtRoot);
        this.burnTime = nbtRoot.e("burnTime");
        this.totalBurnTime = nbtRoot.e("totalBurnTime");
    }

    @Override
    public void b(bs nbtRoot) {
        super.b(nbtRoot);
        nbtRoot.a("burnTime", this.burnTime);
        nbtRoot.a("totalBurnTime", this.totalBurnTime);
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        this.receptorsDirty = true;
    }

    @Override
    protected boolean processTasks(boolean redstoneCheckPassed) {
        boolean needsUpdate = false;
        if (this.burnTime > 0) {
            this.powerHandler.setEnergy(this.powerHandler.getEnergyStored() + 1.0f);
            --this.burnTime;
            needsUpdate = true;
        }
        needsUpdate |= this.transmitEnergy();
        if (this.burnTime <= 0 && this.powerHandler.getEnergyStored() < (float)this.powerHandler.getMaxEnergyStored() && redstoneCheckPassed && this.inventory[0] != null && this.inventory[0].a > 0) {
            this.burnTime = aqg.a((wm)this.inventory[0]);
            if (this.burnTime > 0) {
                this.totalBurnTime = this.burnTime;
                this.a(0, 1);
            }
            needsUpdate = true;
        }
        return needsUpdate;
    }

    @Override
    public int powerRequest(ForgeDirection from) {
        return 0;
    }

    private boolean transmitEnergy() {
        if (this.powerHandler.getEnergyStored() <= 0.0f) {
            this.powerHandler.update(this);
            return false;
        }
        float canTransmit = Math.min(this.powerHandler.getEnergyStored(), (float)this.capacitorType.capacitor.getMaxEnergyExtracted());
        float transmitted = 0.0f;
        float stored = this.powerHandler.getEnergyStored();
        this.powerHandler.update(this);
        float storedAfter = this.powerHandler.getEnergyStored();
        this.checkReceptors();
        if (!this.receptors.isEmpty() && !this.receptorIterator.hasNext()) {
            this.receptorIterator = this.receptors.listIterator();
        }
        int numReceptors = this.receptors.size();
        for (int appliedCount = 0; this.receptorIterator.hasNext() && canTransmit > 0.0f && appliedCount < numReceptors; ++appliedCount) {
            Receptor receptor = (Receptor)this.receptorIterator.next();
            IPowerProvider pp = receptor.receptor.getPowerProvider();
            if (pp != null && (float)pp.getMinEnergyReceived() <= canTransmit) {
                float used;
                if (receptor.receptor instanceof IInternalPowerReceptor) {
                    used = PowerHandlerUtil.transmitInternal((IInternalPowerReceptor)receptor.receptor, canTransmit, receptor.fromDir.getOpposite());
                } else {
                    used = Math.min(canTransmit, (float)receptor.receptor.powerRequest(receptor.fromDir.getOpposite()));
                    used = Math.min(used, (float)pp.getMaxEnergyStored() - pp.getEnergyStored());
                    pp.receiveEnergy(used, receptor.fromDir);
                }
                transmitted += used;
                canTransmit -= used;
            }
            if (canTransmit <= 0.0f) break;
            if (this.receptors.isEmpty() || this.receptorIterator.hasNext()) continue;
            this.receptorIterator = this.receptors.listIterator();
        }
        this.powerHandler.setEnergy(this.powerHandler.getEnergyStored() - transmitted);
        return transmitted > 0.0f;
    }

    private void checkReceptors() {
        if (!this.receptorsDirty) {
            return;
        }
        this.receptors.clear();
        BlockCoord bc = new BlockCoord(this.l, this.m, this.n);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            BlockCoord checkLoc = bc.getLocation(dir);
            aqp te = this.k.r(checkLoc.x, checkLoc.y, checkLoc.z);
            if (!(te instanceof IPowerReceptor)) continue;
            IPowerReceptor rec = (IPowerReceptor)te;
            this.receptors.add(new Receptor((IPowerReceptor)te, dir));
        }
        this.receptorIterator = this.receptors.listIterator();
        this.receptorsDirty = false;
    }

    static class Receptor {
        IPowerReceptor receptor;
        ForgeDirection fromDir;

        private Receptor(IPowerReceptor rec, ForgeDirection fromDir) {
            this.receptor = rec;
            this.fromDir = fromDir;
        }
    }
}

