/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.hypercube;

import crazypants.enderio.machine.hypercube.Channel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ClientChannelRegister {
    static final ClientChannelRegister instance = new ClientChannelRegister();
    private final List publicChannels = new ArrayList();
    private final List publicChannelsRO = Collections.unmodifiableList(this.publicChannels);
    private final List privateChannels = new ArrayList();
    private final List privateChannelsRO = Collections.unmodifiableList(this.privateChannels);

    void setPublicChannels(List channels) {
        this.publicChannels.clear();
        this.publicChannels.addAll(channels);
    }

    void setPrivateChannels(List channels) {
        this.privateChannels.clear();
        this.privateChannels.addAll(channels);
    }

    public List getPublicChannels() {
        return this.publicChannelsRO;
    }

    public List getPrivateChannels() {
        return this.privateChannelsRO;
    }

    void addChannel(Channel channel) {
        if (channel == null) {
            return;
        }
        if (channel.isPublic()) {
            if (!this.publicChannels.contains(channel)) {
                this.publicChannels.add(channel);
            }
        } else if (!this.privateChannels.contains(channel)) {
            this.privateChannels.add(channel);
        }
    }

    public void channelAdded(Channel channel) {
        if (channel.isPublic() && !this.publicChannels.contains(channel)) {
            this.publicChannels.add(channel);
        }
    }

    public void reset() {
        this.publicChannels.clear();
        this.privateChannels.clear();
    }

    public void channelRemoved(Channel c) {
        if (c.isPublic()) {
            this.publicChannels.remove(c);
        } else {
            this.privateChannels.remove(c);
        }
    }
}

