/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.hypercube;

import cpw.mods.fml.common.network.PacketDispatcher;
import crazypants.enderio.gui.IconButtonEIO;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.gui.IconToggleButtonEIO;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.machine.hypercube.BlockHyperCube;
import crazypants.enderio.machine.hypercube.Channel;
import crazypants.enderio.machine.hypercube.ClientChannelRegister;
import crazypants.enderio.machine.hypercube.GuiChannelList;
import crazypants.enderio.machine.hypercube.HyperCubePacketHandler;
import crazypants.enderio.machine.hypercube.TileHyperCube;
import crazypants.gui.GuiScreenBase;
import crazypants.gui.GuiScrollableList;
import crazypants.gui.GuiToolTip;
import crazypants.gui.IconButton;
import crazypants.gui.ListSelectionListener;
import crazypants.render.ColorUtil;
import crazypants.render.RenderUtil;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.List;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class GuiHyperCube
extends GuiScreenBase {
    protected static final int POWER_INPUT_BUTTON_ID = 1;
    protected static final int POWER_OUTPUT_BUTTON_ID = 2;
    protected static final int ADD_BUTTON_ID = 3;
    protected static final int PRIVATE_BUTTON_ID = 4;
    protected static final int SELECT_PRIVATE_BUTTON_ID = 5;
    protected static final int SELECT_PUBLIC_BUTTON_ID = 6;
    protected static final int DELETE_PRIVATE_BUTTON_ID = 7;
    protected static final int DELETE_PUBLIC_BUTTON_ID = 8;
    private static final int POWER_X = 227;
    private static final int POWER_Y = 46;
    private static final int POWER_WIDTH = 10;
    private static final int POWER_HEIGHT = 66;
    protected static final int BOTTOM_POWER_Y = 112;
    private final TileHyperCube cube;
    private IconButton powerInputRedstoneButton;
    private IconButton powerOutputRedstoneButton;
    private IconButtonEIO addButton;
    private IconToggleButtonEIO privateButton;
    private aws newChannelTF;
    private GuiChannelList publicChannelList;
    private GuiChannelList privateChannelList;
    private ListSelectionListener selectionListener;
    private IconButtonEIO selectPublicB;
    private IconButtonEIO deletePublicB;
    private IconButtonEIO selectPrivateB;
    private IconButtonEIO deletePrivateB;

    public GuiHyperCube(TileHyperCube te) {
        super(245, 145);
        this.cube = te;
        this.addToolTip(new GuiToolTip(new Rectangle(227, 46, 10, 66), new String[]{""}){

            @Override
            protected void updateText() {
                this.text.clear();
                this.text.add(BlockHyperCube.NF.format(Math.round(((GuiHyperCube)GuiHyperCube.this).cube.powerHandler.getEnergyStored())) + " MJ");
            }
        });
        this.addToolTip(new GuiToolTip(new Rectangle(198, 12, 16, 16), new String[]{""}){

            @Override
            protected void updateText() {
                this.text.clear();
                this.text.add("Input Redstone Mode");
                this.text.add(((GuiHyperCube)GuiHyperCube.this).cube.getInputControlMode().tooltip);
            }
        });
        this.addToolTip(new GuiToolTip(new Rectangle(219, 12, 16, 16), new String[]{""}){

            @Override
            protected void updateText() {
                this.text.clear();
                this.text.add("Output Redstone Mode");
                this.text.add(((GuiHyperCube)GuiHyperCube.this).cube.getOutputControlMode().tooltip);
            }
        });
        this.addButton = new IconButtonEIO(this, 3, 137, 12, IconEIO.PLUS);
        this.addButton.setToolTip("Add Channel");
        this.addButton.g = false;
        this.privateButton = new IconToggleButtonEIO(this, 4, 118, 12, IconEIO.PUBLIC, IconEIO.PRIVATE);
        this.privateButton.setSelectedToolTip("Private Channel");
        this.privateButton.setUnselectedToolTip("Public Channel");
        this.deletePublicB = new IconButtonEIO(this, 8, 74, 117, IconEIO.MINUS);
        this.deletePublicB.setToolTip("Delete Channel");
        this.selectPublicB = new IconButtonEIO(this, 6, 95, 117, IconEIO.TICK);
        this.selectPublicB.setToolTip("Activate Channel");
        this.deletePrivateB = new IconButtonEIO(this, 7, 183, 117, IconEIO.MINUS);
        this.deletePrivateB.setToolTip("Delete Channel");
        this.selectPrivateB = new IconButtonEIO(this, 5, 204, 117, IconEIO.TICK);
        this.selectPrivateB.setToolTip("Activate Channel");
        int w = 104;
        int h = 68;
        int x = 7;
        int y = 45;
        Channel activeChannel = this.cube.getChannel();
        this.publicChannelList = new GuiChannelList(this, w, h, x, y);
        this.publicChannelList.setChannels(ClientChannelRegister.instance.getPublicChannels());
        this.publicChannelList.setShowSelectionBox(true);
        this.publicChannelList.setScrollButtonIds(100, 101);
        this.publicChannelList.setActiveChannel(this.isPublic(activeChannel) ? activeChannel : null);
        x = x + 5 + w;
        this.privateChannelList = new GuiChannelList(this, w, h, x, y);
        this.privateChannelList.setChannels(ClientChannelRegister.instance.getPrivateChannels());
        this.privateChannelList.setShowSelectionBox(true);
        this.privateChannelList.setScrollButtonIds(102, 103);
        this.privateChannelList.setActiveChannel(this.isPrivate(activeChannel) ? activeChannel : null);
        this.selectionListener = new ListSelectionListener(){

            @Override
            public void selectionChanged(GuiScrollableList list, int selectedIndex) {
                Channel selected = (Channel)list.getSelectedElement();
                if (selected != null) {
                    GuiChannelList clear = list == GuiHyperCube.this.publicChannelList ? GuiHyperCube.this.privateChannelList : GuiHyperCube.this.publicChannelList;
                    clear.setSelection(-1);
                }
            }
        };
        this.publicChannelList.addSelectionListener(this.selectionListener);
        this.privateChannelList.addSelectionListener(this.selectionListener);
    }

    private boolean isPublic(Channel chan) {
        if (chan == null) {
            return false;
        }
        return chan.isPublic();
    }

    private boolean isPrivate(Channel chan) {
        if (chan == null) {
            return false;
        }
        return !chan.isPublic();
    }

    @Override
    public void A_() {
        super.A_();
        this.k.clear();
        int x = this.guiLeft + 203;
        int y = this.guiTop + 12;
        this.powerInputRedstoneButton = new IconButton(this.m, 1, x, y, AbstractMachineBlock.getRedstoneControlIcon(this.cube.getInputControlMode()), "/terrain.png");
        this.powerInputRedstoneButton.setSize(16, 16);
        this.k.add(this.powerInputRedstoneButton);
        x = x + 5 + 16;
        this.powerOutputRedstoneButton = new IconButton(this.m, 2, x, y, AbstractMachineBlock.getRedstoneControlIcon(this.cube.getOutputControlMode()), "/terrain.png");
        this.powerOutputRedstoneButton.setSize(16, 16);
        this.k.add(this.powerOutputRedstoneButton);
        y = this.guiTop + 12;
        x = this.guiLeft + 8;
        this.newChannelTF = new aws(this.m, x, y, 103, 16);
        this.newChannelTF.d(false);
        this.newChannelTF.f(32);
        this.newChannelTF.b(true);
        this.privateButton.onGuiInit();
        this.addButton.onGuiInit();
        this.selectPrivateB.onGuiInit();
        this.selectPublicB.onGuiInit();
        this.deletePrivateB.onGuiInit();
        this.deletePublicB.onGuiInit();
        this.publicChannelList.onGuiInit(this);
        this.privateChannelList.onGuiInit(this);
    }

    protected void a(awg par1GuiButton) {
        if (par1GuiButton.f == 1) {
            int ordinal = this.cube.getInputControlMode().ordinal();
            if (++ordinal >= RedstoneControlMode.values().length) {
                ordinal = 0;
            }
            this.cube.setInputControlMode(RedstoneControlMode.values()[ordinal]);
            this.powerInputRedstoneButton.setIcon(AbstractMachineBlock.getRedstoneControlIcon(this.cube.getInputControlMode()));
            ei pkt = HyperCubePacketHandler.createRedstoneControlPacket(this.cube);
            PacketDispatcher.sendPacketToServer((ei)pkt);
        } else if (par1GuiButton.f == 2) {
            int ordinal = this.cube.getOutputControlMode().ordinal();
            if (++ordinal >= RedstoneControlMode.values().length) {
                ordinal = 0;
            }
            this.cube.setOutputControlMode(RedstoneControlMode.values()[ordinal]);
            this.powerOutputRedstoneButton.setIcon(AbstractMachineBlock.getRedstoneControlIcon(this.cube.getOutputControlMode()));
            ei pkt = HyperCubePacketHandler.createRedstoneControlPacket(this.cube);
            PacketDispatcher.sendPacketToServer((ei)pkt);
        } else if (par1GuiButton.f == 3) {
            Channel c = this.privateButton.isSelected() ? new Channel(this.newChannelTF.b(), Minecraft.x().g.bS) : new Channel(this.newChannelTF.b(), null);
            ClientChannelRegister.instance.addChannel(c);
            ei pkt = HyperCubePacketHandler.createAddRemoveChannelPacket(c, true);
            PacketDispatcher.sendPacketToServer((ei)pkt);
            if (this.privateButton.isSelected()) {
                this.privateChannelList.setSelection(c);
            } else {
                this.publicChannelList.setSelection(c);
            }
        } else if (par1GuiButton.f == 6 || par1GuiButton.f == 5) {
            Channel c;
            Channel channel = c = par1GuiButton.f == 6 ? (Channel)this.publicChannelList.getSelectedElement() : (Channel)this.privateChannelList.getSelectedElement();
            if (c != null) {
                this.setActiveChannel(c);
            }
        } else if (par1GuiButton.f == 7 || par1GuiButton.f == 8) {
            Channel c;
            Channel channel = c = par1GuiButton.f == 8 ? (Channel)this.publicChannelList.getSelectedElement() : (Channel)this.privateChannelList.getSelectedElement();
            if (c != null) {
                if (c.equals(this.cube.getChannel())) {
                    this.setActiveChannel(null);
                }
                ClientChannelRegister.instance.channelRemoved(c);
                ei pkt = HyperCubePacketHandler.createAddRemoveChannelPacket(c, false);
                PacketDispatcher.sendPacketToServer((ei)pkt);
            }
        }
    }

    private void setActiveChannel(Channel c) {
        this.cube.setChannel(c);
        this.publicChannelList.setActiveChannel(this.isPublic(c) ? c : null);
        this.privateChannelList.setActiveChannel(this.isPrivate(c) ? c : null);
        ei pkt = HyperCubePacketHandler.createChannelSelectedPacket(this.cube, c);
        PacketDispatcher.sendPacketToServer((ei)pkt);
    }

    public boolean f() {
        return false;
    }

    protected void a(char par1, int par2) {
        super.a(par1, par2);
        this.newChannelTF.a(par1, par2);
        this.addButton.g = this.newChannelTF.b().trim().length() > 0;
        super.a(par1, par2);
    }

    protected void a(int par1, int par2, int par3) {
        super.a(par1, par2, par3);
        this.newChannelTF.a(par1, par2, par3);
    }

    public void c() {
        this.newChannelTF.a();
    }

    @Override
    protected void drawBackgroundLayer(float partialTick, int mouseX, int mouseY) {
        boolean chanSel;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtil.bindTexture("/mods/enderio/textures/gui/hyperCube.png");
        int sx = (this.h - this.xSize) / 2;
        int sy = (this.i - this.ySize) / 2;
        this.b(sx, sy, 0, 0, this.xSize, this.ySize);
        int i1 = this.cube.getEnergyStoredScaled(66);
        this.b(sx + 227, sy + 112 - i1, 245, 0, 10, i1);
        this.selectPublicB.g = chanSel = this.publicChannelList.getSelectedElement() != null;
        this.deletePublicB.g = chanSel;
        this.selectPrivateB.g = chanSel = this.privateChannelList.getSelectedElement() != null;
        this.deletePrivateB.g = chanSel;
        this.newChannelTF.f();
        this.publicChannelList.drawScreen(mouseX, mouseY, partialTick);
        this.privateChannelList.drawScreen(mouseX, mouseY, partialTick);
        for (int i = 0; i < this.k.size(); ++i) {
            awg guibutton = (awg)this.k.get(i);
            guibutton.a(this.g, 0, 0);
        }
        int x = this.guiLeft + 12;
        int y = this.guiTop + 35;
        int rgb = ColorUtil.getRGB(Color.white);
        this.b(this.m, "Public", x, y, rgb);
        this.b(this.m, "Private", x += 109, y, rgb);
    }

    @Override
    public void drawHoveringText(List par1List, int par2, int par3, awv font) {
        GL11.glPushAttrib((int)8192);
        GL11.glPushAttrib((int)64);
        super.drawHoveringText(par1List, par2, par3, font);
        GL11.glPopAttrib();
        GL11.glPopAttrib();
    }

    @Override
    public int getGuiLeft() {
        return this.guiLeft;
    }

    @Override
    public int getGuiTop() {
        return this.guiTop;
    }

    @Override
    public int getXSize() {
        return this.xSize;
    }

    @Override
    public awv getFontRenderer() {
        return this.m;
    }
}

