/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.hypercube;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.IConnectionHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import crazypants.enderio.IPacketProcessor;
import crazypants.enderio.Log;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.machine.hypercube.Channel;
import crazypants.enderio.machine.hypercube.ClientChannelRegister;
import crazypants.enderio.machine.hypercube.HyperCubeRegister;
import crazypants.enderio.machine.hypercube.TileHyperCube;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.MinecraftServer;

public class HyperCubePacketHandler
implements IPacketProcessor,
IConnectionHandler {
    @Override
    public boolean canProcessPacket(int packetID) {
        return 6 == packetID || 7 == packetID || 8 == packetID || 9 == packetID || 10 == packetID;
    }

    @Override
    public void processPacket(int packetID, cg manager, DataInputStream data, Player player) throws IOException {
        if (packetID == 6) {
            this.handleHyperCubeRedstoneControlPacket(data, manager, player);
        } else if (packetID == 7) {
            this.handlePublicChannelListPacket(data, manager, player);
        } else if (packetID == 8) {
            this.handleAddRemoveChannelPacket(data, manager, player);
        } else if (packetID == 9) {
            this.handlePrivateChannelPacket(data, manager, player);
        } else if (packetID == 10) {
            this.handleChannelSelectedPacket(data, manager, player);
        }
    }

    public static ei createChannelSelectedPacket(TileHyperCube cube, Channel channel) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeInt(10);
            dos.writeInt(cube.l);
            dos.writeInt(cube.m);
            dos.writeInt(cube.n);
            dos.writeBoolean(channel != null);
            if (channel != null) {
                dos.writeBoolean(channel.isPublic());
                dos.writeUTF(channel.name);
                if (!channel.isPublic()) {
                    dos.writeUTF(channel.user);
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        dk pkt = new dk();
        pkt.a = "EnderIO";
        pkt.c = bos.toByteArray();
        pkt.b = bos.size();
        pkt.s = true;
        return pkt;
    }

    private void handleChannelSelectedPacket(DataInputStream data, cg manager, Player player) throws IOException {
        int z;
        int y;
        if (!(player instanceof sq)) {
            Log.warn("handleChannelSelectedPacket: Could not handle packet as player not an entity player.");
            return;
        }
        aab world = ((sq)player).q;
        if (world == null) {
            Log.warn("handleChannelSelectedPacket: Could not handle packet as player world was null.");
            return;
        }
        int x = data.readInt();
        aqp te = world.r(x, y = data.readInt(), z = data.readInt());
        if (!(te instanceof TileHyperCube)) {
            Log.warn("handleChannelSelectedPacket: Could not handle packet as TileEntity was not a HyperCube.");
            return;
        }
        TileHyperCube hc = (TileHyperCube)te;
        boolean hasCan = data.readBoolean();
        if (!hasCan) {
            hc.setChannel(null);
            return;
        }
        boolean isPublic = data.readBoolean();
        String name = data.readUTF();
        String user = null;
        if (!isPublic) {
            user = data.readUTF();
        }
        hc.setChannel(new Channel(name, user));
    }

    public static ei createUserChannelListPacket(String username) {
        List channels = HyperCubeRegister.instance.getChannelsForUser(username);
        if (channels.isEmpty()) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeInt(9);
            dos.writeUTF(username);
            dos.writeInt(channels.size());
            for (Channel channel : channels) {
                dos.writeUTF(channel.name);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        dk pkt = new dk();
        pkt.a = "EnderIO";
        pkt.c = bos.toByteArray();
        pkt.b = bos.size();
        pkt.s = true;
        return pkt;
    }

    private void handlePrivateChannelPacket(DataInputStream data, cg manager, Player player) throws IOException {
        String user = data.readUTF();
        int numChannels = data.readInt();
        ArrayList<Channel> channels = new ArrayList<Channel>();
        for (int i = 0; i < numChannels; ++i) {
            channels.add(new Channel(data.readUTF(), user));
        }
        ClientChannelRegister.instance.setPrivateChannels(channels);
    }

    public static ei createAddRemoveChannelPacket(Channel channel, boolean isAdd) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeInt(8);
            dos.writeBoolean(isAdd);
            dos.writeBoolean(channel.isPublic());
            dos.writeUTF(channel.name);
            if (!channel.isPublic()) {
                dos.writeUTF(channel.user);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        dk pkt = new dk();
        pkt.a = "EnderIO";
        pkt.c = bos.toByteArray();
        pkt.b = bos.size();
        pkt.s = true;
        return pkt;
    }

    private void handleAddRemoveChannelPacket(DataInputStream data, cg manager, Player player) throws IOException {
        boolean isAdd = data.readBoolean();
        boolean isPublic = data.readBoolean();
        String name = data.readUTF();
        String user = null;
        if (!isPublic) {
            user = data.readUTF();
        }
        Channel channel = new Channel(name, user);
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.SERVER) {
            if (isAdd) {
                HyperCubeRegister.instance.addChannel(channel);
            } else {
                HyperCubeRegister.instance.removeChannel(channel);
            }
            PacketDispatcher.sendPacketToAllPlayers((ei)HyperCubePacketHandler.createAddRemoveChannelPacket(channel, isAdd));
        } else if (isAdd) {
            ClientChannelRegister.instance.channelAdded(channel);
        } else {
            ClientChannelRegister.instance.channelRemoved(channel);
        }
    }

    public static ei createPublicChannelListPacket() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        List channels = HyperCubeRegister.instance.getPublicChannels();
        try {
            dos.writeInt(7);
            dos.writeInt(channels.size());
            for (Channel channel : channels) {
                dos.writeUTF(channel.name);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        dk pkt = new dk();
        pkt.a = "EnderIO";
        pkt.c = bos.toByteArray();
        pkt.b = bos.size();
        pkt.s = true;
        return pkt;
    }

    private void handlePublicChannelListPacket(DataInputStream data, cg manager, Player player) throws IOException {
        int numChannels = data.readInt();
        ArrayList<Channel> channels = new ArrayList<Channel>();
        for (int i = 0; i < numChannels; ++i) {
            channels.add(new Channel(data.readUTF(), null));
        }
        ClientChannelRegister.instance.setPublicChannels(channels);
    }

    public static ei createRedstoneControlPacket(TileHyperCube te) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(140);
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeInt(6);
            dos.writeInt(te.l);
            dos.writeInt(te.m);
            dos.writeInt(te.n);
            dos.writeShort((short)te.getInputControlMode().ordinal());
            dos.writeShort((short)te.getOutputControlMode().ordinal());
        }
        catch (IOException e) {
            // empty catch block
        }
        dk pkt = new dk();
        pkt.a = "EnderIO";
        pkt.c = bos.toByteArray();
        pkt.b = bos.size();
        pkt.s = true;
        return pkt;
    }

    private void handleHyperCubeRedstoneControlPacket(DataInputStream data, cg manager, Player player) throws IOException {
        int x = data.readInt();
        int y = data.readInt();
        int z = data.readInt();
        short powerInputOrdinal = data.readShort();
        short powerOutputOrdinal = data.readShort();
        jc p = (jc)player;
        aqp te = p.q.r(x, y, z);
        if (te instanceof TileHyperCube) {
            TileHyperCube cb = (TileHyperCube)te;
            cb.setInputControlMode(RedstoneControlMode.values()[powerInputOrdinal]);
            cb.setOutputControlMode(RedstoneControlMode.values()[powerOutputOrdinal]);
            p.q.j(x, y, z);
        }
    }

    public void playerLoggedIn(Player player, ej netHandler, cg manager) {
        ei pkt = HyperCubePacketHandler.createPublicChannelListPacket();
        PacketDispatcher.sendPacketToPlayer((ei)pkt, (Player)player);
        if (player instanceof jc) {
            jc ep = (jc)player;
            pkt = HyperCubePacketHandler.createUserChannelListPacket(ep.bS);
            if (pkt != null) {
                PacketDispatcher.sendPacketToPlayer((ei)pkt, (Player)player);
            }
        } else {
            Log.warn("HyperCubePacketHandler.playerLoggedIn: Could not determine player user name");
        }
    }

    public String connectionReceived(jf netHandler, cg manager) {
        return null;
    }

    public void connectionOpened(ej netClientHandler, String server, int port, cg manager) {
    }

    public void connectionOpened(ej netClientHandler, MinecraftServer server, cg manager) {
    }

    public void connectionClosed(cg manager) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.CLIENT) {
            ClientChannelRegister.instance.reset();
        }
    }

    public void clientLoggedIn(ej clientHandler, cg manager, dz login) {
    }
}

