/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.hypercube;

import crazypants.enderio.Log;
import crazypants.enderio.machine.hypercube.Channel;
import crazypants.enderio.machine.hypercube.TileHyperCube;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.Property;

public class HyperCubeRegister {
    private static final String CATEGORY_PUBLIC_CHANNELS = "PublicChannels";
    private static final String CATEGORY_PRIVATE_CHANNELS = "PrivateChannels";
    private static final String KEY_PUBLIC_CHANNELS = "names";
    public static HyperCubeRegister instance;
    private final Map channelMapping = new HashMap();
    private final List publicChannels = new ArrayList();
    private final List publicChannelsRO = Collections.unmodifiableList(this.publicChannels);
    private final Map userChannels = new HashMap();
    private Configuration config;

    public static void load() {
        instance = new HyperCubeRegister();
        instance.innerLoad();
    }

    public static void unload() {
        instance = new HyperCubeRegister();
    }

    private void innerLoad() {
        Property userNamesProp;
        String[] userNames;
        this.config = new Configuration(new File(DimensionManager.getCurrentSaveRootDirectory(), "/enderio/hypercubes.cfg"));
        this.config.load();
        Property pcNamesProp = this.config.get(CATEGORY_PUBLIC_CHANNELS, KEY_PUBLIC_CHANNELS, new String[0]);
        String[] pcNames = pcNamesProp.getStringList();
        if (pcNames != null) {
            for (String name : pcNames) {
                this.publicChannels.add(new Channel(name, null));
            }
        }
        if ((userNames = (userNamesProp = this.config.get(CATEGORY_PRIVATE_CHANNELS, "users", new String[0])).getStringList()) != null) {
            for (String user : userNames) {
                Property userChannles = this.config.get(CATEGORY_PRIVATE_CHANNELS, user + ".channels", new String[0]);
                String[] channelNames = userChannles.getStringList();
                if (channelNames == null || channelNames.length <= 0) continue;
                List channels = this.getChannelsForUser(user);
                for (String chanName : channelNames) {
                    channels.add(new Channel(chanName, user));
                }
            }
        }
    }

    public synchronized List getChannelsForUser(String user) {
        ArrayList result = (ArrayList)this.userChannels.get(user);
        if (result == null) {
            result = new ArrayList();
            this.userChannels.put(user, result);
        }
        return result;
    }

    public synchronized void register(TileHyperCube cube) {
        List cubes = this.innerGetCubesForChannel(cube.getChannel());
        if (cubes != null && !cubes.contains(cube)) {
            cubes.add(cube);
        }
    }

    public synchronized void deregister(TileHyperCube cube, Channel channel) {
        List cubes = this.innerGetCubesForChannel(channel);
        if (cubes != null) {
            cubes.remove(cube);
        }
    }

    public synchronized void deregister(TileHyperCube cube) {
        List cubes = this.innerGetCubesForChannel(cube.getChannel());
        if (cubes != null) {
            cubes.remove(cube);
        }
    }

    public synchronized List getCubesForChannel(Channel channel) {
        List chans = this.innerGetCubesForChannel(channel);
        if (chans == null) {
            return Collections.emptyList();
        }
        return new ArrayList(chans);
    }

    public synchronized void addChannel(Channel channel) {
        if (channel == null || channel.name == null) {
            return;
        }
        if (channel.user == null) {
            if (!this.publicChannels.contains(channel)) {
                this.publicChannels.add(channel);
                this.updateConfig();
            }
        } else {
            List channels = this.getChannelsForUser(channel.user);
            if (!channels.contains(channel)) {
                channels.add(channel);
                this.updateConfig();
            }
        }
    }

    public void removeChannel(Channel channel) {
        if (channel == null || channel.name == null) {
            return;
        }
        if (channel.user == null) {
            if (this.publicChannels.contains(channel)) {
                this.publicChannels.remove(channel);
                this.updateConfig();
            }
        } else {
            List channels = this.getChannelsForUser(channel.user);
            if (channels.contains(channel)) {
                channels.remove(channel);
                this.updateConfig();
            }
        }
    }

    private void updateConfig() {
        if (this.config == null) {
            Log.warn("HyperCubeRegister.updateConfig: Config was null.");
            return;
        }
        String[] publicNames = new String[this.publicChannels.size()];
        for (int i = 0; i < this.publicChannels.size(); ++i) {
            publicNames[i] = ((Channel)this.publicChannels.get((int)i)).name;
        }
        Property pcNamesProp = this.config.get(CATEGORY_PUBLIC_CHANNELS, KEY_PUBLIC_CHANNELS, new String[0]);
        pcNamesProp.set(publicNames);
        Set users = this.userChannels.keySet();
        Property userNamesProp = this.config.get(CATEGORY_PRIVATE_CHANNELS, "users", new String[0]);
        userNamesProp.set(users == null ? new String[]{} : users.toArray(new String[users.size()]));
        for (String user : users) {
            String[] channelNames;
            Property userChansProp = this.config.get(CATEGORY_PRIVATE_CHANNELS, user + ".channels", new String[0]);
            List val = (List)this.userChannels.get(user);
            if (val == null) {
                channelNames = new String[]{};
            } else {
                channelNames = new String[val.size()];
                int i = 0;
                for (Channel chan : val) {
                    channelNames[i] = chan.name;
                    ++i;
                }
            }
            userChansProp.set(channelNames);
        }
        this.config.save();
    }

    private List innerGetCubesForChannel(Channel channel) {
        if (channel == null) {
            return null;
        }
        ArrayList result = (ArrayList)this.channelMapping.get(channel);
        if (result == null) {
            result = new ArrayList();
            this.channelMapping.put(channel, result);
        }
        return result;
    }

    public List getPublicChannels() {
        return this.publicChannelsRO;
    }
}

