/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.hypercube;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import crazypants.enderio.Config;
import crazypants.enderio.PacketHandler;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.machine.hypercube.Channel;
import crazypants.enderio.machine.hypercube.HyperCubeRegister;
import crazypants.enderio.power.BasicCapacitor;
import crazypants.enderio.power.EnderPowerProvider;
import crazypants.enderio.power.IInternalPowerReceptor;
import crazypants.enderio.power.MutablePowerProvider;
import crazypants.enderio.power.PowerHandlerUtil;
import crazypants.util.BlockCoord;
import crazypants.vecmath.VecmathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.minecraftforge.common.ForgeDirection;

public class TileHyperCube
extends aqp
implements IInternalPowerReceptor {
    private static final float ENERGY_LOSS = (float)Config.transceiverEnergyLoss;
    private static final float ENERGY_UPKEEP = (float)Config.transceiverUpkeepCost;
    private RedstoneControlMode inputControlMode = RedstoneControlMode.IGNORE;
    private RedstoneControlMode outputControlMode = RedstoneControlMode.IGNORE;
    private boolean powerOutputEnabled = true;
    private boolean powerInputEnabled = true;
    private final BasicCapacitor internalCapacitor = new BasicCapacitor(Config.transceiverMaxIO, 25000);
    EnderPowerProvider powerHandler;
    private float lastSyncPowerStored = 0.0f;
    private final List receptors = new ArrayList();
    private ListIterator receptorIterator = this.receptors.listIterator();
    private boolean receptorsDirty = true;
    private EnderPowerProvider disabledPowerHandler;
    private Channel channel = null;
    private Channel registeredChannel = null;
    private String owner;
    private boolean init = true;

    public TileHyperCube() {
        this.powerHandler = PowerHandlerUtil.createHandler(this.internalCapacitor);
    }

    public RedstoneControlMode getInputControlMode() {
        return this.inputControlMode;
    }

    public void setInputControlMode(RedstoneControlMode powerInputControlMode) {
        this.inputControlMode = powerInputControlMode;
    }

    public RedstoneControlMode getOutputControlMode() {
        return this.outputControlMode;
    }

    public void setOutputControlMode(RedstoneControlMode powerOutputControlMode) {
        this.outputControlMode = powerOutputControlMode;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    int getEnergyStoredScaled(int scale) {
        return VecmathUtil.clamp(Math.round((float)scale * (this.powerHandler.getEnergyStored() / (float)this.powerHandler.getMaxEnergyStored())), 0, scale);
    }

    public void onBreakBlock() {
        HyperCubeRegister.instance.deregister(this);
    }

    public void onBlockAdded() {
        HyperCubeRegister.instance.register(this);
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    private boolean isConnected() {
        if (this.channel == null || HyperCubeRegister.instance == null) {
            return false;
        }
        List cons = HyperCubeRegister.instance.getCubesForChannel(this.channel);
        return cons != null && cons.size() > 1;
    }

    private void balanceCubeNetworkEnergy() {
        List cubes = HyperCubeRegister.instance.getCubesForChannel(this.channel);
        if (cubes == null || cubes.isEmpty()) {
            return;
        }
        float totalEnergy = 0.0f;
        for (TileHyperCube cube : cubes) {
            totalEnergy += cube.powerHandler.getEnergyStored();
        }
        float energyPerNode = totalEnergy / (float)cubes.size();
        float totalToTranfer = 0.0f;
        for (TileHyperCube cube : cubes) {
            if (!(cube.powerHandler.getEnergyStored() < energyPerNode)) continue;
            totalToTranfer += energyPerNode - cube.powerHandler.getEnergyStored();
        }
        float totalLoss = totalToTranfer * ENERGY_LOSS;
        energyPerNode = (totalEnergy -= totalLoss) / (float)cubes.size();
        for (TileHyperCube cube : cubes) {
            cube.powerHandler.setEnergy(energyPerNode);
        }
    }

    public void onChunkUnload() {
        if (HyperCubeRegister.instance != null) {
            HyperCubeRegister.instance.deregister(this);
        }
    }

    public void onNeighborBlockChange() {
        this.receptorsDirty = true;
    }

    public void h() {
        float storedEnergy;
        if (this.k == null) {
            return;
        }
        if (this.k.I) {
            return;
        }
        float stored = this.powerHandler.getEnergyStored();
        this.powerHandler.update(this);
        Math.max(stored -= ENERGY_UPKEEP, 0.0f);
        this.powerHandler.setEnergy(stored);
        if (this.registeredChannel == null ? this.channel != null : !this.registeredChannel.equals(this.channel)) {
            if (this.registeredChannel != null) {
                HyperCubeRegister.instance.deregister(this, this.registeredChannel);
            }
            HyperCubeRegister.instance.register(this);
            this.registeredChannel = this.channel;
        }
        this.balanceCubeNetworkEnergy();
        boolean requiresClientSync = false;
        this.powerInputEnabled = RedstoneControlMode.isConditionMet(this.inputControlMode, this);
        this.powerOutputEnabled = RedstoneControlMode.isConditionMet(this.outputControlMode, this);
        if (this.powerOutputEnabled) {
            this.transmitEnergy();
        }
        if (requiresClientSync |= this.lastSyncPowerStored != (storedEnergy = this.powerHandler.getEnergyStored()) && this.k.H() % 21L == 0L) {
            this.lastSyncPowerStored = storedEnergy;
            this.k.j(this.l, this.m, this.n);
            this.k.b(this.l, this.m, this.n, (aqp)this);
        }
    }

    private boolean transmitEnergy() {
        if (this.powerHandler.getEnergyStored() <= 0.0f) {
            return false;
        }
        float canTransmit = Math.min(this.powerHandler.getEnergyStored(), (float)this.internalCapacitor.getMaxEnergyExtracted());
        float transmitted = 0.0f;
        this.checkReceptors();
        if (!this.receptors.isEmpty() && !this.receptorIterator.hasNext()) {
            this.receptorIterator = this.receptors.listIterator();
        }
        int numReceptors = this.receptors.size();
        for (int appliedCount = 0; this.receptorIterator.hasNext() && canTransmit > 0.0f && appliedCount < numReceptors; ++appliedCount) {
            float boundCanTransmit;
            Receptor receptor = (Receptor)this.receptorIterator.next();
            IPowerProvider pp = receptor.receptor.getPowerProvider();
            if (pp != null && (float)pp.getMinEnergyReceived() <= canTransmit && !this.powerHandler.isPowerSource(receptor.fromDir) && (boundCanTransmit = Math.min(canTransmit, (float)pp.getMaxEnergyReceived())) > 0.0f) {
                float used;
                if (receptor.receptor instanceof IInternalPowerReceptor) {
                    used = PowerHandlerUtil.transmitInternal((IInternalPowerReceptor)receptor.receptor, canTransmit, receptor.fromDir.getOpposite());
                } else {
                    used = Math.min(canTransmit, (float)receptor.receptor.powerRequest(receptor.fromDir.getOpposite()));
                    used = Math.min(used, (float)pp.getMaxEnergyStored() - pp.getEnergyStored());
                    pp.receiveEnergy(used, receptor.fromDir.getOpposite());
                }
                transmitted += used;
                canTransmit -= used;
            }
            if (canTransmit <= 0.0f) break;
            if (this.receptors.isEmpty() || this.receptorIterator.hasNext()) continue;
            this.receptorIterator = this.receptors.listIterator();
        }
        this.powerHandler.setEnergy(this.powerHandler.getEnergyStored() - transmitted);
        return transmitted > 0.0f;
    }

    private EnderPowerProvider getDisabledPowerHandler() {
        if (this.disabledPowerHandler == null) {
            this.disabledPowerHandler = PowerHandlerUtil.createHandler(new BasicCapacitor(0, 0));
        }
        return this.disabledPowerHandler;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
    }

    @Override
    public IPowerProvider getPowerProvider() {
        if (this.powerInputEnabled) {
            return this.powerHandler;
        }
        return this.getDisabledPowerHandler();
    }

    @Override
    public void doWork() {
    }

    @Override
    public int powerRequest(ForgeDirection from) {
        if (this.powerInputEnabled) {
            return (int)Math.min((float)this.powerHandler.getMaxEnergyReceived(), (float)this.powerHandler.getMaxEnergyStored() - this.powerHandler.getEnergyStored());
        }
        return 0;
    }

    @Override
    public MutablePowerProvider getPowerHandler() {
        return this.powerHandler;
    }

    @Override
    public void applyPerdition() {
    }

    private void checkReceptors() {
        if (!this.receptorsDirty) {
            return;
        }
        this.receptors.clear();
        BlockCoord myLoc = new BlockCoord(this);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            BlockCoord checkLoc = myLoc.getLocation(dir);
            aqp te = this.k.r(checkLoc.x, checkLoc.y, checkLoc.z);
            if (!(te instanceof IPowerReceptor)) continue;
            IPowerReceptor rec = (IPowerReceptor)te;
            this.receptors.add(new Receptor((IPowerReceptor)te, dir));
        }
        this.receptorIterator = this.receptors.listIterator();
        this.receptorsDirty = false;
    }

    public void a(bs nbtRoot) {
        super.a(nbtRoot);
        this.powerHandler.setEnergy(nbtRoot.g("storedEnergy"));
        this.inputControlMode = RedstoneControlMode.values()[nbtRoot.d("inputControlMode")];
        this.outputControlMode = RedstoneControlMode.values()[nbtRoot.d("outputControlMode")];
        String channelName = nbtRoot.i("channelName");
        String channelUser = nbtRoot.i("channelUser");
        this.channel = channelName != null && !channelName.isEmpty() ? new Channel(channelName, channelUser.isEmpty() ? null : channelUser) : null;
        this.owner = nbtRoot.i("owner");
    }

    public void b(bs nbtRoot) {
        super.b(nbtRoot);
        nbtRoot.a("storedEnergy", this.powerHandler.getEnergyStored());
        nbtRoot.a("inputControlMode", (short)this.inputControlMode.ordinal());
        nbtRoot.a("outputControlMode", (short)this.outputControlMode.ordinal());
        if (this.channel == null) {
            nbtRoot.a("channelName", "");
            nbtRoot.a("channelUser", "");
        } else {
            nbtRoot.a("channelName", this.channel.name);
            nbtRoot.a("channelUser", this.channel.user == null ? "" : this.channel.user);
        }
        nbtRoot.a("owner", this.owner);
    }

    public ei m() {
        return PacketHandler.getPacket(this);
    }

    static class Receptor {
        IPowerReceptor receptor;
        ForgeDirection fromDir;

        private Receptor(IPowerReceptor rec, ForgeDirection fromDir) {
            this.receptor = rec;
            this.fromDir = fromDir;
        }
    }
}

