/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.light;

import buildcraft.api.power.IPowerProvider;
import crazypants.enderio.ModObject;
import crazypants.enderio.PacketHandler;
import crazypants.enderio.machine.light.TileLightNode;
import crazypants.enderio.power.Capacitors;
import crazypants.enderio.power.EnderPowerProvider;
import crazypants.enderio.power.IInternalPowerReceptor;
import crazypants.enderio.power.PowerHandlerUtil;
import crazypants.util.BlockCoord;
import crazypants.util.ForgeDirectionOffsets;
import crazypants.vecmath.Vector3d;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;

public class TileElectricLight
extends aqp
implements IInternalPowerReceptor {
    private ForgeDirection face = ForgeDirection.DOWN;
    public static final float MJ_USE_PER_TICK = 0.05f;
    protected EnderPowerProvider powerHandler;
    private boolean init = true;
    private List lightNodes;
    private int[] lightNodeCoords;
    private boolean updatingLightNodes = false;
    private boolean lastActive = false;

    public TileElectricLight() {
        this.powerHandler = PowerHandlerUtil.createHandler(Capacitors.BASIC_CAPACITOR.capacitor);
    }

    public void onNeighborBlockChange(int blockID) {
        this.init = true;
    }

    public void nodeNeighbourChanged(TileLightNode tileLightNode) {
        this.init = true;
    }

    public void nodeRemoved(TileLightNode tileLightNode) {
        if (!this.updatingLightNodes) {
            this.init = true;
        }
    }

    public ForgeDirection getFace() {
        return this.face;
    }

    public void setFace(ForgeDirection face) {
        this.face = face;
    }

    public void h() {
        boolean isActivated;
        if (this.k.I) {
            return;
        }
        boolean hasRedstone = this.hasRedstoneSignal();
        if (hasRedstone) {
            this.powerHandler.setEnergy(Math.max(0.0f, this.powerHandler.getEnergyStored() - 0.05f));
        }
        boolean bl = isActivated = this.hasPower() && hasRedstone;
        if (this.init) {
            this.updateLightNodes();
        }
        if (isActivated != this.lastActive || this.init) {
            this.k.b(this.l, this.m, this.n, isActivated ? 1 : 0, 2);
            for (TileLightNode ln : this.lightNodes) {
                if (ln == null) continue;
                this.k.b(ln.l, ln.m, ln.n, isActivated ? 1 : 0, 2);
                this.k.j(ln.l, ln.m, ln.n);
                this.k.c(aam.b, ln.l, ln.m, ln.n);
            }
            this.k.p(this.l, this.m, this.n);
            this.k.c(aam.b, this.l, this.m, this.n);
            this.init = false;
            this.lastActive = isActivated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBlockRemoved() {
        this.updatingLightNodes = true;
        try {
            this.clearLightNodes();
        }
        finally {
            this.updatingLightNodes = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLightNodes() {
        this.updatingLightNodes = true;
        ArrayList<NodeEntry> before = new ArrayList<NodeEntry>(17);
        if (this.lightNodes != null) {
            for (TileLightNode node : this.lightNodes) {
                before.add(new NodeEntry(node));
            }
        }
        ArrayList after = new ArrayList(17);
        try {
            if (this.lightNodeCoords != null) {
                this.lightNodes = new ArrayList();
                for (int i = 0; i < this.lightNodeCoords.length; i += 3) {
                    aqp te = this.k.r(this.lightNodeCoords[i], this.lightNodeCoords[i + 1], this.lightNodeCoords[i + 2]);
                    if (!(te instanceof TileLightNode)) continue;
                    this.lightNodes.add((TileLightNode)te);
                }
                this.lightNodeCoords = null;
            } else if (this.lightNodes == null) {
                this.lightNodes = new ArrayList();
            }
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (dir == this.face || dir == this.face.getOpposite()) continue;
                Vector3d offset = ForgeDirectionOffsets.forDirCopy(dir);
                this.addNodeInDirection(new Vector3d(offset), after);
                this.addNodeInDirection(offset.add(ForgeDirectionOffsets.forDirCopy(this.face.getOpposite())), after);
            }
            this.addNodeInDirection(ForgeDirectionOffsets.forDirCopy(this.face.getOpposite()), after);
            Vector3d[] diags = new Vector3d[2];
            if (this.face.offsetX != 0) {
                diags[0] = ForgeDirectionOffsets.forDirCopy(ForgeDirection.UP);
                diags[1] = ForgeDirectionOffsets.forDirCopy(ForgeDirection.SOUTH);
            } else if (this.face.offsetY != 0) {
                diags[0] = ForgeDirectionOffsets.forDirCopy(ForgeDirection.EAST);
                diags[1] = ForgeDirectionOffsets.forDirCopy(ForgeDirection.SOUTH);
            } else {
                diags[0] = ForgeDirectionOffsets.forDirCopy(ForgeDirection.UP);
                diags[1] = ForgeDirectionOffsets.forDirCopy(ForgeDirection.EAST);
            }
            this.addDiaganals(diags, new Vector3d(), after);
            this.addDiaganals(diags, ForgeDirectionOffsets.forDirCopy(this.face.getOpposite()), after);
            if (!this.areEqual(before, after)) {
                this.clearLightNodes();
                for (NodeEntry entry : after) {
                    this.k.c(entry.coord.x, entry.coord.y, entry.coord.z, ModObject.blockLightNode.actualId);
                    TileLightNode ln = (TileLightNode)this.k.r(entry.coord.x, entry.coord.y, entry.coord.z);
                    ln.parentX = this.l;
                    ln.parentY = this.m;
                    ln.parentZ = this.n;
                    ln.isDiagnal = entry.isDiagnal;
                    this.lightNodes.add(ln);
                }
            } else {
                this.init = false;
            }
        }
        finally {
            this.updatingLightNodes = false;
        }
    }

    private boolean areEqual(List before, List after) {
        if (before.size() != after.size()) {
            return false;
        }
        for (NodeEntry entry : before) {
            if (after.contains(entry)) continue;
            return false;
        }
        return true;
    }

    private void addDiaganals(Vector3d[] diags, Vector3d trans, List result) {
        Vector3d offset = new Vector3d();
        offset.set(diags[0]);
        offset.add(diags[1]);
        this.addNodeInDirection(offset.add(trans), true, result);
        offset.set(diags[0]);
        offset.sub(diags[1]);
        this.addNodeInDirection(offset.add(trans), true, result);
        offset.set(new Vector3d(diags[0]).negate());
        offset.add(diags[1]);
        this.addNodeInDirection(offset.add(trans), true, result);
        offset.set(new Vector3d(diags[0]).negate());
        offset.sub(diags[1]);
        this.addNodeInDirection(offset.add(trans), true, result);
    }

    private void addNodeInDirection(Vector3d offset, List after) {
        this.addNodeInDirection(offset, false, after);
    }

    private void addNodeInDirection(Vector3d offset, boolean diagnal, List result) {
        boolean isAir = this.isAir(offset);
        boolean isTransp = this.isTranparent(offset);
        if (isAir || isTransp) {
            offset.scale(2.0);
            if (this.isAir(offset)) {
                this.addLightNode(offset, diagnal, result);
            } else if (isAir) {
                offset.scale(0.5);
                this.addLightNode(offset, diagnal, result);
            }
        }
    }

    private boolean isLightNode(Vector3d offset) {
        return this.k.a(this.l + (int)offset.x, this.m + (int)offset.y, this.n + (int)offset.z) == ModObject.blockLightNode.actualId;
    }

    private void clearLightNodes() {
        if (this.lightNodes != null) {
            for (TileLightNode ln : this.lightNodes) {
                if (this.k.a(ln.l, ln.m, ln.n) != ModObject.blockLightNode.actualId) continue;
                this.k.i(ln.l, ln.m, ln.n);
            }
            this.lightNodes.clear();
        }
    }

    private void addLightNode(Vector3d offset, boolean isDiag, List result) {
        int x = this.l + (int)offset.x;
        int y = this.m + (int)offset.y;
        int z = this.n + (int)offset.z;
        if (this.isLightNode(offset)) {
            TileLightNode te = (TileLightNode)this.k.r(x, y, z);
            if (te.parentX != this.l || te.parentY != this.m || te.parentZ != this.n) {
                return;
            }
        }
        result.add(new NodeEntry(new BlockCoord(x, y, z), isDiag));
    }

    private boolean isRailcraftException(int id) {
        String className;
        return id > 0 && apa.r[id] != null && (className = apa.r[id].getClass().getName()).equals("mods.railcraft.common.blocks.machine.BlockMachine");
    }

    private boolean isTranparent(Vector3d offset) {
        int id = this.k.a(this.l + (int)offset.x, this.m + (int)offset.y, this.n + (int)offset.z);
        if (this.isRailcraftException(id)) {
            return false;
        }
        return this.k.getBlockLightOpacity(this.l + (int)offset.x, this.m + (int)offset.y, this.n + (int)offset.z) == 0;
    }

    private boolean isAir(Vector3d offset) {
        return this.k.c(this.l + (int)offset.x, this.m + (int)offset.y, this.n + (int)offset.z) || this.isLightNode(offset);
    }

    public void a(bs root) {
        super.a(root);
        this.face = ForgeDirection.values()[root.d("face")];
        float storedEnergy = root.g("storedEnergy");
        this.powerHandler.setEnergy(storedEnergy);
        this.lightNodeCoords = root.k("lightNodes");
    }

    public void b(bs root) {
        super.b(root);
        root.a("face", (short)this.face.ordinal());
        root.a("storedEnergy", this.powerHandler.getEnergyStored());
        if (this.lightNodes != null) {
            int[] lnLoc = new int[this.lightNodes.size() * 3];
            int index = 0;
            for (TileLightNode ln : this.lightNodes) {
                lnLoc[index++] = ln.l;
                lnLoc[index++] = ln.m;
                lnLoc[index++] = ln.n;
            }
            root.a("lightNodes", lnLoc);
        }
    }

    public boolean hasPower() {
        return this.powerHandler.getEnergyStored() > 0.05f;
    }

    private boolean hasRedstoneSignal() {
        return this.k.D(this.l, this.m, this.n) > 0;
    }

    public ei m() {
        return PacketHandler.getPacket(this);
    }

    @Override
    public void applyPerdition() {
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerHandler;
    }

    @Override
    public void doWork() {
    }

    @Override
    public int powerRequest(ForgeDirection from) {
        return (int)((float)this.powerHandler.getMaxEnergyStored() - this.powerHandler.getEnergyStored());
    }

    @Override
    public EnderPowerProvider getPowerHandler() {
        return this.powerHandler;
    }

    static class NodeEntry {
        final BlockCoord coord;
        final boolean isDiagnal;

        NodeEntry(BlockCoord coord, boolean isDiagnal) {
            this.coord = coord;
            this.isDiagnal = isDiagnal;
        }

        NodeEntry(TileLightNode node) {
            this.coord = new BlockCoord(node);
            this.isDiagnal = node.isDiagnal;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.coord == null ? 0 : this.coord.hashCode());
            result = 31 * result + (this.isDiagnal ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeEntry other = (NodeEntry)obj;
            if (this.coord == null ? other.coord != null : !this.coord.equals(other.coord)) {
                return false;
            }
            return this.isDiagnal == other.isDiagnal;
        }
    }
}

