/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.painter;

import crazypants.enderio.ModObject;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.RecipeInput;
import crazypants.enderio.machine.painter.PainterUtil;
import crazypants.util.Util;

public abstract class BasicPainterTemplate
implements IMachineRecipe {
    public static float DEFAULT_ENERGY_PER_TASK = 200.0f;
    protected final int[] validIds;

    public static boolean isValidSourceDefault(wm paintSource) {
        if (paintSource == null) {
            return false;
        }
        apa block = Util.getBlockFromItemId(paintSource.c);
        if (block == null) {
            return false;
        }
        return apa.l((int)block.cz) || block.cz == apa.Q.cz;
    }

    protected BasicPainterTemplate(int ... validTargetBlocksIds) {
        this.validIds = validTargetBlocksIds;
    }

    @Override
    public float getEnergyRequired(RecipeInput ... inputs) {
        return DEFAULT_ENERGY_PER_TASK;
    }

    @Override
    public boolean isRecipe(RecipeInput ... inputs) {
        return this.isValidTarget(this.getTarget(inputs)) && this.isValidPaintSource(this.getPaintSource(inputs));
    }

    @Override
    public wm[] getCompletedResult(float chance, RecipeInput ... inputs) {
        wm target = this.getTarget(inputs);
        wm paintSource = this.getPaintSource(inputs);
        if (target == null || paintSource == null) {
            return null;
        }
        wm result = new wm(this.getResultId(target), 1, target.k());
        PainterUtil.setSourceBlock(result, paintSource.c, paintSource.k());
        return new wm[]{result};
    }

    public wm getTarget(RecipeInput ... inputs) {
        return RecipeInput.getInputForSlot(0, inputs);
    }

    public wm getPaintSource(RecipeInput ... inputs) {
        return RecipeInput.getInputForSlot(1, inputs);
    }

    @Override
    public boolean isValidInput(RecipeInput input) {
        if (input == null) {
            return false;
        }
        if (input.slotNumber == 0) {
            return this.isValidTarget(input.item);
        }
        if (input.slotNumber == 1) {
            return this.isValidPaintSource(input.item);
        }
        return false;
    }

    @Override
    public String getMachineName() {
        return ModObject.blockPainter.unlocalisedName;
    }

    public boolean isValidPaintSource(wm paintSource) {
        return BasicPainterTemplate.isValidSourceDefault(paintSource);
    }

    public boolean isValidTarget(wm target) {
        if (target == null) {
            return false;
        }
        for (int i = 0; i < this.validIds.length; ++i) {
            if (this.validIds[i] != target.c) continue;
            return true;
        }
        apa blk = Util.getBlockFromItemId(target.c);
        if (blk == null) {
            return false;
        }
        for (int i = 0; i < this.validIds.length; ++i) {
            if (this.validIds[i] != blk.cz) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getUid() {
        return this.getClass().getCanonicalName();
    }

    protected int getResultId(wm target) {
        return target.c;
    }

    public int getQuantityConsumed(RecipeInput input) {
        return input.slotNumber == 0 ? 1 : 0;
    }

    @Override
    public RecipeInput[] getQuantitiesConsumed(RecipeInput[] inputs) {
        RecipeInput consume = null;
        for (RecipeInput input : inputs) {
            if (input == null || input.slotNumber != 0 || input.item == null) continue;
            wm consumed = input.item.m();
            consumed.a = 1;
            consume = new RecipeInput(input.slotNumber, consumed);
        }
        if (consume != null) {
            return new RecipeInput[]{consume};
        }
        return null;
    }

    @Override
    public float getExperianceForOutput(wm output) {
        return 0.0f;
    }
}

