/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.power;

import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.power.TileCapacitorBank;
import crazypants.enderio.power.PowerHandlerUtil;
import crazypants.render.BoundingBox;
import crazypants.render.CubeRenderer;
import crazypants.render.RenderUtil;
import crazypants.util.BlockCoord;
import crazypants.vecmath.Vector2f;
import crazypants.vecmath.Vector4d;
import crazypants.vecmath.Vertex;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class CapacitorBankRenderer
extends bje
implements IItemRenderer {
    private static final BlockCoord DEFAULT_BC = new BlockCoord(0, 0, 0);
    private static final BlockCoord[] DEFAULT_MB = new BlockCoord[]{DEFAULT_BC};
    private static final double PIXEL_SIZE = 0.0625;

    public boolean handleRenderType(wm item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, wm item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, wm item, Object ... data) {
        this.renderBlock(null, PowerHandlerUtil.getStoredEnergyForItem(item) / (float)TileCapacitorBank.BASE_CAP.getMaxEnergyStored());
    }

    public void a(aqp te, double x, double y, double z, float f) {
        if (!(te instanceof TileCapacitorBank)) {
            return;
        }
        Minecraft.x().u.a(0.0);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        TileCapacitorBank cb = (TileCapacitorBank)te;
        this.renderBlock(cb, cb.getEnergyStoredRatio());
        GL11.glPopMatrix();
        Minecraft.x().u.b(0.0);
    }

    private void renderBlock(TileCapacitorBank te, float filledRatio) {
        BlockCoord[] mb;
        BlockCoord myBC;
        RenderUtil.bindBlockTexture();
        bgd tes = bgd.a;
        if (te != null && te.isMultiblock()) {
            myBC = new BlockCoord(te);
            mb = te.multiblock;
        } else {
            myBC = DEFAULT_BC;
            mb = DEFAULT_MB;
        }
        List gaugeBounds = this.calculateGaugeBounds(myBC, mb);
        float brightness = te != null ? RenderUtil.claculateTotalBrightnessForLocation(te.k, te.l, te.m, te.n) : 1.0f;
        tes.b();
        tes.a(brightness, brightness, brightness, 1.0f);
        CubeRenderer.render(BoundingBox.UNIT_CUBE, EnderIO.blockCapacitorBank.a(0, 0));
        tes.a();
        GL11.glEnable((int)32823);
        GL11.glPolygonOffset((float)-1.0f, (float)-1.0f);
        tes.b();
        tes.a(brightness, brightness, brightness, 1.0f);
        if (te != null) {
            this.renderBorder((aak)te.k, te.l, te.m, te.n);
        } else {
            this.renderBorder(null, 0, 0, 0);
        }
        for (GaugeBounds gb : gaugeBounds) {
            this.renderGaugeOnFace(gb, EnderIO.blockCapacitorBank.overlayIcon);
        }
        tes.a();
        GL11.glPolygonOffset((float)-3.0f, (float)-3.0f);
        tes.b();
        tes.a(brightness, brightness, brightness, 1.0f);
        for (GaugeBounds gb : gaugeBounds) {
            this.renderFillBarOnFace(gb, EnderIO.blockCapacitorBank.fillBarIcon, filledRatio);
        }
        tes.a();
        GL11.glDisable((int)32823);
    }

    private void renderBorder(aak blockAccess, int x, int y, int z) {
        lx texture = EnderIO.blockAlloySmelter.m(3);
        for (ForgeDirection face : ForgeDirection.VALID_DIRECTIONS) {
            RenderUtil.renderConnectedTextureFace(blockAccess, x, y, z, face, texture, blockAccess == null, false, false);
        }
    }

    private List calculateGaugeBounds(BlockCoord me, BlockCoord[] mb) {
        ArrayList<GaugeBounds> res = new ArrayList<GaugeBounds>();
        for (ForgeDirection face : ForgeDirection.VALID_DIRECTIONS) {
            boolean isRight;
            if (face == ForgeDirection.UP || face == ForgeDirection.DOWN || !(isRight = this.isRightFace(me, mb, face))) continue;
            res.add(new GaugeBounds(me, mb, face));
        }
        return res;
    }

    private void renderGaugeOnFace(GaugeBounds gb, lx icon) {
        bgd tes = bgd.a;
        tes.b((float)gb.face.offsetX, (float)gb.face.offsetY, (float)gb.face.offsetZ);
        Vector2f u = gb.getMinMaxU(icon);
        List corners = gb.bb.getCornersWithUvForFace(gb.face, u.x, u.y, icon.g(), icon.h());
        for (Vertex coord : corners) {
            tes.b(coord.nx(), coord.ny(), coord.nz());
            tes.a(coord.x(), coord.y(), coord.z(), (double)coord.u(), (double)coord.v());
        }
    }

    private void renderFillBarOnFace(GaugeBounds gb, lx icon, float filledRatio) {
        int totalPixels;
        int targetPixelCount;
        int pixelsBellowFace = gb.vInfo.index < 2 ? gb.vInfo.index * VPos.BOTTOM.numFillPixels : VPos.BOTTOM.numFillPixels + VPos.MIDDLE.numFillPixels * (gb.vInfo.index - 1);
        if (pixelsBellowFace >= (targetPixelCount = Math.max(0, Math.round((float)(totalPixels = gb.vInfo.verticalHeight == 1 ? VPos.SINGLE_BLOCK.numFillPixels : VPos.BOTTOM.numFillPixels + VPos.TOP.numFillPixels + VPos.MIDDLE.numFillPixels * (gb.vInfo.verticalHeight - 2)) * filledRatio)))) {
            return;
        }
        VPos yPos = gb.vInfo.pos;
        int numPixelsLeft = targetPixelCount - pixelsBellowFace;
        int fillPixels = Math.min(numPixelsLeft, yPos.numFillPixels);
        double maxY = (double)yPos.fillOffset * 0.0625 + (double)fillPixels * 0.0625;
        float vWidth = icon.h() - icon.g();
        float maxV = icon.g() + (float)maxY * vWidth;
        bgd tes = bgd.a;
        tes.b((float)gb.face.offsetX, (float)gb.face.offsetY, (float)gb.face.offsetZ);
        Vector2f u = gb.getMinMaxU(icon);
        List corners = gb.bb.getCornersWithUvForFace(gb.face, u.x, u.y, icon.g(), maxV);
        for (Vertex coord : corners) {
            tes.a(coord.x(), Math.min(coord.y(), maxY), coord.z(), (double)coord.u(), (double)coord.v());
        }
    }

    private boolean isRightFace(BlockCoord me, BlockCoord[] mb, ForgeDirection dir) {
        int myRightVal;
        Vector4d uPlane = RenderUtil.getUPlaneForFace(dir);
        int max = myRightVal = (int)uPlane.x * me.x + (int)uPlane.y * me.y + (int)uPlane.z * me.z;
        for (BlockCoord bc : mb) {
            int val = (int)uPlane.x * bc.x + (int)uPlane.y * bc.y + (int)uPlane.z * bc.z;
            if (val <= max) continue;
            max = val;
        }
        return myRightVal == max;
    }

    static class GaugeBounds {
        final BoundingBox bb;
        final VInfo vInfo;
        final ForgeDirection face;

        GaugeBounds(BlockCoord me, BlockCoord[] mb, ForgeDirection face) {
            this.face = face;
            this.vInfo = this.getVPosForFace(me, mb, face);
            Vector4d uPlane = RenderUtil.getUPlaneForFace(face);
            float scaleX = uPlane.x != 0.0 ? 0.25f : 1.0f;
            float scaleY = uPlane.y != 0.0 ? 0.25f : 1.0f;
            float scaleZ = uPlane.z != 0.0 ? 0.25f : 1.0f;
            this.bb = BoundingBox.UNIT_CUBE.scale(scaleX, scaleY, scaleZ);
        }

        Vector2f getMinMaxU(lx icon) {
            VPos yPos = this.vInfo.pos;
            float uWidth = icon.f() - icon.e();
            float uOffset = yPos.uOffset * uWidth;
            float minU = icon.e() + uOffset;
            float maxU = minU + uWidth * 0.25f;
            return new Vector2f(minU, maxU);
        }

        private VInfo getVPosForFace(BlockCoord me, BlockCoord[] mb, ForgeDirection face) {
            int maxY = me.y;
            int minY = me.y;
            boolean vHeight = true;
            for (BlockCoord bc : mb) {
                if (bc.x != me.x || bc.z != me.z || this.containsLocaction(mb, bc.getLocation(face))) continue;
                maxY = Math.max(maxY, bc.y);
                minY = Math.min(minY, bc.y);
            }
            if (maxY == me.y && minY == me.y) {
                return new VInfo(VPos.SINGLE_BLOCK, 1, 0);
            }
            int height = maxY - minY + 1;
            if (maxY > me.y) {
                return me.y > minY ? new VInfo(VPos.MIDDLE, height, me.y - minY) : new VInfo(VPos.BOTTOM, height, 0);
            }
            return new VInfo(VPos.TOP, height, height - 1);
        }

        private boolean containsLocaction(BlockCoord[] mb, BlockCoord location) {
            for (BlockCoord bc : mb) {
                if (!location.equals(bc)) continue;
                return true;
            }
            return false;
        }
    }

    static class VInfo {
        VPos pos;
        int verticalHeight;
        int index;

        VInfo(VPos pos, int verticalHeight, int index) {
            this.pos = pos;
            this.verticalHeight = verticalHeight;
            this.index = index;
        }
    }

    static enum VPos {
        SINGLE_BLOCK(0.0f, 10, 3),
        BOTTOM(0.5f, 13, 3),
        MIDDLE(0.75f, 16, 0),
        TOP(0.25f, 13, 0);

        final float uOffset;
        final int numFillPixels;
        final int fillOffset;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private VPos(int uOffset) {
            void fillOffset;
            void numFillPixels;
            this.uOffset = uOffset;
            this.numFillPixels = numFillPixels;
            this.fillOffset = fillOffset;
        }
    }
}

