/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.power;

import cpw.mods.fml.common.network.PacketDispatcher;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.machine.RedstoneModePacketProcessor;
import crazypants.enderio.machine.power.BlockCapacitorBank;
import crazypants.enderio.machine.power.TileCapacitorBank;
import crazypants.gui.GuiScreenBase;
import crazypants.gui.GuiToolTip;
import crazypants.gui.IconButton;
import crazypants.render.RenderUtil;
import java.awt.Rectangle;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class GuiCapacitorBank
extends GuiScreenBase {
    protected static final int INPUT_BUTTON_ID = 18;
    protected static final int OUTPUT_BUTTON_ID = 37;
    private static final int POWER_X = 15;
    private static final int POWER_Y = 7;
    private static final int POWER_WIDTH = 10;
    private static final int POWER_HEIGHT = 75;
    protected static final int BOTTOM_POWER_Y = 82;
    private final TileCapacitorBank capBank;
    private IconButton inputRedstoneButton;
    private IconButton outputRedstoneButton;

    public GuiCapacitorBank(TileCapacitorBank te) {
        super(97, 88);
        this.capBank = te;
        this.addToolTip(new GuiToolTip(new Rectangle(15, 7, 10, 75), new String[]{""}){

            @Override
            protected void updateText() {
                this.text.clear();
                this.text.add(BlockCapacitorBank.NF.format(Math.round(GuiCapacitorBank.this.capBank.getEnergyStored())) + " MJ");
            }
        });
        this.addToolTip(new GuiToolTip(new Rectangle(0, 0, 0, 0), new String[]{""}){

            @Override
            protected void updateText() {
                this.text.clear();
                this.text.add("Input Redstone Mode");
                this.text.add(((GuiCapacitorBank)GuiCapacitorBank.this).capBank.getInputControlMode().tooltip);
            }

            @Override
            public void onTick(int mouseX, int mouseY) {
                this.bounds.setBounds(GuiCapacitorBank.this.xSize - 5 - 16, 5, 16, 16);
                super.onTick(mouseX, mouseY);
            }
        });
        this.addToolTip(new GuiToolTip(new Rectangle(0, 0, 0, 0), new String[]{""}){

            @Override
            protected void updateText() {
                this.text.clear();
                this.text.add("Output Redstone Mode");
                this.text.add(((GuiCapacitorBank)GuiCapacitorBank.this).capBank.getOutputControlMode().tooltip);
            }

            @Override
            public void onTick(int mouseX, int mouseY) {
                this.bounds.setBounds(GuiCapacitorBank.this.xSize - 5 - 16, 26, 16, 16);
                super.onTick(mouseX, mouseY);
            }
        });
    }

    protected void a(awg par1GuiButton) {
        if (par1GuiButton.f == 18) {
            int ordinal = this.capBank.getInputControlMode().ordinal();
            if (++ordinal >= RedstoneControlMode.values().length) {
                ordinal = 0;
            }
            this.capBank.setInputControlMode(RedstoneControlMode.values()[ordinal]);
            this.inputRedstoneButton.setIcon(AbstractMachineBlock.getRedstoneControlIcon(this.capBank.getInputControlMode()));
            ei pkt = RedstoneModePacketProcessor.getRedstoneControlPacket(this.capBank);
            PacketDispatcher.sendPacketToServer((ei)pkt);
        } else if (par1GuiButton.f == 37) {
            int ordinal = this.capBank.getOutputControlMode().ordinal();
            if (++ordinal >= RedstoneControlMode.values().length) {
                ordinal = 0;
            }
            this.capBank.setOutputControlMode(RedstoneControlMode.values()[ordinal]);
            this.outputRedstoneButton.setIcon(AbstractMachineBlock.getRedstoneControlIcon(this.capBank.getOutputControlMode()));
            ei pkt = RedstoneModePacketProcessor.getRedstoneControlPacket(this.capBank);
            PacketDispatcher.sendPacketToServer((ei)pkt);
        }
    }

    public boolean f() {
        return false;
    }

    @Override
    public void A_() {
        super.A_();
        int x = this.guiLeft + this.xSize - 5 - 16;
        int y = this.guiTop + 5;
        this.inputRedstoneButton = new IconButton(this.m, 18, x, y, AbstractMachineBlock.getRedstoneControlIcon(this.capBank.getInputControlMode()), "/terrain.png");
        this.inputRedstoneButton.setSize(16, 16);
        this.k.add(this.inputRedstoneButton);
        y = y + 5 + 16;
        this.outputRedstoneButton = new IconButton(this.m, 37, x, y, AbstractMachineBlock.getRedstoneControlIcon(this.capBank.getOutputControlMode()), "/terrain.png");
        this.outputRedstoneButton.setSize(16, 16);
        this.k.add(this.outputRedstoneButton);
    }

    protected void a(char par1, int par2) {
        super.a(par1, par2);
        if (par1 == 'e') {
            super.a(par1, 1);
        }
    }

    @Override
    protected void drawBackgroundLayer(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtil.bindTexture("/mods/enderio/textures/gui/capacitorBank.png");
        int sx = (this.h - this.xSize) / 2;
        int sy = (this.i - this.ySize) / 2;
        this.b(sx, sy, 0, 0, this.xSize, this.ySize);
        int i1 = this.capBank.getEnergyStoredScaled(75);
        this.b(sx + 15, sy + 82 - i1, 97, 0, 10, i1);
        for (int i = 0; i < this.k.size(); ++i) {
            awg guibutton = (awg)this.k.get(i);
            guibutton.a(this.g, 0, 0);
        }
        int midX = sx + this.xSize / 2;
        String str = "Max Storage " + BlockCapacitorBank.NF.format(this.capBank.getMaxEnergyStored()) + " MJ";
        int swid = this.m.a(str);
        int x = midX - swid / 2;
        int y = this.guiTop - 5 - this.m.a - 5 - this.m.a;
        this.b(this.m, str, x, y, -1);
        str = "Max I/O " + BlockCapacitorBank.NF.format(this.capBank.getMaxIO()) + " MJ/t";
        swid = this.m.a(str);
        x = midX - swid / 2;
        this.b(this.m, str, x, y += this.m.a + 5, -1);
    }

    @Override
    public void drawHoveringText(List par1List, int par2, int par3, awv font) {
        GL11.glPushAttrib((int)8192);
        GL11.glPushAttrib((int)64);
        super.drawHoveringText(par1List, par2, par3, font);
        GL11.glPopAttrib();
        GL11.glPopAttrib();
    }

    @Override
    public int getGuiLeft() {
        return this.guiLeft;
    }

    @Override
    public int getGuiTop() {
        return this.guiTop;
    }

    @Override
    public int getXSize() {
        return this.xSize;
    }

    @Override
    public awv getFontRenderer() {
        return this.m;
    }
}

