/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.power;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import crazypants.enderio.ModObject;
import crazypants.enderio.PacketHandler;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.power.IPowerConduit;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.power.BasicCapacitor;
import crazypants.enderio.power.EnderPowerProvider;
import crazypants.enderio.power.IInternalPowerReceptor;
import crazypants.enderio.power.PowerHandlerUtil;
import crazypants.util.BlockCoord;
import crazypants.vecmath.VecmathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.minecraftforge.common.ForgeDirection;

public class TileCapacitorBank
extends aqp
implements IInternalPowerReceptor {
    static final BasicCapacitor BASE_CAP = new BasicCapacitor(100, 250000);
    BlockCoord[] multiblock = null;
    private EnderPowerProvider powerHandler;
    private float lastSyncPowerStored;
    private float storedEnergy = 0.0f;
    private int maxStoredEnergy;
    private int maxIO;
    private boolean multiblockDirty = false;
    private RedstoneControlMode inputControlMode;
    private RedstoneControlMode outputControlMode;
    private boolean outputEnabled;
    private boolean inputEnabled;
    private final List receptors = new ArrayList();
    private ListIterator receptorIterator = this.receptors.listIterator();
    private boolean receptorsDirty = true;
    private EnderPowerProvider disabledPowerHandler;

    public TileCapacitorBank() {
        this.inputControlMode = RedstoneControlMode.IGNORE;
        this.outputControlMode = RedstoneControlMode.IGNORE;
        this.maxStoredEnergy = BASE_CAP.getMaxEnergyStored();
        this.maxIO = BASE_CAP.getMaxEnergyExtracted();
        this.updatePowerHandler();
    }

    public void h() {
        if (this.k == null) {
            return;
        }
        if (this.k.I) {
            return;
        }
        if (this.multiblockDirty) {
            this.formMultiblock();
            this.multiblockDirty = false;
        }
        if (!this.isContoller()) {
            return;
        }
        float stored = this.powerHandler.getEnergyStored();
        this.powerHandler.update(this);
        this.powerHandler.setEnergy(stored);
        boolean requiresClientSync = false;
        boolean hasSignal = this.isRecievingRedstoneSignal();
        if (this.inputControlMode == RedstoneControlMode.IGNORE) {
            this.inputEnabled = true;
        } else if (this.inputControlMode == RedstoneControlMode.NEVER) {
            this.inputEnabled = false;
        } else {
            boolean bl = this.inputEnabled = this.inputControlMode == RedstoneControlMode.ON && hasSignal || this.inputControlMode == RedstoneControlMode.OFF && !hasSignal;
        }
        if (this.outputControlMode == RedstoneControlMode.IGNORE) {
            this.outputEnabled = true;
        } else if (this.outputControlMode == RedstoneControlMode.NEVER) {
            this.outputEnabled = false;
        } else {
            boolean bl = this.outputEnabled = this.outputControlMode == RedstoneControlMode.ON && hasSignal || this.outputControlMode == RedstoneControlMode.OFF && !hasSignal;
        }
        if (this.outputEnabled) {
            this.transmitEnergy();
        }
        this.storedEnergy = this.powerHandler.getEnergyStored();
        if (requiresClientSync |= this.lastSyncPowerStored != this.storedEnergy && this.k.H() % 21L == 0L) {
            this.lastSyncPowerStored = this.storedEnergy;
            this.k.j(this.l, this.m, this.n);
            this.k.b(this.l, this.m, this.n, (aqp)this);
        }
    }

    public boolean isOutputEnabled() {
        return this.getController().outputEnabled;
    }

    public boolean isInputEnabled() {
        return this.getController().inputEnabled;
    }

    private boolean transmitEnergy() {
        if (this.powerHandler.getEnergyStored() <= 0.0f) {
            return false;
        }
        float canTransmit = Math.min(this.storedEnergy, (float)this.maxIO);
        float transmitted = 0.0f;
        this.checkReceptors();
        if (!this.receptors.isEmpty() && !this.receptorIterator.hasNext()) {
            this.receptorIterator = this.receptors.listIterator();
        }
        int numReceptors = this.receptors.size();
        for (int appliedCount = 0; this.receptorIterator.hasNext() && canTransmit > 0.0f && appliedCount < numReceptors; ++appliedCount) {
            Receptor receptor = (Receptor)this.receptorIterator.next();
            IPowerProvider pp = receptor.receptor.getPowerProvider();
            if (pp != null && (float)pp.getMinEnergyReceived() <= canTransmit && !this.powerHandler.isPowerSource(receptor.fromDir)) {
                float used = 0.0f;
                if (receptor.receptor instanceof IInternalPowerReceptor) {
                    IConduitBundle bundle;
                    IPowerConduit conduit;
                    used = !(receptor.receptor instanceof IConduitBundle) ? PowerHandlerUtil.transmitInternal((IInternalPowerReceptor)receptor.receptor, canTransmit, receptor.fromDir.getOpposite()) : ((conduit = (IPowerConduit)(bundle = (IConduitBundle)receptor.receptor).getConduit(IPowerConduit.class)) != null && conduit.getConectionMode(receptor.fromDir.getOpposite()) == ConnectionMode.INPUT ? PowerHandlerUtil.transmitInternal((IInternalPowerReceptor)receptor.receptor, canTransmit, receptor.fromDir.getOpposite()) : 0.0f);
                } else {
                    used = Math.min(canTransmit, (float)receptor.receptor.powerRequest(receptor.fromDir.getOpposite()));
                    used = Math.min(used, (float)pp.getMaxEnergyStored() - pp.getEnergyStored());
                    pp.receiveEnergy(used, receptor.fromDir.getOpposite());
                }
                transmitted += used;
                canTransmit -= used;
            }
            if (canTransmit <= 0.0f) break;
            if (this.receptors.isEmpty() || this.receptorIterator.hasNext()) continue;
            this.receptorIterator = this.receptors.listIterator();
        }
        this.powerHandler.setEnergy(this.powerHandler.getEnergyStored() - transmitted);
        return transmitted > 0.0f;
    }

    private void checkReceptors() {
        if (!this.receptorsDirty) {
            return;
        }
        this.receptors.clear();
        BlockCoord[] coords = this.isMultiblock() ? this.multiblock : new BlockCoord[]{new BlockCoord(this)};
        for (BlockCoord bc : coords) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                BlockCoord checkLoc = bc.getLocation(dir);
                aqp te = this.k.r(checkLoc.x, checkLoc.y, checkLoc.z);
                if (!(te instanceof IPowerReceptor)) continue;
                IPowerReceptor rec = (IPowerReceptor)te;
                if (te instanceof TileCapacitorBank) continue;
                this.receptors.add(new Receptor((IPowerReceptor)te, dir));
            }
        }
        this.receptorIterator = this.receptors.listIterator();
        this.receptorsDirty = false;
    }

    public int getEnergyStoredScaled(int scale) {
        return this.getController().doGetEnergyStoredScaled(scale);
    }

    public float getEnergyStored() {
        return this.getController().doGetEnergyStored();
    }

    public float getEnergyStoredRatio() {
        return this.getController().doGetEnergyStoredRatio();
    }

    public int getMaxEnergyStored() {
        return this.getController().doGetMaxEnergyStored();
    }

    public int getMaxIO() {
        return this.getController().doGetMaxIO();
    }

    @Override
    public EnderPowerProvider getPowerHandler() {
        return this.getController().doGetPowerHandler();
    }

    public void addEnergy(float add) {
        this.getController().doAddEnergy(add);
    }

    private boolean isRecievingRedstoneSignal() {
        if (!this.isMultiblock()) {
            return this.k.D(this.l, this.m, this.n) > 0;
        }
        for (BlockCoord bc : this.multiblock) {
            if (this.k.D(bc.x, bc.y, bc.z) <= 0) continue;
            return true;
        }
        return false;
    }

    public RedstoneControlMode getInputControlMode() {
        return this.inputControlMode;
    }

    public void setInputControlMode(RedstoneControlMode inputControlMode) {
        if (!this.isMultiblock()) {
            this.inputControlMode = inputControlMode;
        } else {
            for (BlockCoord bc : this.multiblock) {
                TileCapacitorBank cp = this.getCapBank(bc);
                if (cp == null) continue;
                cp.inputControlMode = inputControlMode;
            }
        }
    }

    public RedstoneControlMode getOutputControlMode() {
        return this.outputControlMode;
    }

    public void setOutputControlMode(RedstoneControlMode outputControlMode) {
        if (!this.isMultiblock()) {
            this.outputControlMode = outputControlMode;
        } else {
            for (BlockCoord bc : this.multiblock) {
                TileCapacitorBank cp = this.getCapBank(bc);
                if (cp == null) continue;
                cp.outputControlMode = outputControlMode;
            }
        }
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.getController().doGetPowerHandler();
    }

    @Override
    public int powerRequest(ForgeDirection from) {
        return this.getController().doGetPowerRequest(from);
    }

    private int doGetPowerRequest(ForgeDirection from) {
        if (!this.inputEnabled) {
            return 0;
        }
        return (int)Math.min((float)this.maxIO, (float)this.powerHandler.getMaxEnergyStored() - this.powerHandler.getEnergyStored());
    }

    int doGetMaxIO() {
        return this.maxIO;
    }

    int doGetMaxEnergyStored() {
        return this.maxStoredEnergy;
    }

    EnderPowerProvider doGetPowerHandler() {
        if (this.inputEnabled) {
            return this.powerHandler;
        }
        return this.getDisabledPowerHandler();
    }

    private EnderPowerProvider getDisabledPowerHandler() {
        if (this.disabledPowerHandler == null) {
            this.disabledPowerHandler = PowerHandlerUtil.createHandler(new BasicCapacitor(0, 0));
        }
        return this.disabledPowerHandler;
    }

    int doGetEnergyStoredScaled(int scale) {
        return VecmathUtil.clamp(Math.round((float)scale * (this.storedEnergy / (float)this.maxStoredEnergy)), 0, scale);
    }

    float doGetEnergyStored() {
        return this.storedEnergy;
    }

    float doGetEnergyStoredRatio() {
        return this.storedEnergy / (float)this.maxStoredEnergy;
    }

    void doAddEnergy(float add) {
        this.storedEnergy = Math.min((float)this.maxStoredEnergy, this.storedEnergy + add);
        this.powerHandler.setEnergy(this.storedEnergy);
    }

    @Override
    public void applyPerdition() {
    }

    private void updatePowerHandler() {
        this.powerHandler = PowerHandlerUtil.createHandler(new BasicCapacitor(this.maxIO, this.maxStoredEnergy));
        if (this.storedEnergy > (float)this.maxStoredEnergy) {
            this.storedEnergy = this.maxStoredEnergy;
        }
        this.powerHandler.setEnergy(this.storedEnergy);
    }

    @Override
    public void doWork() {
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
    }

    public void onBlockAdded() {
        this.multiblockDirty = true;
    }

    public void onNeighborBlockChange(int blockId) {
        if (blockId != ModObject.blockCapacitorBank.actualId) {
            this.getController().receptorsDirty = true;
        }
    }

    public void onBreakBlock() {
        TileCapacitorBank controller = this.getController();
        controller.clearCurrentMultiblock();
    }

    private void clearCurrentMultiblock() {
        if (this.multiblock == null) {
            return;
        }
        for (BlockCoord bc : this.multiblock) {
            TileCapacitorBank res = this.getCapBank(bc);
            if (res == null) continue;
            res.setMultiblock(null);
        }
        this.multiblock = null;
    }

    private void formMultiblock() {
        ArrayList<TileCapacitorBank> blocks = new ArrayList<TileCapacitorBank>();
        blocks.add(this);
        this.findNighbouringBanks(this, blocks);
        if (blocks.size() < 2) {
            return;
        }
        for (TileCapacitorBank cb : blocks) {
            cb.clearCurrentMultiblock();
        }
        BlockCoord[] mb = new BlockCoord[blocks.size()];
        for (int i = 0; i < blocks.size(); ++i) {
            mb[i] = new BlockCoord((aqp)blocks.get(i));
        }
        for (TileCapacitorBank cb : blocks) {
            cb.setMultiblock(mb);
        }
    }

    private void findNighbouringBanks(TileCapacitorBank tileCapacitorBank, List blocks) {
        BlockCoord bc = new BlockCoord(tileCapacitorBank);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TileCapacitorBank cb = this.getCapBank(bc.getLocation(dir));
            if (cb == null || blocks.contains(cb)) continue;
            blocks.add(cb);
            this.findNighbouringBanks(cb, blocks);
        }
    }

    private void setMultiblock(BlockCoord[] mb) {
        if (this.multiblock != null && this.isMaster()) {
            float powerPerBlock = this.storedEnergy / (float)this.multiblock.length;
            for (BlockCoord bc : this.multiblock) {
                TileCapacitorBank cb = this.getCapBank(bc);
                if (cb == null) continue;
                cb.maxStoredEnergy = BASE_CAP.getMaxEnergyStored();
                cb.maxIO = BASE_CAP.getMaxEnergyExtracted();
                cb.storedEnergy = powerPerBlock;
                cb.updatePowerHandler();
                cb.multiblockDirty = true;
            }
        }
        this.multiblock = mb;
        if (this.isMaster()) {
            float totalStored = 0.0f;
            int totalCap = this.multiblock.length * BASE_CAP.getMaxEnergyStored();
            int totalIO = this.multiblock.length * BASE_CAP.getMaxEnergyExtracted();
            for (BlockCoord bc : this.multiblock) {
                TileCapacitorBank cb = this.getCapBank(bc);
                if (cb == null) continue;
                totalStored += cb.storedEnergy;
                cb.multiblockDirty = false;
            }
            this.storedEnergy = totalStored;
            this.maxStoredEnergy = totalCap;
            this.maxIO = totalIO;
            this.updatePowerHandler();
        }
        this.receptorsDirty = true;
        this.k.j(this.l, this.m, this.n);
        this.k.b(this.l, this.m, this.n, this.isMultiblock() ? 1 : 0, 2);
    }

    TileCapacitorBank getController() {
        if (this.isMaster() || !this.isMultiblock()) {
            return this;
        }
        TileCapacitorBank res = this.getCapBank(this.multiblock[0]);
        return res != null ? res : this;
    }

    boolean isContoller() {
        return this.multiblock == null ? true : this.isMaster();
    }

    boolean isMaster() {
        if (this.multiblock != null) {
            return this.multiblock[0].equals(this.l, this.m, this.n);
        }
        return false;
    }

    public boolean isMultiblock() {
        return this.multiblock != null;
    }

    private boolean isCurrentMultiblockValid() {
        if (this.multiblock == null) {
            return false;
        }
        for (BlockCoord bc : this.multiblock) {
            TileCapacitorBank res = this.getCapBank(bc);
            if (res != null && res.isMultiblock()) continue;
            return false;
        }
        return true;
    }

    private TileCapacitorBank getCapBank(BlockCoord bc) {
        return this.getCapBank(bc.x, bc.y, bc.z);
    }

    private TileCapacitorBank getCapBank(int x, int y, int z) {
        aqp te = this.k.r(x, y, z);
        if (te instanceof TileCapacitorBank) {
            return (TileCapacitorBank)te;
        }
        return null;
    }

    public void a(bs nbtRoot) {
        super.a(nbtRoot);
        this.storedEnergy = nbtRoot.g("storedEnergy");
        this.maxStoredEnergy = nbtRoot.e("maxStoredEnergy");
        this.maxIO = nbtRoot.e("maxIO");
        this.inputControlMode = RedstoneControlMode.values()[nbtRoot.d("inputControlMode")];
        this.outputControlMode = RedstoneControlMode.values()[nbtRoot.d("outputControlMode")];
        this.updatePowerHandler();
        boolean wasMulti = this.isMultiblock();
        if (nbtRoot.n("isMultiblock")) {
            int[] coords = nbtRoot.k("multiblock");
            this.multiblock = new BlockCoord[coords.length / 3];
            int c = 0;
            for (int i = 0; i < this.multiblock.length; ++i) {
                this.multiblock[i] = new BlockCoord(coords[c++], coords[c++], coords[c++]);
            }
        } else {
            this.multiblock = null;
        }
    }

    public void b(bs nbtRoot) {
        super.b(nbtRoot);
        nbtRoot.a("storedEnergy", this.storedEnergy);
        nbtRoot.a("maxStoredEnergy", this.maxStoredEnergy);
        nbtRoot.a("maxIO", this.maxIO);
        nbtRoot.a("inputControlMode", (short)this.inputControlMode.ordinal());
        nbtRoot.a("outputControlMode", (short)this.outputControlMode.ordinal());
        nbtRoot.a("isMultiblock", this.isMultiblock());
        if (this.isMultiblock()) {
            int[] vals = new int[this.multiblock.length * 3];
            int i = 0;
            for (BlockCoord bc : this.multiblock) {
                vals[i++] = bc.x;
                vals[i++] = bc.y;
                vals[i++] = bc.z;
            }
            nbtRoot.a("multiblock", vals);
        }
    }

    public ei m() {
        return PacketHandler.getPacket(this);
    }

    static class Receptor {
        IPowerReceptor receptor;
        ForgeDirection fromDir;

        private Receptor(IPowerReceptor rec, ForgeDirection fromDir) {
            this.receptor = rec;
            this.fromDir = fromDir;
        }
    }
}

