/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.reservoir;

import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;

public class ReservoirTank
extends LiquidTank {
    static final LiquidStack WATER = LiquidDictionary.getLiquid((String)"Water", (int)0);

    ReservoirTank(int quantity, int capacity) {
        super(ReservoirTank.WATER.itemID, quantity, capacity);
    }

    ReservoirTank(int capacity) {
        this(0, capacity);
    }

    ReservoirTank(LiquidStack liquid, int capacity) {
        super(liquid, capacity);
    }

    public int getAmount() {
        return this.getLiquid().amount;
    }

    public float getFilledRatio() {
        return (float)this.getAmount() / (float)this.getCapacity();
    }

    public boolean isFull() {
        return this.getAmount() >= this.getCapacity();
    }

    public void setAmount(int amount) {
        LiquidStack newLiquid = WATER.copy();
        newLiquid.amount = Math.min(this.getCapacity(), amount);
        this.setLiquid(newLiquid);
    }

    public LiquidStack getLiquid() {
        LiquidStack l = super.getLiquid();
        if (l == null) {
            l = WATER.copy();
            this.setLiquid(l);
        }
        return l;
    }

    public int getAvailableSpace() {
        return this.getCapacity() - this.getAmount();
    }

    public void addAmount(int amount) {
        this.setAmount(this.getAmount() + amount);
    }

    public void setCapacity(int capacity) {
        super.setCapacity(capacity);
        if (this.getAmount() > capacity) {
            this.setAmount(capacity);
        }
    }
}

