/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.reservoir;

import crazypants.enderio.ModObject;
import crazypants.enderio.PacketHandler;
import crazypants.enderio.machine.reservoir.ReservoirTank;
import crazypants.enderio.machine.reservoir.TankNeighbour;
import crazypants.render.BoundingBox;
import crazypants.util.BlockCoord;
import crazypants.vecmath.Vector3f;
import java.util.ArrayList;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;

public class TileReservoir
extends aqp
implements ITankContainer {
    static final LiquidStack WATER_BUCKET = LiquidDictionary.getLiquid((String)"Water", (int)1000);
    BlockCoord[] multiblock = null;
    ForgeDirection front = ForgeDirection.UNKNOWN;
    ForgeDirection up = ForgeDirection.UNKNOWN;
    ForgeDirection right = ForgeDirection.UNKNOWN;
    Pos pos = Pos.UNKNOWN;
    ReservoirTank tank = new ReservoirTank(1000);
    ReservoirTank regenTank = null;
    boolean autoEject;
    private boolean tankDirty = false;
    private boolean neighboursDirty = false;
    private long ticksSinceFill = 0L;
    private BoundingBox liquidRenderBounds = null;
    private ArrayList tankNeighbours;
    long lastRenderTick;
    float lastRenderPartialTick;

    public void h() {
        if (this.k == null || this.k.I) {
            return;
        }
        if (this.isMaster()) {
            if (this.regenTank.isFull() && !this.tank.isFull()) {
                ++this.ticksSinceFill;
                if (this.ticksSinceFill >= 20L) {
                    this.ticksSinceFill = 0L;
                    this.tank.fill(WATER_BUCKET, true);
                    this.tankDirty = true;
                }
            }
            if (this.autoEject && this.neighboursDirty) {
                this.doUpdateTankNeighbours();
            }
            if (this.autoEject && this.tankNeighbours != null && !this.tankNeighbours.isEmpty() && this.tank.getAmount() > 0) {
                int ejectable = this.tank.getAmount();
                int amountPerNeighbour = ejectable / this.tankNeighbours.size();
                LiquidStack source = WATER_BUCKET.copy();
                int used = 0;
                for (TankNeighbour tc : this.tankNeighbours) {
                    source.amount = amountPerNeighbour;
                    used += tc.container.fill(tc.fillFromDir, source, true);
                }
                this.tank.drain(used, true);
                this.tankDirty = true;
            }
        }
        if (this.tankDirty) {
            this.k.j(this.l, this.m, this.n);
            this.tankDirty = false;
        }
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (this.isMultiblock()) {
            return 0;
        }
        return this.getController().doFill(from, resource, doFill);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.getController().doDrain(from, maxDrain, doDrain);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return this.fill(ForgeDirection.UNKNOWN, resource, doFill);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return this.drain(ForgeDirection.UNKNOWN, maxDrain, doDrain);
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return this.getController().doGetTanks(direction);
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.getController().doGetTank(direction, type);
    }

    public ei m() {
        return PacketHandler.getPacket(this);
    }

    public void setAutoEject(boolean autoEject) {
        TileReservoir c = this.getController();
        if (c != null) {
            c.doSetAutoEject(autoEject);
        } else {
            this.doSetAutoEject(autoEject);
        }
    }

    private void doSetAutoEject(boolean newVal) {
        if (newVal && !this.autoEject) {
            this.updateTankNeighbours();
        }
        this.autoEject = newVal;
    }

    public boolean isAutoEject() {
        TileReservoir c = this.getController();
        if (c != null) {
            return c.doIsAutoEject();
        }
        return this.doIsAutoEject();
    }

    private boolean doIsAutoEject() {
        return this.autoEject;
    }

    private void updateTankNeighbours() {
        TileReservoir c = this.getController();
        if (c != null) {
            c.neighboursDirty = true;
        }
    }

    private void doUpdateTankNeighbours() {
        if (this.tankNeighbours == null) {
            this.tankNeighbours = new ArrayList();
        }
        this.tankNeighbours.clear();
        for (BlockCoord bc : this.multiblock) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                ITankContainer tc;
                BlockCoord check = bc.getLocation(dir);
                if (this.inMultiblock(check) || (tc = this.getTankContainer(check)) == null) continue;
                this.tankNeighbours.add(new TankNeighbour(tc, dir.getOpposite()));
            }
        }
        this.neighboursDirty = false;
    }

    private boolean inMultiblock(BlockCoord check) {
        for (BlockCoord bc : this.multiblock) {
            if (!check.equals(bc)) continue;
            return true;
        }
        return false;
    }

    public void a(bs nbtRoot) {
        super.a(nbtRoot);
        this.front = ForgeDirection.getOrientation((int)nbtRoot.d("front"));
        this.up = ForgeDirection.getOrientation((int)nbtRoot.d("up"));
        this.right = ForgeDirection.getOrientation((int)nbtRoot.d("right"));
        this.pos = Pos.values()[nbtRoot.d("pos")];
        this.autoEject = nbtRoot.n("autoEject");
        LiquidStack liquid = LiquidStack.loadLiquidStackFromNBT((bs)nbtRoot.l("tank"));
        LiquidStack regenLiquid = LiquidStack.loadLiquidStackFromNBT((bs)nbtRoot.l("regenTank"));
        this.tank.setCapacity(regenLiquid == null ? 1000 : 2000);
        if (liquid != null) {
            this.tank.setLiquid(liquid);
        } else {
            this.tank.setAmount(0);
        }
        this.regenTank = regenLiquid == null ? null : new ReservoirTank(regenLiquid, 2000);
        boolean wasMulti = this.isMultiblock();
        if (nbtRoot.n("isMultiblock")) {
            int[] coords = nbtRoot.k("multiblock");
            this.multiblock = new BlockCoord[4];
            int c = 0;
            for (int i = 0; i < 4; ++i) {
                this.multiblock[i] = new BlockCoord(coords[c++], coords[c++], coords[c++]);
            }
            if (this.isMaster() && this.autoEject) {
                this.updateTankNeighbours();
            }
        } else {
            this.multiblock = null;
        }
        if (wasMulti != this.isMultiblock()) {
            this.liquidRenderBounds = null;
        }
    }

    public void b(bs nbtRoot) {
        super.b(nbtRoot);
        nbtRoot.a("front", (short)this.front.ordinal());
        nbtRoot.a("up", (short)this.up.ordinal());
        nbtRoot.a("right", (short)this.right.ordinal());
        nbtRoot.a("pos", (short)this.pos.ordinal());
        nbtRoot.a("autoEject", this.autoEject);
        if (this.tank.getLiquid() != null) {
            nbtRoot.a("tank", (cf)this.tank.getLiquid().writeToNBT(new bs()));
        }
        if (this.regenTank != null) {
            nbtRoot.a("regenTank", (cf)this.regenTank.getLiquid().writeToNBT(new bs()));
        }
        nbtRoot.a("isMultiblock", this.isMultiblock());
        if (this.isMultiblock()) {
            int[] vals = new int[12];
            int i = 0;
            for (BlockCoord bc : this.multiblock) {
                vals[i++] = bc.x;
                vals[i++] = bc.y;
                vals[i++] = bc.z;
            }
            nbtRoot.a("multiblock", vals);
        }
    }

    public boolean onBlockAdded() {
        boolean res = this.formMultiblock();
        return res;
    }

    public boolean onNeighborBlockChange(int blockId) {
        if (blockId == ModObject.blockReservoir.actualId) {
            if (!this.isCurrentMultiblockValid()) {
                TileReservoir controller = this.getController();
                if (controller != null) {
                    controller.clearCurrentMultiblock();
                    controller.formMultiblock();
                } else {
                    this.clearCurrentMultiblock();
                    this.formMultiblock();
                }
                return true;
            }
        } else if (this.isMultiblock() && this.isAutoEject()) {
            this.updateTankNeighbours();
        }
        return false;
    }

    boolean isVertical() {
        return this.up == ForgeDirection.UP;
    }

    boolean isMaster() {
        if (this.multiblock != null) {
            return this.multiblock[0].equals(this.l, this.m, this.n);
        }
        return false;
    }

    float getFilledRatio() {
        return this.getController().doGetFilledRatio();
    }

    public boolean isMultiblock() {
        return this.multiblock != null;
    }

    BoundingBox getLiquidRenderBounds() {
        if (this.liquidRenderBounds == null) {
            if (!this.isMultiblock()) {
                return BoundingBox.UNIT_CUBE;
            }
            BoundingBox bounds = new BoundingBox(this.multiblock[0]);
            for (int i = 1; i < this.multiblock.length; ++i) {
                bounds = bounds.expandBy(new BoundingBox(this.multiblock[i]));
            }
            this.liquidRenderBounds = bounds.translate(-this.multiblock[0].x, -this.multiblock[0].y, -this.multiblock[0].z);
        }
        return this.liquidRenderBounds;
    }

    protected float doGetFilledRatio() {
        float result = this.tank.getFilledRatio();
        if (this.isMaster()) {
            result = this.regenTank.getFilledRatio() * 0.5f + result * 0.5f;
        }
        return result;
    }

    int doFill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (!WATER_BUCKET.isLiquidEqual(resource)) {
            return 0;
        }
        int ret = 0;
        if (resource != null && this.isMaster()) {
            resource = resource.copy();
            int filled = this.regenTank.fill(resource, doFill);
            resource.amount -= filled;
            ret += filled;
        }
        this.tankDirty = doFill;
        return ret += this.tank.fill(resource, doFill);
    }

    protected LiquidStack doDrain(ForgeDirection from, int maxDrain, boolean doDrain) {
        LiquidStack ret = this.tank.drain(maxDrain, doDrain);
        this.tankDirty = doDrain;
        return ret;
    }

    protected ILiquidTank[] doGetTanks(ForgeDirection direction) {
        return new ILiquidTank[]{this.tank};
    }

    protected ILiquidTank doGetTank(ForgeDirection direction, LiquidStack type) {
        if (this.tank.getLiquid().isLiquidEqual(type)) {
            return this.tank;
        }
        return null;
    }

    private void setMultiblock(BlockCoord[] mb) {
        this.multiblock = mb;
        this.updatePosition();
        if (this.isMaster()) {
            this.regenTank = new ReservoirTank(2000);
            this.tank.setCapacity(2000);
            for (BlockCoord bc : this.multiblock) {
                TileReservoir res = this.getReservoir(bc);
                if (res == null) continue;
                LiquidStack drained = res.doDrain(ForgeDirection.UNKNOWN, this.regenTank.getAvailableSpace(), true);
                if (drained != null) {
                    this.regenTank.addAmount(drained.amount);
                }
                if ((drained = res.doDrain(ForgeDirection.UNKNOWN, this.tank.getAvailableSpace(), true)) == null) continue;
                this.tank.addAmount(drained.amount);
            }
            if (this.doIsAutoEject()) {
                this.updateTankNeighbours();
            }
        } else {
            this.regenTank = null;
            this.tank.setCapacity(1000);
        }
        this.tankDirty = true;
        this.liquidRenderBounds = null;
        this.k.b(this.l, this.m, this.n, this.isMultiblock() ? 1 : 0, 2);
    }

    TileReservoir getController() {
        if (this.isMaster() || !this.isMultiblock()) {
            return this;
        }
        TileReservoir res = this.getReservoir(this.multiblock[0]);
        return res != null ? res : this;
    }

    private void updatePosition() {
        if (this.multiblock == null) {
            this.front = ForgeDirection.UNKNOWN;
            this.up = ForgeDirection.UNKNOWN;
            this.right = ForgeDirection.UNKNOWN;
            return;
        }
        boolean isVertical = false;
        for (BlockCoord bc : this.multiblock) {
            if (bc.y == this.m) continue;
            isVertical = true;
            break;
        }
        if (isVertical) {
            this.up = ForgeDirection.UP;
            boolean isWestEast = false;
            for (BlockCoord bc : this.multiblock) {
                if (bc.x == this.l) continue;
                isWestEast = true;
                break;
            }
            this.front = isWestEast ? ForgeDirection.NORTH : ForgeDirection.EAST;
            this.right = isWestEast ? ForgeDirection.WEST : ForgeDirection.NORTH;
        } else {
            this.front = ForgeDirection.UP;
            this.right = ForgeDirection.EAST;
            this.up = ForgeDirection.NORTH;
        }
        boolean isRight = false;
        BlockCoord myCoord = new BlockCoord(this);
        for (BlockCoord bc : this.multiblock) {
            if (!this.isInDir(myCoord, this.right, bc)) continue;
            isRight = true;
        }
        boolean isTop = false;
        for (BlockCoord bc : this.multiblock) {
            if (!this.isInDir(myCoord, this.up, bc)) continue;
            isTop = true;
        }
        this.pos = isTop ? (isRight ? Pos.TR : Pos.TL) : (isRight ? Pos.BR : Pos.BL);
    }

    private boolean isInDir(BlockCoord from, ForgeDirection inDir, BlockCoord to) {
        if (inDir.offsetX != 0) {
            return from.x - inDir.offsetX == to.x;
        }
        if (inDir.offsetY != 0) {
            return from.y - inDir.offsetY == to.y;
        }
        if (inDir.offsetZ != 0) {
            return from.z - inDir.offsetZ == to.z;
        }
        return false;
    }

    private void clearCurrentMultiblock() {
        if (this.multiblock == null) {
            return;
        }
        boolean fillTanks = false;
        if (this.isMaster()) {
            fillTanks = this.regenTank.isFull();
            this.regenTank = null;
        }
        for (BlockCoord bc : this.multiblock) {
            TileReservoir res = this.getReservoir(bc);
            if (res == null) continue;
            res.setMultiblock(null);
            if (fillTanks) {
                res.tank.fill(WATER_BUCKET, true);
                continue;
            }
            res.tank.drain(1000, true);
        }
        this.multiblock = null;
        this.tankDirty = true;
    }

    private boolean isCurrentMultiblockValid() {
        if (this.multiblock == null) {
            return false;
        }
        for (BlockCoord bc : this.multiblock) {
            TileReservoir res = this.getReservoir(bc);
            if (res != null && res.isMultiblock()) continue;
            return false;
        }
        return true;
    }

    private boolean formMultiblock() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            ForgeDirection[] cans;
            if (!this.isNonMultiReservoir(dir)) continue;
            for (ForgeDirection neighbor : cans = this.candidates(dir)) {
                if (!this.isNonMultiReservoir(neighbor) || !this.isNonMultiReservoir(dir.offsetX + neighbor.offsetX, dir.offsetY + neighbor.offsetY, dir.offsetZ + neighbor.offsetZ)) continue;
                BlockCoord[] mb = new BlockCoord[]{this.inDirection(dir), this.inDirection(neighbor), this.inDirection(dir.offsetX + neighbor.offsetX, dir.offsetY + neighbor.offsetY, dir.offsetZ + neighbor.offsetZ), new BlockCoord(this.l, this.m, this.n)};
                for (BlockCoord bc : mb) {
                    TileReservoir res = this.getReservoir(bc);
                    res.setMultiblock(mb);
                }
                return true;
            }
        }
        return false;
    }

    private BlockCoord inDirection(int offsetX, int offsetY, int offsetZ) {
        return new BlockCoord(this.l + offsetX, this.m + offsetY, this.n + offsetZ);
    }

    private BlockCoord inDirection(ForgeDirection dir) {
        return this.inDirection(dir.offsetX, dir.offsetY, dir.offsetZ);
    }

    private ITankContainer getTankContainer(BlockCoord bc) {
        return this.getTankContainer(bc.x, bc.y, bc.z);
    }

    private ITankContainer getTankContainer(int x, int y, int z) {
        if (this.k == null) {
            return null;
        }
        aqp te = this.k.r(x, y, z);
        if (te instanceof ITankContainer) {
            return (ITankContainer)te;
        }
        return null;
    }

    private TileReservoir getReservoir(BlockCoord bc) {
        return this.getReservoir(bc.x, bc.y, bc.z);
    }

    private TileReservoir getReservoir(int x, int y, int z) {
        aqp te = this.k.r(x, y, z);
        if (te instanceof TileReservoir) {
            return (TileReservoir)te;
        }
        return null;
    }

    private boolean isNonMultiReservoir(int offsetX, int offsetY, int offsetZ) {
        TileReservoir res = this.getReservoir(this.l + offsetX, this.m + offsetY, this.n + offsetZ);
        if (res == null) {
            return false;
        }
        return !res.isMultiblock();
    }

    private boolean isNonMultiReservoir(ForgeDirection dir) {
        return this.isNonMultiReservoir(dir.offsetX, dir.offsetY, dir.offsetZ);
    }

    private ForgeDirection[] candidates(ForgeDirection matchDir) {
        ForgeDirection[] res;
        res = new ForgeDirection[]{matchDir.getRotation(matchDir.offsetY == 0 ? ForgeDirection.UP : ForgeDirection.NORTH), res[0].getOpposite(), matchDir.getRotation(matchDir.offsetX == 0 ? ForgeDirection.EAST : ForgeDirection.NORTH), res[2].getOpposite()};
        return res;
    }

    public Vector3f getOffsetFromController() {
        if (!this.isMultiblock()) {
            return new Vector3f();
        }
        BlockCoord masterBC = this.multiblock[0];
        BlockCoord myBC = new BlockCoord(this.l, this.m, this.n);
        return new Vector3f(masterBC.x - myBC.x, masterBC.y - myBC.y, masterBC.z - myBC.z);
    }

    public boolean haveRendered(long renderTick, float renderPartialTick) {
        TileReservoir c = this.getController();
        if (c.lastRenderTick == renderTick && renderPartialTick == c.lastRenderPartialTick) {
            return true;
        }
        c.lastRenderTick = renderTick;
        c.lastRenderPartialTick = renderPartialTick;
        return false;
    }

    static enum Pos {
        TL(true, false),
        TR(true, true),
        BL(false, false),
        BR(false, true),
        UNKNOWN(false, false);

        boolean isTop;
        boolean isRight;

        /*
         * WARNING - void declaration
         */
        private Pos() {
            void isRight;
            void isTop;
            this.isTop = isTop;
            this.isRight = isRight;
        }
    }
}

