/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.solar;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import crazypants.enderio.power.BasicCapacitor;
import crazypants.enderio.power.EnderPowerProvider;
import crazypants.enderio.power.IInternalPowerReceptor;
import crazypants.enderio.power.PowerHandlerUtil;
import crazypants.util.BlockCoord;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.minecraftforge.common.ForgeDirection;

public class TileEntitySolarPanel
extends aqp
implements IInternalPowerReceptor,
IPowerReceptor {
    protected EnderPowerProvider powerHandler;
    private BasicCapacitor capacitor;
    private final List receptors = new ArrayList();
    private ListIterator receptorIterator = this.receptors.listIterator();
    private boolean receptorsDirty = true;
    private float energyPerTick = 1.0f;

    public TileEntitySolarPanel() {
        this.capacitor = new BasicCapacitor(0, 10000, 10);
        this.powerHandler = PowerHandlerUtil.createHandler(this.capacitor);
    }

    public void onNeighborBlockChange() {
        this.receptorsDirty = true;
    }

    @Override
    public void applyPerdition() {
    }

    @Override
    public EnderPowerProvider getPowerHandler() {
        return this.powerHandler;
    }

    public void h() {
        if (this.k == null || this.k.I) {
            return;
        }
        this.collectEnergy();
        this.transmitEnergy();
    }

    private void collectEnergy() {
        if (!this.k.l(this.l, this.m, this.n)) {
            return;
        }
        float fromSun = this.calculateLightRatio();
        float collected = this.energyPerTick * fromSun;
        this.powerHandler.setEnergy(Math.min((float)this.powerHandler.getMaxEnergyStored(), this.powerHandler.getEnergyStored() + collected));
    }

    private float calculateLightRatio() {
        int lightValue = this.k.b(aam.a, this.l, this.m, this.n) - this.k.j;
        float sunAngle = this.k.d(1.0f);
        sunAngle = sunAngle < (float)Math.PI ? (sunAngle += (0.0f - sunAngle) * 0.2f) : (sunAngle += ((float)Math.PI * 2 - sunAngle) * 0.2f);
        lightValue = Math.round((float)lightValue * kx.b((float)sunAngle));
        lightValue = kx.a((int)lightValue, (int)0, (int)15);
        return (float)lightValue / 15.0f;
    }

    private boolean transmitEnergy() {
        if (this.powerHandler.getEnergyStored() <= 0.0f) {
            this.powerHandler.update(this);
            return false;
        }
        float stored = this.powerHandler.getEnergyStored();
        this.powerHandler.update(this);
        this.powerHandler.setEnergy(stored);
        float canTransmit = Math.min(this.powerHandler.getEnergyStored(), (float)this.capacitor.getMaxEnergyExtracted());
        float transmitted = 0.0f;
        this.checkReceptors();
        if (!this.receptors.isEmpty() && !this.receptorIterator.hasNext()) {
            this.receptorIterator = this.receptors.listIterator();
        }
        int numReceptors = this.receptors.size();
        for (int appliedCount = 0; this.receptorIterator.hasNext() && canTransmit > 0.0f && appliedCount < numReceptors; ++appliedCount) {
            Receptor receptor = (Receptor)this.receptorIterator.next();
            IPowerProvider pp = receptor.receptor.getPowerProvider();
            if (pp != null && (float)pp.getMinEnergyReceived() <= canTransmit) {
                float used;
                if (receptor.receptor instanceof IInternalPowerReceptor) {
                    used = PowerHandlerUtil.transmitInternal((IInternalPowerReceptor)receptor.receptor, canTransmit, receptor.fromDir.getOpposite());
                } else {
                    used = Math.min(canTransmit, (float)receptor.receptor.powerRequest(receptor.fromDir.getOpposite()));
                    pp.receiveEnergy(used, receptor.fromDir);
                }
                transmitted += used;
                canTransmit -= used;
            }
            if (canTransmit <= 0.0f) break;
            if (this.receptors.isEmpty() || this.receptorIterator.hasNext()) continue;
            this.receptorIterator = this.receptors.listIterator();
        }
        this.powerHandler.setEnergy(this.powerHandler.getEnergyStored() - transmitted);
        return transmitted > 0.0f;
    }

    private void checkReceptors() {
        if (!this.receptorsDirty) {
            return;
        }
        this.receptors.clear();
        BlockCoord bc = new BlockCoord(this.l, this.m, this.n);
        ForgeDirection dir = ForgeDirection.DOWN;
        BlockCoord checkLoc = bc.getLocation(dir);
        aqp te = this.k.r(checkLoc.x, checkLoc.y, checkLoc.z);
        if (te instanceof IPowerReceptor) {
            IPowerReceptor rec = (IPowerReceptor)te;
            this.receptors.add(new Receptor((IPowerReceptor)te, dir));
        }
        this.receptorIterator = this.receptors.listIterator();
        this.receptorsDirty = false;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerHandler;
    }

    @Override
    public void doWork() {
    }

    @Override
    public int powerRequest(ForgeDirection from) {
        return 0;
    }

    static class Receptor {
        IPowerReceptor receptor;
        ForgeDirection fromDir;

        private Receptor(IPowerReceptor rec, ForgeDirection fromDir) {
            this.receptor = rec;
            this.fromDir = fromDir;
        }
    }
}

