/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.material;

import crazypants.enderio.ModObject;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.RecipeInput;
import java.util.ArrayList;

public class FusedQuartzRecipe
implements IMachineRecipe {
    private static final int NUM_QUARTZ = 4;

    @Override
    public String getUid() {
        return ModObject.blockFusedQuartz.unlocalisedName;
    }

    @Override
    public float getEnergyRequired(RecipeInput ... inputs) {
        return 1600.0f;
    }

    @Override
    public boolean isRecipe(RecipeInput ... inputs) {
        int numQuartz = 0;
        for (RecipeInput input : inputs) {
            if (input == null || input.item == null || input.item.c != wk.ca.cp) continue;
            numQuartz += input.item.a;
        }
        return numQuartz >= 4;
    }

    @Override
    public wm[] getCompletedResult(float chance, RecipeInput ... inputs) {
        return new wm[]{new wm(ModObject.blockFusedQuartz.actualId, 1, 0)};
    }

    @Override
    public boolean isValidInput(RecipeInput input) {
        return input != null && input.item != null && input.item.c == wk.ca.cp;
    }

    @Override
    public String getMachineName() {
        return ModObject.blockFusedQuartz.unlocalisedName;
    }

    @Override
    public RecipeInput[] getQuantitiesConsumed(RecipeInput[] inputs) {
        int[] numPerInput = new int[inputs.length];
        boolean numFound = false;
        for (int i = 0; i < inputs.length; ++i) {
            numPerInput[i] = this.getQuartzQuanity(inputs[i]);
        }
        int total = 0;
        int[] consumedPerInput = new int[inputs.length];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < consumedPerInput.length; ++j) {
                if (total >= 4 || numPerInput[j] - consumedPerInput[j] <= 0) continue;
                ++total;
                int n = j;
                consumedPerInput[n] = consumedPerInput[n] + 1;
            }
        }
        if (total < 4) {
            System.out.println("FusedQuartzRecipe.getQuantitiesConsumed: Error!! No QuartzConsumed Consumed.");
            return new RecipeInput[0];
        }
        if (total > 4) {
            System.out.println("FusedQuartzRecipe.getQuantitiesConsumed: Error!! Consumed more than we should have.");
        }
        ArrayList<RecipeInput> res = new ArrayList<RecipeInput>();
        for (int i = 0; i < consumedPerInput.length; ++i) {
            if (consumedPerInput[i] <= 0) continue;
            RecipeInput consumed = new RecipeInput(inputs[i].slotNumber, new wm(wk.ca, consumedPerInput[i]));
            res.add(consumed);
        }
        return res.toArray(new RecipeInput[res.size()]);
    }

    private int getQuartzQuanity(RecipeInput ri) {
        if (ri != null && ri.item != null && ri.item.c == wk.ca.cp) {
            return ri.item.a;
        }
        return 0;
    }

    @Override
    public float getExperianceForOutput(wm output) {
        if (output == null) {
            return 0.0f;
        }
        return 0.2f * (float)output.a;
    }
}

