/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.power;

import crazypants.enderio.power.EnderPowerProvider;
import crazypants.enderio.power.ICapacitor;
import crazypants.enderio.power.IInternalPowerReceptor;
import crazypants.enderio.power.MutablePowerProvider;
import net.minecraftforge.common.ForgeDirection;

public class PowerHandlerUtil {
    public static float getStoredEnergyForItem(wm item) {
        bs tag = item.q();
        if (tag == null) {
            return 0.0f;
        }
        return tag.g("storedEnergy");
    }

    public static void setStoredEnergyForItem(wm item, float storedEnergy) {
        bs tag = item.q();
        if (tag == null) {
            tag = new bs();
        }
        tag.a("storedEnergy", storedEnergy);
        item.d(tag);
    }

    public static EnderPowerProvider createHandler(ICapacitor capacitor) {
        EnderPowerProvider ph = new EnderPowerProvider();
        ph.configure(0, capacitor.getMinEnergyReceived(), capacitor.getMaxEnergyReceived(), capacitor.getMinActivationEnergy(), capacitor.getMaxEnergyStored());
        ph.configurePowerPerdition(0, 0);
        return ph;
    }

    public static void configure(EnderPowerProvider ph, ICapacitor capacitor) {
        ph.configure(0, capacitor.getMinEnergyReceived(), capacitor.getMaxEnergyReceived(), capacitor.getMinActivationEnergy(), capacitor.getMaxEnergyStored());
        if (ph.getEnergyStored() > (float)ph.getMaxEnergyStored()) {
            ph.setEnergy(ph.getMaxEnergyStored());
        }
        ph.configurePowerPerdition(0, 0);
    }

    public static float transmitInternal(IInternalPowerReceptor receptor, float quantity, ForgeDirection from) {
        MutablePowerProvider ph = receptor.getPowerHandler();
        if (ph == null) {
            return 0.0f;
        }
        float energyStored = ph.getEnergyStored();
        float canUse = quantity;
        canUse = Math.min(canUse, (float)ph.getMaxEnergyReceived());
        if ((canUse = Math.min(canUse, (float)ph.getMaxEnergyStored() - energyStored)) < (float)ph.getMinEnergyReceived()) {
            return 0.0f;
        }
        ph.receiveEnergy(quantity, from);
        ph.setEnergy(energyStored);
        ph.setEnergy(energyStored + canUse);
        receptor.applyPerdition();
        return canUse;
    }
}

