/*
 * Decompiled with CFR 0.152.
 */
package crazypants.gui;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class GuiToolTip {
    private static final long DELAY = 0L;
    protected Rectangle bounds;
    private long mouseOverStart;
    protected final List text;
    private int lastMouseX = -1;
    private int lastMouseY = -1;

    public GuiToolTip(Rectangle bounds, String ... lines) {
        this.bounds = bounds;
        if (lines != null) {
            this.text = new ArrayList(lines.length);
            for (String line : lines) {
                this.text.add(line);
            }
        } else {
            this.text = new ArrayList();
        }
    }

    public GuiToolTip(Rectangle bounds, List lines) {
        this.bounds = bounds;
        this.text = lines == null ? new ArrayList() : new ArrayList(lines);
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setBounds(Rectangle bounds) {
        this.bounds = bounds;
    }

    public void onTick(int mouseX, int mouseY) {
        if (this.lastMouseX != mouseX || this.lastMouseY != mouseY) {
            this.mouseOverStart = 0L;
        }
        if (this.bounds.contains(mouseX, mouseY)) {
            if (this.mouseOverStart == 0L) {
                this.mouseOverStart = System.currentTimeMillis();
            }
        } else {
            this.mouseOverStart = 0L;
        }
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
    }

    public boolean shouldDraw() {
        this.updateText();
        if (this.mouseOverStart == 0L) {
            return false;
        }
        return System.currentTimeMillis() - this.mouseOverStart >= 0L;
    }

    protected void updateText() {
    }

    public void setToolTipText(String ... txt) {
        this.text.clear();
        for (String line : txt) {
            this.text.add(line);
        }
    }

    public List getToolTipText() {
        return this.text;
    }
}

