/*
 * Decompiled with CFR 0.152.
 */
package crazypants.gui;

import crazypants.gui.GuiToolTip;
import java.util.ArrayList;
import java.util.List;

public class ToolTipManager {
    private List toolTips = new ArrayList();

    public void addToolTip(GuiToolTip toolTip) {
        this.toolTips.add(toolTip);
    }

    protected final void drawTooltips(ToolTipRenderer renderer, int mouseX, int mouseY) {
        for (GuiToolTip toolTip : this.toolTips) {
            toolTip.onTick(mouseX - renderer.getGuiLeft(), mouseY - renderer.getGuiTop());
            if (!toolTip.shouldDraw()) continue;
            this.drawTooltip(toolTip, mouseX - renderer.getGuiLeft(), mouseY - renderer.getGuiTop(), renderer);
        }
    }

    protected void drawTooltip(GuiToolTip toolTip, int mouseX, int mouseY, ToolTipRenderer renderer) {
        List list = toolTip.getToolTipText();
        ArrayList<String> formatted = new ArrayList<String>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                formatted.add("\u00a7" + Integer.toHexString(15) + (String)list.get(i));
                continue;
            }
            formatted.add("\u00a77" + (String)list.get(i));
        }
        if (mouseX > renderer.getXSize() / 2) {
            int maxWidth = 0;
            for (String s : formatted) {
                int w = renderer.getFontRenderer().a(s);
                if (w <= maxWidth) continue;
                maxWidth = w;
            }
            mouseX -= maxWidth + 18;
        }
        renderer.drawHoveringText(formatted, mouseX, mouseY, renderer.getFontRenderer());
    }

    public static interface ToolTipRenderer {
        public int getGuiLeft();

        public int getGuiTop();

        public int getXSize();

        public awv getFontRenderer();

        public void drawHoveringText(List var1, int var2, int var3, awv var4);
    }
}

