/*
 * Decompiled with CFR 0.152.
 */
package crazypants.render;

import crazypants.render.VertexTransform;
import crazypants.util.BlockCoord;
import crazypants.vecmath.Vector2f;
import crazypants.vecmath.Vector3d;
import crazypants.vecmath.Vector3f;
import crazypants.vecmath.Vertex;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;

public final class BoundingBox {
    public static final BoundingBox UNIT_CUBE = new BoundingBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    public final float minX;
    public final float minY;
    public final float minZ;
    public final float maxX;
    public final float maxY;
    public final float maxZ;

    public BoundingBox(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public BoundingBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.minX = (float)minX;
        this.minY = (float)minY;
        this.minZ = (float)minZ;
        this.maxX = (float)maxX;
        this.maxY = (float)maxY;
        this.maxZ = (float)maxZ;
    }

    public BoundingBox(Vector3d min, Vector3d max) {
        this(min.x, min.y, min.z, max.x, max.y, max.z);
    }

    public BoundingBox(BoundingBox copy) {
        this(copy.minX, copy.minY, copy.minZ, copy.maxX, copy.maxY, copy.maxZ);
    }

    public BoundingBox(BlockCoord bc) {
        this(bc.x, bc.y, bc.z, bc.x + 1, bc.y + 1, bc.z + 1);
    }

    public BoundingBox expandBy(BoundingBox other) {
        return new BoundingBox(Math.min(this.minX, other.minX), Math.min(this.minY, other.minY), Math.min(this.minZ, other.minZ), Math.max(this.maxX, other.maxX), Math.max(this.maxY, other.maxY), Math.max(this.maxZ, other.maxZ));
    }

    public boolean isValid() {
        return this.minX < this.maxX && this.minY < this.maxY && this.minZ < this.maxZ;
    }

    public BoundingBox scale(float x, float y, float z) {
        x = 1.0f - x;
        y = 1.0f - y;
        z = 1.0f - z;
        float w = (this.maxX - this.minX) * x / 2.0f;
        float h = (this.maxY - this.minY) * y / 2.0f;
        float d = (this.maxZ - this.minZ) * z / 2.0f;
        return new BoundingBox(this.minX + w, this.minY + h, this.minZ + d, this.maxX - w, this.maxY - h, this.maxZ - d);
    }

    public BoundingBox translate(float x, float y, float z) {
        return new BoundingBox(this.minX + x, this.minY + y, this.minZ + z, this.maxX + x, this.maxY + y, this.maxZ + z);
    }

    public BoundingBox translate(Vector3d translation) {
        return this.translate((float)translation.x, (float)translation.y, (float)translation.z);
    }

    public BoundingBox transform(VertexTransform iTransformation) {
        Vector3d min = new Vector3d(this.minX, this.minY, this.minZ);
        Vector3d max = new Vector3d(this.maxX, this.maxY, this.maxZ);
        iTransformation.apply(min);
        iTransformation.apply(max);
        return new BoundingBox(Math.min(min.x, max.x), Math.min(min.y, max.y), Math.min(min.z, max.z), Math.max(min.x, max.x), Math.max(min.y, max.y), Math.max(min.z, max.z));
    }

    public List getCornersWithUvForFace(ForgeDirection face) {
        return this.getCornersWithUvForFace(face, 0.0f, 1.0f, 0.0f, 1.0f);
    }

    public List getCornersWithUvForFace(ForgeDirection face, float minU, float maxU, float minV, float maxV) {
        ArrayList<Vertex> result = new ArrayList<Vertex>(4);
        switch (face) {
            case NORTH: {
                result.add(new Vertex(new Vector3d(this.maxX, this.minY, this.minZ), new Vector3f(0.0f, 0.0f, -1.0f), new Vector2f(minU, minV)));
                result.add(new Vertex(new Vector3d(this.minX, this.minY, this.minZ), new Vector3f(0.0f, 0.0f, -1.0f), new Vector2f(maxU, minV)));
                result.add(new Vertex(new Vector3d(this.minX, this.maxY, this.minZ), new Vector3f(0.0f, 0.0f, -1.0f), new Vector2f(maxU, maxV)));
                result.add(new Vertex(new Vector3d(this.maxX, this.maxY, this.minZ), new Vector3f(0.0f, 0.0f, -1.0f), new Vector2f(minU, maxV)));
                break;
            }
            case SOUTH: {
                result.add(new Vertex(new Vector3d(this.minX, this.minY, this.maxZ), new Vector3f(0.0f, 0.0f, 1.0f), new Vector2f(maxU, minV)));
                result.add(new Vertex(new Vector3d(this.maxX, this.minY, this.maxZ), new Vector3f(0.0f, 0.0f, 1.0f), new Vector2f(minU, minV)));
                result.add(new Vertex(new Vector3d(this.maxX, this.maxY, this.maxZ), new Vector3f(0.0f, 0.0f, 1.0f), new Vector2f(minU, maxV)));
                result.add(new Vertex(new Vector3d(this.minX, this.maxY, this.maxZ), new Vector3f(0.0f, 0.0f, 1.0f), new Vector2f(maxU, maxV)));
                break;
            }
            case EAST: {
                result.add(new Vertex(new Vector3d(this.maxX, this.maxY, this.minZ), new Vector3f(1.0f, 0.0f, 0.0f), new Vector2f(maxU, maxV)));
                result.add(new Vertex(new Vector3d(this.maxX, this.maxY, this.maxZ), new Vector3f(1.0f, 0.0f, 0.0f), new Vector2f(minU, maxV)));
                result.add(new Vertex(new Vector3d(this.maxX, this.minY, this.maxZ), new Vector3f(1.0f, 0.0f, 0.0f), new Vector2f(minU, minV)));
                result.add(new Vertex(new Vector3d(this.maxX, this.minY, this.minZ), new Vector3f(1.0f, 0.0f, 0.0f), new Vector2f(maxU, minV)));
                break;
            }
            case WEST: {
                result.add(new Vertex(new Vector3d(this.minX, this.minY, this.minZ), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector2f(maxU, minV)));
                result.add(new Vertex(new Vector3d(this.minX, this.minY, this.maxZ), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector2f(minU, minV)));
                result.add(new Vertex(new Vector3d(this.minX, this.maxY, this.maxZ), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector2f(minU, maxV)));
                result.add(new Vertex(new Vector3d(this.minX, this.maxY, this.minZ), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector2f(maxU, maxV)));
                break;
            }
            case UP: {
                result.add(new Vertex(new Vector3d(this.maxX, this.maxY, this.maxZ), new Vector3f(0.0f, 1.0f, 0.0f), new Vector2f(minU, minV)));
                result.add(new Vertex(new Vector3d(this.maxX, this.maxY, this.minZ), new Vector3f(0.0f, 1.0f, 0.0f), new Vector2f(minU, maxV)));
                result.add(new Vertex(new Vector3d(this.minX, this.maxY, this.minZ), new Vector3f(0.0f, 1.0f, 0.0f), new Vector2f(maxU, maxV)));
                result.add(new Vertex(new Vector3d(this.minX, this.maxY, this.maxZ), new Vector3f(0.0f, 1.0f, 0.0f), new Vector2f(maxU, minV)));
                break;
            }
            default: {
                result.add(new Vertex(new Vector3d(this.minX, this.minY, this.minZ), new Vector3f(0.0f, -1.0f, 0.0f), new Vector2f(maxU, maxV)));
                result.add(new Vertex(new Vector3d(this.maxX, this.minY, this.minZ), new Vector3f(0.0f, -1.0f, 0.0f), new Vector2f(minU, maxV)));
                result.add(new Vertex(new Vector3d(this.maxX, this.minY, this.maxZ), new Vector3f(0.0f, -1.0f, 0.0f), new Vector2f(minU, minV)));
                result.add(new Vertex(new Vector3d(this.minX, this.minY, this.maxZ), new Vector3f(0.0f, -1.0f, 0.0f), new Vector2f(maxU, minV)));
            }
        }
        return result;
    }

    public List getCornersForFace(ForgeDirection face) {
        ArrayList<Vector3f> result = new ArrayList<Vector3f>(4);
        switch (face) {
            case NORTH: {
                result.add(new Vector3f(this.maxX, this.minY, this.minZ));
                result.add(new Vector3f(this.minX, this.minY, this.minZ));
                result.add(new Vector3f(this.minX, this.maxY, this.minZ));
                result.add(new Vector3f(this.maxX, this.maxY, this.minZ));
                break;
            }
            case SOUTH: {
                result.add(new Vector3f(this.minX, this.minY, this.maxZ));
                result.add(new Vector3f(this.maxX, this.minY, this.maxZ));
                result.add(new Vector3f(this.maxX, this.maxY, this.maxZ));
                result.add(new Vector3f(this.minX, this.maxY, this.maxZ));
                break;
            }
            case EAST: {
                result.add(new Vector3f(this.maxX, this.maxY, this.minZ));
                result.add(new Vector3f(this.maxX, this.maxY, this.maxZ));
                result.add(new Vector3f(this.maxX, this.minY, this.maxZ));
                result.add(new Vector3f(this.maxX, this.minY, this.minZ));
                break;
            }
            case WEST: {
                result.add(new Vector3f(this.minX, this.minY, this.minZ));
                result.add(new Vector3f(this.minX, this.minY, this.maxZ));
                result.add(new Vector3f(this.minX, this.maxY, this.maxZ));
                result.add(new Vector3f(this.minX, this.maxY, this.minZ));
                break;
            }
            case UP: {
                result.add(new Vector3f(this.maxX, this.maxY, this.maxZ));
                result.add(new Vector3f(this.maxX, this.maxY, this.minZ));
                result.add(new Vector3f(this.minX, this.maxY, this.minZ));
                result.add(new Vector3f(this.minX, this.maxY, this.maxZ));
                break;
            }
            default: {
                result.add(new Vector3f(this.minX, this.minY, this.minZ));
                result.add(new Vector3f(this.maxX, this.minY, this.minZ));
                result.add(new Vector3f(this.maxX, this.minY, this.maxZ));
                result.add(new Vector3f(this.minX, this.minY, this.maxZ));
            }
        }
        return result;
    }

    public Vector3d getCenter() {
        return new Vector3d(this.minX + (this.maxX - this.minX) / 2.0f, this.minY + (this.maxY - this.minY) / 2.0f, this.minZ + (this.maxZ - this.minZ) / 2.0f);
    }

    public float sizeX() {
        return Math.abs(this.maxX - this.minX);
    }

    public float sizeY() {
        return Math.abs(this.maxY - this.minY);
    }

    public float sizeZ() {
        return Math.abs(this.maxZ - this.minZ);
    }

    public Vector3d getMin() {
        return new Vector3d(this.minX, this.minY, this.minZ);
    }

    public Vector3d getMax() {
        return new Vector3d(this.maxX, this.maxY, this.maxZ);
    }

    public String toString() {
        return "BoundingBox [minX=" + this.minX + ", minY=" + this.minY + ", minZ=" + this.minZ + ", maxX=" + this.maxX + ", maxY=" + this.maxY + ", maxZ=" + this.maxZ + "]";
    }

    public BoundingBox fixMinMax() {
        float mnX = this.minX;
        float mnY = this.minY;
        float mnZ = this.minZ;
        float mxX = this.maxX;
        float mxY = this.maxY;
        float mxZ = this.maxZ;
        boolean mod = false;
        if (this.minX > this.maxX) {
            mnX = this.maxX;
            mxX = this.minX;
            mod = true;
        }
        if (this.minY > this.maxY) {
            mnY = this.maxY;
            mxY = this.minY;
            mod = true;
        }
        if (this.minZ > this.maxZ) {
            mnZ = this.maxZ;
            mxZ = this.minZ;
            mod = true;
        }
        if (!mod) {
            return this;
        }
        return new BoundingBox(mnX, mnY, mnZ, mxX, mxY, mxZ);
    }
}

