/*
 * Decompiled with CFR 0.152.
 */
package crazypants.render;

import crazypants.render.BoundingBox;
import crazypants.render.RenderUtil;
import crazypants.render.VertexTransform;
import crazypants.vecmath.Vector3d;
import net.minecraftforge.common.ForgeDirection;

public final class CubeRenderer {
    public static final Vector3d[] verts = new Vector3d[8];

    public static void render(BoundingBox bb, lx tex) {
        CubeRenderer.render(bb, tex, null, false);
    }

    public static void render(BoundingBox bb, lx tex, boolean tintSides) {
        CubeRenderer.render(bb, tex, null, tintSides);
    }

    public static void render(BoundingBox bb, lx tex, VertexTransform xForm) {
        CubeRenderer.render(bb, tex.e(), tex.f(), tex.g(), tex.h(), xForm, false);
    }

    public static void render(BoundingBox bb, lx tex, VertexTransform xForm, boolean tintSides) {
        float minU = 0.0f;
        float minV = 0.0f;
        float maxU = 1.0f;
        float maxV = 1.0f;
        if (tex != null) {
            minU = tex.e();
            minV = tex.g();
            maxU = tex.f();
            maxV = tex.h();
        }
        CubeRenderer.render(bb, minU, maxU, minV, maxV, xForm, tintSides);
    }

    public static void render(BoundingBox bb, float minU, float maxU, float minV, float maxV, boolean tintSides) {
        CubeRenderer.render(bb, minU, maxU, minV, maxV, null, tintSides);
    }

    public static void render(BoundingBox bb, float minU, float maxU, float minV, float maxV) {
        CubeRenderer.render(bb, minU, maxU, minV, maxV, null, false);
    }

    public static void render(BoundingBox bb, float minU, float maxU, float minV, float maxV, VertexTransform xForm) {
        CubeRenderer.render(bb, minU, maxU, minV, maxV, xForm, false);
    }

    public static void render(BoundingBox bb, float minU, float maxU, float minV, float maxV, VertexTransform xForm, boolean tintSides) {
        float cm;
        CubeRenderer.setupVertices(bb, xForm);
        float tmp = minV;
        minV = maxV;
        maxV = tmp;
        bgd tessellator = bgd.a;
        tessellator.b(0.0f, 0.0f, -1.0f);
        if (tintSides) {
            cm = RenderUtil.getColorMultiplierForFace(ForgeDirection.NORTH);
            tessellator.a(cm, cm, cm);
        }
        CubeRenderer.addVecWithUV(verts[1], minU, minV);
        CubeRenderer.addVecWithUV(verts[0], maxU, minV);
        CubeRenderer.addVecWithUV(verts[3], maxU, maxV);
        CubeRenderer.addVecWithUV(verts[2], minU, maxV);
        tessellator.b(0.0f, 0.0f, 1.0f);
        if (tintSides) {
            cm = RenderUtil.getColorMultiplierForFace(ForgeDirection.SOUTH);
            tessellator.a(cm, cm, cm);
        }
        CubeRenderer.addVecWithUV(verts[4], minU, minV);
        CubeRenderer.addVecWithUV(verts[5], maxU, minV);
        CubeRenderer.addVecWithUV(verts[6], maxU, maxV);
        CubeRenderer.addVecWithUV(verts[7], minU, maxV);
        tessellator.b(0.0f, 1.0f, 0.0f);
        if (tintSides) {
            cm = RenderUtil.getColorMultiplierForFace(ForgeDirection.UP);
            tessellator.a(cm, cm, cm);
        }
        CubeRenderer.addVecWithUV(verts[6], minU, minV);
        CubeRenderer.addVecWithUV(verts[2], minU, maxV);
        CubeRenderer.addVecWithUV(verts[3], maxU, maxV);
        CubeRenderer.addVecWithUV(verts[7], maxU, minV);
        tessellator.b(0.0f, -1.0f, 0.0f);
        if (tintSides) {
            cm = RenderUtil.getColorMultiplierForFace(ForgeDirection.DOWN);
            tessellator.a(cm, cm, cm);
        }
        CubeRenderer.addVecWithUV(verts[0], maxU, maxV);
        CubeRenderer.addVecWithUV(verts[1], minU, maxV);
        CubeRenderer.addVecWithUV(verts[5], minU, minV);
        CubeRenderer.addVecWithUV(verts[4], maxU, minV);
        tessellator.b(1.0f, 0.0f, 0.0f);
        if (tintSides) {
            cm = RenderUtil.getColorMultiplierForFace(ForgeDirection.EAST);
            tessellator.a(cm, cm, cm);
        }
        CubeRenderer.addVecWithUV(verts[2], minU, maxV);
        CubeRenderer.addVecWithUV(verts[6], maxU, maxV);
        CubeRenderer.addVecWithUV(verts[5], maxU, minV);
        CubeRenderer.addVecWithUV(verts[1], minU, minV);
        tessellator.b(-1.0f, 0.0f, 0.0f);
        if (tintSides) {
            cm = RenderUtil.getColorMultiplierForFace(ForgeDirection.WEST);
            tessellator.a(cm, cm, cm);
        }
        CubeRenderer.addVecWithUV(verts[0], minU, minV);
        CubeRenderer.addVecWithUV(verts[4], maxU, minV);
        CubeRenderer.addVecWithUV(verts[7], maxU, maxV);
        CubeRenderer.addVecWithUV(verts[3], minU, maxV);
    }

    public static void render(BoundingBox bb, lx[] faceTextures, VertexTransform xForm) {
        CubeRenderer.setupVertices(bb, xForm);
        bgd tessellator = bgd.a;
        tessellator.b(0.0f, 0.0f, -1.0f);
        lx tex = faceTextures[0];
        float minU = tex.e();
        float maxU = tex.f();
        float minV = tex.g();
        float maxV = tex.h();
        CubeRenderer.addVecWithUV(verts[1], minU, minV);
        CubeRenderer.addVecWithUV(verts[0], maxU, minV);
        CubeRenderer.addVecWithUV(verts[3], maxU, maxV);
        CubeRenderer.addVecWithUV(verts[2], minU, maxV);
        tessellator.b(0.0f, 0.0f, 1.0f);
        tex = faceTextures[1];
        minU = tex.e();
        maxU = tex.f();
        minV = tex.g();
        maxV = tex.h();
        CubeRenderer.addVecWithUV(verts[4], minU, minV);
        CubeRenderer.addVecWithUV(verts[5], maxU, minV);
        CubeRenderer.addVecWithUV(verts[6], maxU, maxV);
        CubeRenderer.addVecWithUV(verts[7], minU, maxV);
        tessellator.b(0.0f, 1.0f, 0.0f);
        tex = faceTextures[2];
        minU = tex.e();
        maxU = tex.f();
        minV = tex.g();
        maxV = tex.h();
        CubeRenderer.addVecWithUV(verts[6], minU, minV);
        CubeRenderer.addVecWithUV(verts[2], minU, maxV);
        CubeRenderer.addVecWithUV(verts[3], maxU, maxV);
        CubeRenderer.addVecWithUV(verts[7], maxU, minV);
        tessellator.b(0.0f, -1.0f, 0.0f);
        tex = faceTextures[3];
        minU = tex.e();
        maxU = tex.f();
        minV = tex.g();
        maxV = tex.h();
        CubeRenderer.addVecWithUV(verts[0], maxU, maxV);
        CubeRenderer.addVecWithUV(verts[1], minU, maxV);
        CubeRenderer.addVecWithUV(verts[5], minU, minV);
        CubeRenderer.addVecWithUV(verts[4], maxU, minV);
        tessellator.b(1.0f, 0.0f, 0.0f);
        tex = faceTextures[4];
        minU = tex.e();
        maxU = tex.f();
        minV = tex.g();
        maxV = tex.h();
        CubeRenderer.addVecWithUV(verts[2], minU, maxV);
        CubeRenderer.addVecWithUV(verts[6], maxU, maxV);
        CubeRenderer.addVecWithUV(verts[5], maxU, minV);
        CubeRenderer.addVecWithUV(verts[1], minU, minV);
        tessellator.b(-1.0f, 0.0f, 0.0f);
        tex = faceTextures[5];
        minU = tex.e();
        maxU = tex.f();
        minV = tex.g();
        maxV = tex.h();
        CubeRenderer.addVecWithUV(verts[0], minU, minV);
        CubeRenderer.addVecWithUV(verts[4], maxU, minV);
        CubeRenderer.addVecWithUV(verts[7], maxU, maxV);
        CubeRenderer.addVecWithUV(verts[3], minU, maxV);
    }

    public static void setupVertices(BoundingBox bound) {
        CubeRenderer.setupVertices(bound, null);
    }

    public static void setupVertices(BoundingBox bound, VertexTransform xForm) {
        verts[0].set(bound.minX, bound.minY, bound.minZ);
        verts[1].set(bound.maxX, bound.minY, bound.minZ);
        verts[2].set(bound.maxX, bound.maxY, bound.minZ);
        verts[3].set(bound.minX, bound.maxY, bound.minZ);
        verts[4].set(bound.minX, bound.minY, bound.maxZ);
        verts[5].set(bound.maxX, bound.minY, bound.maxZ);
        verts[6].set(bound.maxX, bound.maxY, bound.maxZ);
        verts[7].set(bound.minX, bound.maxY, bound.maxZ);
        if (xForm != null) {
            for (Vector3d vec : verts) {
                xForm.apply(vec);
            }
        }
    }

    public static void addVecWithUV(Vector3d vec, double u, double v) {
        bgd.a.a(vec.x, vec.y, vec.z, u, v);
    }

    private CubeRenderer() {
    }

    static {
        for (int i = 0; i < verts.length; ++i) {
            CubeRenderer.verts[i] = new Vector3d();
        }
    }
}

