/*
 * Decompiled with CFR 0.152.
 */
package crazypants.render;

import crazypants.render.BoundingBox;
import crazypants.util.BlockCoord;
import crazypants.vecmath.Matrix4d;
import crazypants.vecmath.VecmathUtil;
import crazypants.vecmath.Vector2d;
import crazypants.vecmath.Vector3d;
import crazypants.vecmath.Vector3f;
import crazypants.vecmath.Vector4d;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderUtil {
    public static final Vector3d UP_V = new Vector3d(0.0, 1.0, 0.0);
    public static final Vector3d ZERO_V = new Vector3d(0.0, 0.0, 0.0);
    private static final FloatBuffer MATRIX_BUFFER = avc.h((int)16);
    public static final String BLOCK_TEX = "/terrain.png";
    public static final String ITEM_TEX = "/gui/items.png";
    public static final String GLINT_TEX = "%blur%/misc/glint.png";

    public static void loadMatrix(Matrix4d mat) {
        MATRIX_BUFFER.rewind();
        MATRIX_BUFFER.put((float)mat.m00);
        MATRIX_BUFFER.put((float)mat.m01);
        MATRIX_BUFFER.put((float)mat.m02);
        MATRIX_BUFFER.put((float)mat.m03);
        MATRIX_BUFFER.put((float)mat.m10);
        MATRIX_BUFFER.put((float)mat.m11);
        MATRIX_BUFFER.put((float)mat.m12);
        MATRIX_BUFFER.put((float)mat.m13);
        MATRIX_BUFFER.put((float)mat.m20);
        MATRIX_BUFFER.put((float)mat.m21);
        MATRIX_BUFFER.put((float)mat.m22);
        MATRIX_BUFFER.put((float)mat.m23);
        MATRIX_BUFFER.put((float)mat.m30);
        MATRIX_BUFFER.put((float)mat.m31);
        MATRIX_BUFFER.put((float)mat.m32);
        MATRIX_BUFFER.put((float)mat.m33);
        MATRIX_BUFFER.rewind();
        GL11.glLoadMatrix((FloatBuffer)MATRIX_BUFFER);
    }

    public static bge engine() {
        return Minecraft.x().p;
    }

    public static void bindItemTexture(wm stack) {
        RenderUtil.engine().b(stack.d() == 0 ? BLOCK_TEX : ITEM_TEX);
    }

    public static void bindItemTexture() {
        RenderUtil.engine().b(ITEM_TEX);
    }

    public static void bindBlockTexture() {
        RenderUtil.engine().b(BLOCK_TEX);
    }

    public static void bindGlintTexture() {
        RenderUtil.engine().b(BLOCK_TEX);
    }

    public static void bindTexture(String string) {
        RenderUtil.engine().b(string);
    }

    public static awv fontRenderer() {
        return Minecraft.x().q;
    }

    public static float claculateTotalBrightnessForLocation(aab worldObj, int xCoord, int yCoord, int zCoord) {
        int i = worldObj.h(xCoord, yCoord, zCoord, 0);
        int j = i % 65536;
        int k = i / 65536;
        float sunBrightness = worldObj.b(1.0f);
        float percentRecievedFromSun = (float)k / 255.0f;
        float fromLights = (float)j / 255.0f;
        float recievedPercent = worldObj.q(xCoord, yCoord, zCoord);
        float highestValue = Math.max(fromLights, percentRecievedFromSun * sunBrightness);
        return Math.max(0.2f, highestValue);
    }

    public static float getColorMultiplierForFace(ForgeDirection face) {
        if (face == ForgeDirection.UP) {
            return 1.0f;
        }
        if (face == ForgeDirection.DOWN) {
            return 0.5f;
        }
        if (face.offsetX != 0) {
            return 0.6f;
        }
        return 0.8f;
    }

    public static int setTesselatorBrightness(aak world, int x, int y, int z) {
        apa block = apa.r[world.a(x, y, z)];
        int res = block == null ? world.h(x, y, z, 0) : block.e(world, x, y, z);
        bgd.a.c(res);
        bgd.a.a(1.0f, 1.0f, 1.0f, 1.0f);
        return res;
    }

    public static void renderQuad2D(double x, double y, double z, double width, double height, int colorRGB) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3553);
        bgd tessellator = bgd.a;
        tessellator.b();
        tessellator.d(colorRGB);
        tessellator.a(x, y + height, z);
        tessellator.a(x + width, y + height, z);
        tessellator.a(x + width, y, z);
        tessellator.a(x, y, z);
        tessellator.a();
        GL11.glEnable((int)3553);
    }

    public static List getEdgesForFace(ForgeDirection face) {
        ArrayList<ForgeDirection> result = new ArrayList<ForgeDirection>(4);
        if (face.offsetY != 0) {
            result.add(ForgeDirection.EAST);
            result.add(ForgeDirection.WEST);
            result.add(ForgeDirection.NORTH);
            result.add(ForgeDirection.SOUTH);
        } else if (face.offsetX != 0) {
            result.add(ForgeDirection.DOWN);
            result.add(ForgeDirection.UP);
            result.add(ForgeDirection.SOUTH);
            result.add(ForgeDirection.NORTH);
        } else {
            result.add(ForgeDirection.UP);
            result.add(ForgeDirection.DOWN);
            result.add(ForgeDirection.WEST);
            result.add(ForgeDirection.EAST);
        }
        return result;
    }

    public static void renderConnectedTextureFace(aak blockAccess, int x, int y, int z, ForgeDirection face, lx texture, boolean forceAllEdges) {
        RenderUtil.renderConnectedTextureFace(blockAccess, x, y, z, face, texture, forceAllEdges, true, true);
    }

    public static void renderConnectedTextureFace(aak blockAccess, int x, int y, int z, ForgeDirection face, lx texture, boolean forceAllEdges, boolean translateToXYZ, boolean applyFaceShading) {
        if (!forceAllEdges) {
            int blockID = blockAccess.a(x, y, z);
            if (blockID <= 0 || apa.r[blockID] == null) {
                return;
            }
            if (!apa.r[blockID].a(blockAccess, x + face.offsetX, y + face.offsetY, z + face.offsetZ, face.ordinal())) {
                return;
            }
        }
        BlockCoord bc = new BlockCoord(x, y, z);
        List edges = forceAllEdges ? RenderUtil.getEdgesForFace(face) : RenderUtil.getNonConectedEdgesForFace(blockAccess, x, y, z, face);
        bgd tes = bgd.a;
        tes.b((float)face.offsetX, (float)face.offsetY, (float)face.offsetZ);
        if (applyFaceShading) {
            float cm = RenderUtil.getColorMultiplierForFace(face);
            tes.a(cm, cm, cm);
        }
        float scaleFactor = 0.9375f;
        Vector2d uv = new Vector2d();
        for (ForgeDirection edge : edges) {
            float xLen = 1.0f - (float)Math.abs(edge.offsetX) * scaleFactor;
            float yLen = 1.0f - (float)Math.abs(edge.offsetY) * scaleFactor;
            float zLen = 1.0f - (float)Math.abs(edge.offsetZ) * scaleFactor;
            BoundingBox bb = BoundingBox.UNIT_CUBE.scale(xLen, yLen, zLen);
            List corners = bb.getCornersForFace(face);
            for (Vector3f unitCorn : corners) {
                Vector3d corner = new Vector3d(unitCorn);
                if (translateToXYZ) {
                    corner.x += (double)x;
                    corner.y += (double)y;
                    corner.z += (double)z;
                }
                corner.x += (double)((float)((double)edge.offsetX * 0.5) - Math.signum(edge.offsetX) * xLen / 2.0f);
                corner.y += (double)((float)((double)edge.offsetY * 0.5) - Math.signum(edge.offsetY) * yLen / 2.0f);
                corner.z += (double)((float)((double)edge.offsetZ * 0.5) - Math.signum(edge.offsetZ) * zLen / 2.0f);
                if (translateToXYZ) {
                    RenderUtil.getUvForCorner(uv, corner, x, y, z, face, texture);
                } else {
                    RenderUtil.getUvForCorner(uv, corner, 0, 0, 0, face, texture);
                }
                tes.a(corner.x, corner.y, corner.z, uv.x, uv.y);
            }
        }
    }

    public static List getNonConectedEdgesForFace(aak blockAccess, int x, int y, int z, ForgeDirection face) {
        int blockID = blockAccess.a(x, y, z);
        if (blockID <= 0 || apa.r[blockID] == null) {
            return Collections.emptyList();
        }
        if (!apa.r[blockID].a(blockAccess, x + face.offsetX, y + face.offsetY, z + face.offsetZ, face.ordinal())) {
            return Collections.emptyList();
        }
        BlockCoord bc = new BlockCoord(x, y, z);
        ArrayList<EdgeNeighbour> edges = new ArrayList<EdgeNeighbour>(4);
        for (ForgeDirection dir : RenderUtil.getEdgesForFace(face)) {
            edges.add(new EdgeNeighbour(bc, dir));
        }
        ArrayList<ForgeDirection> result = new ArrayList<ForgeDirection>(4);
        for (EdgeNeighbour edge : edges) {
            if (blockAccess.a(edge.bc.x, edge.bc.y, edge.bc.z) == blockID) continue;
            result.add(edge.dir);
        }
        return result;
    }

    public static void getUvForCorner(Vector2d uv, Vector3d corner, int x, int y, int z, ForgeDirection face, lx icon) {
        Vector3d p = new Vector3d(corner);
        p.x -= (double)x;
        p.y -= (double)y;
        p.z -= (double)z;
        float uWidth = icon.f() - icon.e();
        float vWidth = icon.h() - icon.g();
        uv.x = VecmathUtil.distanceFromPointToPlane(RenderUtil.getUPlaneForFace(face), p);
        uv.y = VecmathUtil.distanceFromPointToPlane(RenderUtil.getVPlaneForFace(face), p);
        uv.x = (double)icon.e() + uv.x * (double)uWidth;
        uv.y = (double)icon.g() + uv.y * (double)vWidth;
    }

    public static Vector4d getVPlaneForFace(ForgeDirection face) {
        switch (face) {
            case DOWN: 
            case UP: {
                return new Vector4d(0.0, 0.0, 1.0, 0.0);
            }
            case EAST: 
            case WEST: 
            case NORTH: 
            case SOUTH: {
                return new Vector4d(0.0, -1.0, 0.0, 1.0);
            }
        }
        return null;
    }

    public static Vector4d getUPlaneForFace(ForgeDirection face) {
        switch (face) {
            case DOWN: 
            case UP: {
                return new Vector4d(1.0, 0.0, 0.0, 0.0);
            }
            case EAST: {
                return new Vector4d(0.0, 0.0, -1.0, 1.0);
            }
            case WEST: {
                return new Vector4d(0.0, 0.0, 1.0, 0.0);
            }
            case NORTH: {
                return new Vector4d(-1.0, 0.0, 0.0, 1.0);
            }
            case SOUTH: {
                return new Vector4d(1.0, 0.0, 0.0, 0.0);
            }
        }
        return null;
    }

    private static class EdgeNeighbour {
        final ForgeDirection dir;
        final BlockCoord bc;

        public EdgeNeighbour(BlockCoord bc, ForgeDirection dir) {
            this.dir = dir;
            this.bc = bc.getLocation(dir);
        }
    }
}

