/*
 * Decompiled with CFR 0.152.
 */
package crazypants.util;

import net.minecraftforge.common.ForgeDirection;

public final class BlockCoord {
    public final int x;
    public final int y;
    public final int z;

    public BlockCoord(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public BlockCoord(aqp tile) {
        this(tile.l, tile.m, tile.n);
    }

    public BlockCoord getLocation(ForgeDirection dir) {
        return new BlockCoord(this.x + dir.offsetX, this.y + dir.offsetY, this.z + dir.offsetZ);
    }

    public int distanceSquared(BlockCoord other) {
        int dx = this.x - other.x;
        int dy = this.y - other.y;
        int dz2 = this.z - other.z;
        return dx * dx + dy * dy + dz2 * dz2;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockCoord other = (BlockCoord)obj;
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return this.z == other.z;
    }

    public String toString() {
        return "BlockCoord [x=" + this.x + ", y=" + this.y + ", z=" + this.z + "]";
    }

    public boolean equals(int xCoord, int yCoord, int zCoord) {
        return this.x == xCoord && this.y == yCoord && this.z == zCoord;
    }
}

