/*
 * Decompiled with CFR 0.152.
 */
package crazypants.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.DimensionManager;

public class DebugGuiTPS
extends JFrame {
    private static final DecimalFormat FORMAT = new DecimalFormat("########0.000");
    private JPanel contentPane = new JPanel();

    public static void showTpsGUI() {
        DebugGuiTPS g = new DebugGuiTPS();
        g.setVisible(true);
    }

    private DebugGuiTPS() {
        Timer timer = new Timer(2000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DebugGuiTPS.this.updateTps();
            }
        });
        timer.setRepeats(true);
        timer.start();
        this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
        this.setTitle("TPS");
        this.setLayout(new BorderLayout());
        this.add((Component)this.contentPane, "Center");
        this.setSize(200, 120);
    }

    private void updateTps() {
        this.contentPane.removeAll();
        MinecraftServer server = MinecraftServer.D();
        if (server == null) {
            return;
        }
        String s = "Avg tick: " + FORMAT.format(this.average(server.i) * 1.0E-6) + " ms";
        JLabel l = new JLabel(s);
        this.contentPane.add(l);
        if (server.b != null) {
            for (Integer id : DimensionManager.getIDs()) {
                s = "Lvl " + id + " tick: " + FORMAT.format(this.average((long[])server.worldTickTimes.get(id)) * 1.0E-6) + " ms";
                l = new JLabel(s);
                this.contentPane.add(l);
            }
        }
        this.revalidate();
        this.repaint();
    }

    private double average(long[] values) {
        long i = 0L;
        for (int j = 0; j < values.length; ++j) {
            i += values[j];
        }
        return (double)i / (double)values.length;
    }
}

