/*
 * Decompiled with CFR 0.152.
 */
package crazypants.vecmath;

import crazypants.vecmath.Matrix4d;
import crazypants.vecmath.Vector2f;
import crazypants.vecmath.Vector3d;
import crazypants.vecmath.Vector3f;

public class Vertex {
    public final Vector3d xyz = new Vector3d();
    public final Vector2f uv = new Vector2f();
    public final Vector3f normal = new Vector3f();

    public Vertex() {
    }

    public Vertex(Vertex other) {
        this.xyz.set(other.xyz);
        this.uv.set(other.uv);
        this.normal.set(other.normal);
    }

    public Vertex(Vector3d xyz, Vector3f normal, Vector2f uv) {
        this.xyz.set(xyz);
        this.normal.set(normal);
        this.uv.set(uv);
    }

    public void setXYZ(double x, double y, double z) {
        this.xyz.set(x, y, z);
    }

    public void setUV(double u, double v) {
        this.uv.set(u, v);
    }

    public void setNormal(double x, double y, double z) {
        this.normal.set((float)x, (float)y, (float)z);
        this.normal.normalize();
    }

    public void transform(Matrix4d xform) {
        xform.transform(this.xyz);
        xform.transformNormal(this.normal);
    }

    public void translate(Vector3d trans) {
        this.xyz.add(trans);
    }

    public double x() {
        return this.xyz.x;
    }

    public double y() {
        return this.xyz.y;
    }

    public double z() {
        return this.xyz.z;
    }

    public float nx() {
        return this.normal.x;
    }

    public float ny() {
        return this.normal.y;
    }

    public float nz() {
        return this.normal.z;
    }

    public float u() {
        return this.uv.x;
    }

    public float v() {
        return this.uv.y;
    }

    public String toString() {
        return "Vertex [xyz=" + this.xyz + ", uv=" + this.uv + "]";
    }
}

