/*
 * Decompiled with CFR 0.152.
 */
package factorization.client;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.KeyBindingRegistry;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.relauncher.Side;
import factorization.api.Coord;
import factorization.api.IFactoryType;
import factorization.client.gui.FactorizationNotify;
import factorization.client.gui.GuiCrystallizer;
import factorization.client.gui.GuiGrinder;
import factorization.client.gui.GuiMaker;
import factorization.client.gui.GuiMixer;
import factorization.client.gui.GuiParasieve;
import factorization.client.gui.GuiPocketTable;
import factorization.client.gui.GuiRouter;
import factorization.client.gui.GuiSlag;
import factorization.client.gui.GuiStamper;
import factorization.client.render.BatteryItemRender;
import factorization.client.render.BlockRenderBattery;
import factorization.client.render.BlockRenderCrystallizer;
import factorization.client.render.BlockRenderDefault;
import factorization.client.render.BlockRenderEmpty;
import factorization.client.render.BlockRenderGreenware;
import factorization.client.render.BlockRenderGrinder;
import factorization.client.render.BlockRenderHeater;
import factorization.client.render.BlockRenderLamp;
import factorization.client.render.BlockRenderLeydenJar;
import factorization.client.render.BlockRenderMirrorStand;
import factorization.client.render.BlockRenderMixer;
import factorization.client.render.BlockRenderRocketEngine;
import factorization.client.render.BlockRenderSteamTurbine;
import factorization.client.render.BlockRenderWire;
import factorization.client.render.EmptyRender;
import factorization.client.render.EntityWrathFlameFX;
import factorization.client.render.FactorizationBlockRender;
import factorization.client.render.FactorizationRender;
import factorization.client.render.ItemRenderCapture;
import factorization.client.render.ItemRenderGlazeBucket;
import factorization.client.render.TileEntityBarrelRenderer;
import factorization.client.render.TileEntityCrystallizerRender;
import factorization.client.render.TileEntityGreenwareRender;
import factorization.client.render.TileEntityGrinderRender;
import factorization.client.render.TileEntityHeaterRenderer;
import factorization.client.render.TileEntityLeydenJarRender;
import factorization.client.render.TileEntityMixerRenderer;
import factorization.client.render.TileEntitySteamTurbineRender;
import factorization.common.BlockRenderHelper;
import factorization.common.Command;
import factorization.common.ContainerCrystallizer;
import factorization.common.ContainerFactorization;
import factorization.common.ContainerGrinder;
import factorization.common.ContainerMixer;
import factorization.common.ContainerPocket;
import factorization.common.ContainerSlagFurnace;
import factorization.common.Core;
import factorization.common.FactorizationProxy;
import factorization.common.FactoryType;
import factorization.common.TileEntityBarrel;
import factorization.common.TileEntityCrystallizer;
import factorization.common.TileEntityFactorization;
import factorization.common.TileEntityGreenware;
import factorization.common.TileEntityGrinder;
import factorization.common.TileEntityHeater;
import factorization.common.TileEntityLeydenJar;
import factorization.common.TileEntityMixer;
import factorization.common.TileEntitySlagFurnace;
import factorization.common.TileEntitySteamTurbine;
import factorization.common.TileEntityWrathLamp;
import factorization.common.servo.BlockRenderServoRail;
import factorization.common.servo.RenderServoMotor;
import factorization.common.servo.ServoMotor;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.profiler.Profiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.input.Keyboard;

public class FactorizationClientProxy
extends FactorizationProxy {
    int fireParticlesSpawned = 0;
    int fireParticlesMax = 5;
    public static KeyBinding bag_swap_key = new KeyBinding("FZ Bag of Holding", 41);
    public static KeyBinding pocket_key = new KeyBinding("FZ Pocket Crafting Table", 46);

    @Override
    public void broadcastTranslate(EntityPlayer who, String ... msg) {
        String format = msg[0];
        String[] params = new String[msg.length - 1];
        System.arraycopy(msg, 1, params, 0, msg.length - 1);
        try {
            who.func_71035_c(String.format(format, params));
        }
        catch (IllegalFormatException e) {
            // empty catch block
        }
    }

    @Override
    public EntityPlayer getPlayer(NetHandler handler) {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public Profiler getProfiler() {
        return Minecraft.func_71410_x().field_71424_I;
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID == FactoryType.POCKETCRAFTGUI.gui) {
            return new GuiPocketTable(new ContainerPocket(player));
        }
        TileEntity te = world.func_72796_p(x, y, z);
        if (!(te instanceof TileEntityFactorization)) {
            return null;
        }
        TileEntityFactorization fac = (TileEntityFactorization)te;
        ContainerFactorization cont = ID == FactoryType.SLAGFURNACE.gui ? new ContainerSlagFurnace(player, fac) : (ID == FactoryType.GRINDER.gui ? new ContainerGrinder(player, fac) : (ID == FactoryType.MIXER.gui ? new ContainerMixer(player, fac) : (ID == FactoryType.CRYSTALLIZER.gui ? new ContainerCrystallizer(player, fac) : new ContainerFactorization(player, fac))));
        GuiContainer gui = null;
        if (ID == FactoryType.ROUTER.gui) {
            gui = new GuiRouter(cont);
        }
        if (ID == FactoryType.MAKER.gui) {
            gui = new GuiMaker(cont);
        }
        if (ID == FactoryType.STAMPER.gui) {
            gui = new GuiStamper(cont);
        }
        if (ID == FactoryType.SLAGFURNACE.gui) {
            gui = new GuiSlag(cont);
        }
        if (ID == FactoryType.GRINDER.gui) {
            gui = new GuiGrinder(cont);
        }
        if (ID == FactoryType.MIXER.gui) {
            gui = new GuiMixer(cont);
        }
        if (ID == FactoryType.CRYSTALLIZER.gui) {
            gui = new GuiCrystallizer(cont);
        }
        if (ID == FactoryType.PARASIEVE.gui) {
            gui = new GuiParasieve(cont);
        }
        cont.addSlotsForGui(fac, player.field_71071_by);
        return gui;
    }

    @Override
    public String translateItemStack(ItemStack is) {
        if (is == null) {
            return "null";
        }
        return is.func_77973_b().func_77628_j(is);
    }

    @Override
    public void pokePocketCrafting() {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.field_71462_r instanceof GuiPocketTable) {
            GuiPocketTable gui = (GuiPocketTable)minecraft.field_71462_r;
            gui.containerPocket.updateCraft();
        }
    }

    @Override
    public void randomDisplayTickFor(World w, int x, int y, int z, Random rand) {
        Coord here = new Coord(w, x, y, z);
        int id = w.func_72798_a(x, y, z);
        int md = w.func_72805_g(x, y, z);
        if (id == Core.registry.factory_block.field_71990_ca) {
            TileEntity te = w.func_72796_p(x, y, z);
            if (!(te instanceof IFactoryType)) {
                return;
            }
            FactoryType ft = ((IFactoryType)te).getFactoryType();
            if (ft == FactoryType.LAMP) {
                for (int i = 0; i < 3; ++i) {
                    double X = (double)x + 0.4 + (double)rand.nextFloat() * 0.2;
                    double Z = (double)z + 0.4 + (double)rand.nextFloat() * 0.2;
                    EntityWrathFlameFX flame = new EntityWrathFlameFX(w, X, (double)y + 0.2 + (double)rand.nextFloat() * 0.1, Z, 0.001 - (double)rand.nextFloat() * 0.002, 0.01, 0.001 - (double)rand.nextFloat() * 0.002);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)flame);
                }
            }
            if (ft == FactoryType.SLAGFURNACE) {
                TileEntitySlagFurnace slag = (TileEntitySlagFurnace)te;
                if (slag.draw_active <= 0) {
                    return;
                }
                byte var6 = slag.facing_direction;
                float var7 = (float)x + 0.5f;
                float var8 = (float)y + 0.0f + rand.nextFloat() * 6.0f / 16.0f;
                float var9 = (float)z + 0.5f;
                float var10 = 0.52f;
                float var11 = rand.nextFloat() * 0.6f - 0.3f;
                if (var6 == 4) {
                    w.func_72869_a("smoke", (double)(var7 - var10), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
                    w.func_72869_a("flame", (double)(var7 - var10), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
                } else if (var6 == 5) {
                    w.func_72869_a("smoke", (double)(var7 + var10), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
                    w.func_72869_a("flame", (double)(var7 + var10), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
                } else if (var6 == 2) {
                    w.func_72869_a("smoke", (double)(var7 + var11), (double)var8, (double)(var9 - var10), 0.0, 0.0, 0.0);
                    w.func_72869_a("flame", (double)(var7 + var11), (double)var8, (double)(var9 - var10), 0.0, 0.0, 0.0);
                } else if (var6 == 3) {
                    w.func_72869_a("smoke", (double)(var7 + var11), (double)var8, (double)(var9 + var10), 0.0, 0.0, 0.0);
                    w.func_72869_a("flame", (double)(var7 + var11), (double)var8, (double)(var9 + var10), 0.0, 0.0, 0.0);
                }
            }
        }
        if (id == Core.registry.lightair_block.field_71990_ca && md == 1) {
            int to_spawn = 1;
            EntityPlayer player = Core.proxy.getClientPlayer();
            boolean force = false;
            boolean big = true;
            if (player != null) {
                int dx = (int)player.field_70165_t - x;
                int dy = (int)player.field_70163_u - y;
                int dz = (int)player.field_70161_v - z;
                int dist = Math.abs(dx) + Math.abs(dy) + Math.abs(dz);
                if (dist < 4) {
                    to_spawn = 8;
                    force = true;
                    big = false;
                } else if (dist <= 12) {
                    to_spawn = 4;
                    force = true;
                } else if (dist <= 16) {
                    to_spawn = 1;
                }
            }
            if (this.fireParticlesSpawned >= this.fireParticlesMax) {
                if (!force) {
                    return;
                }
                to_spawn /= 4;
            }
            if (!force) {
                this.fireParticlesSpawned += to_spawn;
            }
            for (int i = 0; i < to_spawn; ++i) {
                double X = (double)x + 0.05 + (double)rand.nextFloat() * 0.95;
                double Z = (double)z + 0.05 + (double)rand.nextFloat() * 0.95;
                EntityWrathFlameFX flame = new EntityWrathFlameFX(w, X, (double)y + (double)rand.nextFloat() * 0.25, Z, ((double)rand.nextFloat() - 0.5) * 0.02, 0.05 + (double)rand.nextFloat() * 0.04, ((double)rand.nextFloat() - 0.5) * 0.02);
                if (big) {
                    flame.setScale(4);
                }
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)flame);
            }
        }
    }

    @Override
    public void playSoundFX(String src, float volume, float pitch) {
        Minecraft.func_71410_x().field_71416_A.func_77366_a(src, volume, pitch);
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void registerKeys() {
        KeyBindingRegistry.registerKeyBinding((KeyBindingRegistry.KeyHandler)CommandKeySet.create(new Object[]{bag_swap_key, Command.bagShuffle, pocket_key, Command.craftOpen}));
    }

    private void setTileEntityRenderer(Class clazz, TileEntitySpecialRenderer r) {
        ClientRegistry.bindTileEntitySpecialRenderer((Class)clazz, (TileEntitySpecialRenderer)r);
    }

    @Override
    public void registerRenderers() {
        if (Core.render_barrel_item || Core.render_barrel_text) {
            this.setTileEntityRenderer(TileEntityBarrel.class, new TileEntityBarrelRenderer(Core.render_barrel_item, Core.render_barrel_text));
        }
        this.setTileEntityRenderer(TileEntityGreenware.class, new TileEntityGreenwareRender());
        if (Core.renderTEs) {
            this.setTileEntityRenderer(TileEntityHeater.class, new TileEntityHeaterRenderer());
            this.setTileEntityRenderer(TileEntityGrinder.class, new TileEntityGrinderRender());
            this.setTileEntityRenderer(TileEntityMixer.class, new TileEntityMixerRenderer());
            this.setTileEntityRenderer(TileEntityCrystallizer.class, new TileEntityCrystallizerRender());
            this.setTileEntityRenderer(TileEntitySteamTurbine.class, new TileEntitySteamTurbineRender());
            this.setTileEntityRenderer(TileEntityLeydenJar.class, new TileEntityLeydenJarRender());
        }
        RenderingRegistry.registerEntityRenderingHandler(TileEntityWrathLamp.RelightTask.class, (Render)new EmptyRender());
        RenderingRegistry.registerEntityRenderingHandler(ServoMotor.class, (Render)new RenderServoMotor());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new FactorizationRender());
        BlockRenderBattery renderBattery = new BlockRenderBattery();
        new BlockRenderLeydenJar();
        new BlockRenderDefault();
        new BlockRenderHeater();
        new BlockRenderLamp();
        new BlockRenderMirrorStand();
        new BlockRenderSteamTurbine();
        new BlockRenderWire();
        new BlockRenderGrinder();
        new BlockRenderMixer();
        new BlockRenderCrystallizer();
        new BlockRenderGreenware().setup();
        new BlockRenderRocketEngine();
        new BlockRenderServoRail();
        for (FactoryType ft : new FactoryType[]{FactoryType.ROUTER, FactoryType.MAKER, FactoryType.STAMPER, FactoryType.BARREL, FactoryType.PACKAGER, FactoryType.SLAGFURNACE, FactoryType.SOLARBOILER, FactoryType.PARASIEVE}) {
            FactorizationBlockRender.setDefaultRender(ft);
        }
        new BlockRenderEmpty(FactoryType.EXTENDED);
        ItemRenderCapture capture = new ItemRenderCapture();
        MinecraftForgeClient.registerItemRenderer((int)Core.registry.battery.field_77779_bT, (IItemRenderer)new BatteryItemRender(renderBattery));
        MinecraftForgeClient.registerItemRenderer((int)Core.registry.factory_block.field_71990_ca, (IItemRenderer)capture);
        MinecraftForgeClient.registerItemRenderer((int)Core.registry.glaze_bucket.field_77779_bT, (IItemRenderer)new ItemRenderGlazeBucket());
        MinecraftForge.EVENT_BUS.register((Object)new FactorizationNotify());
        if (Minecraft.func_71410_x().field_71449_j.field_74286_b.equals("neptunepink")) {
            Core.FZLogger.setLevel(Level.FINE);
        }
    }

    @Override
    public void texturepackChanged() {
        TileEntityGrinderRender.remakeModel();
    }

    @Override
    public boolean BlockRenderHelper_has_texture(BlockRenderHelper block2, int f) {
        if (block2.textures == null) {
            return true;
        }
        return block2.textures[f] != null;
    }

    @Override
    public void BlockRenderHelper_clear_texture(BlockRenderHelper block2) {
        block2.textures = null;
    }

    @Override
    public String getPocketCraftingTableKey() {
        return GameSettings.func_74298_c((int)FactorizationClientProxy.pocket_key.field_74512_d);
    }

    @Override
    public boolean isClientHoldingShift() {
        if (FMLCommonHandler.instance().getEffectiveSide() != Side.CLIENT) {
            return false;
        }
        Minecraft mc = Minecraft.func_71410_x();
        return Keyboard.isKeyDown((int)42);
    }

    private static class CommandKeySet
    extends KeyBindingRegistry.KeyHandler {
        Map map;

        static CommandKeySet create(Object ... args) {
            KeyBinding[] bindings = new KeyBinding[args.length / 2];
            boolean[] repeatings = new boolean[args.length / 2];
            HashMap<KeyBinding, Command> map = new HashMap<KeyBinding, Command>();
            for (int i = 0; i < args.length; i += 2) {
                KeyBinding key = (KeyBinding)args[i];
                Command cmd = (Command)((Object)args[i + 1]);
                map.put(key, cmd);
                bindings[i / 2] = key;
                repeatings[i / 2] = false;
            }
            CommandKeySet ret = new CommandKeySet(bindings, repeatings);
            ret.map = map;
            return ret;
        }

        private CommandKeySet(KeyBinding[] keyBindings, boolean[] repeatings) {
            super(keyBindings, repeatings);
        }

        public EnumSet ticks() {
            return EnumSet.of(TickType.CLIENT);
        }

        public String getLabel() {
            return "CommandKeys";
        }

        public void keyDown(EnumSet types, KeyBinding kb, boolean tickEnd, boolean isRepeat) {
            if (tickEnd) {
                return;
            }
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui != null) {
                return;
            }
            Command command = (Command)((Object)this.map.get(kb));
            EntityPlayer player = Core.proxy.getClientPlayer();
            if (player == null) {
                return;
            }
            if (player.func_70093_af()) {
                command = command.reverse;
            }
            command.call(Core.proxy.getClientPlayer());
        }

        public void keyUp(EnumSet types, KeyBinding kb, boolean tickEnd) {
        }
    }
}

