/*
 * Decompiled with CFR 0.152.
 */
package factorization.client.render;

import factorization.client.render.FactorizationBlockRender;
import factorization.common.BasicGlazes;
import factorization.common.BlockIcons;
import factorization.common.BlockRenderHelper;
import factorization.common.Core;
import factorization.common.FactoryType;
import factorization.common.TileEntityGreenware;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class BlockRenderGreenware
extends FactorizationBlockRender {
    static BlockRenderGreenware instance;
    private boolean texture_init = false;
    private static TileEntityGreenware loader;
    private static Random rawMimicRandom;
    private boolean spammed = false;

    public BlockRenderGreenware() {
        instance = this;
        this.setup();
    }

    public void setup() {
        if (this.texture_init) {
            return;
        }
    }

    @Override
    protected void render(RenderBlocks rb) {
        TileEntityGreenware.ClayState state;
        if (!this.world_mode) {
            if (this.is == null) {
                return;
            }
            BlockRenderHelper block2 = BlockRenderHelper.instance;
            boolean stand = true;
            boolean rescale = false;
            if (this.is.func_77942_o()) {
                loader.loadParts(this.is.func_77978_p());
                int minX = 32;
                int minY = 32;
                int minZ = 32;
                int maxX = 0;
                int maxY = 32;
                int maxZ = 32;
                for (TileEntityGreenware.ClayLump cl : BlockRenderGreenware.loader.parts) {
                    minX = Math.min(minX, cl.minX);
                    minY = Math.min(minY, cl.minY);
                    minZ = Math.min(minZ, cl.minZ);
                    maxX = Math.max(maxX, cl.maxX);
                    maxY = Math.max(maxY, cl.maxY);
                    maxZ = Math.max(maxZ, cl.maxZ);
                    int min = Math.min(Math.min(minX, minY), minZ);
                    int max = Math.max(Math.max(maxX, maxY), maxZ);
                    if (min >= 16 && max <= 32) continue;
                    rescale = true;
                    break;
                }
                if (rescale) {
                    GL11.glPushMatrix();
                    float scale = 0.33333334f;
                    GL11.glScalef((float)scale, (float)scale, (float)scale);
                }
                this.renderDynamic(loader);
                TileEntityGreenware.ClayState cs = loader.getState();
                stand = cs == TileEntityGreenware.ClayState.WET || cs == TileEntityGreenware.ClayState.DRY;
            } else {
                this.setupRenderGenericLump().renderForInventory(rb);
            }
            if (stand) {
                this.setupRenderStand().renderForInventory(rb);
            }
            if (rescale) {
                GL11.glPopMatrix();
            }
            return;
        }
        TileEntityGreenware gw = (TileEntityGreenware)this.getCoord().getTE(TileEntityGreenware.class);
        if (gw == null) {
            return;
        }
        if (this.world_mode) {
            Tessellator.field_78398_a.func_78380_c(Core.registry.factory_block.func_71874_e(this.w, this.x, this.y, this.z));
        }
        if ((state = gw.getState()) == TileEntityGreenware.ClayState.DRY || state == TileEntityGreenware.ClayState.WET) {
            BlockRenderHelper block3 = this.setupRenderStand();
            block3.render(rb, this.x, this.y, this.z);
        }
        if (!gw.canEdit()) {
            this.renderStatic(gw);
        }
        gw.shouldRenderTesr = state == TileEntityGreenware.ClayState.WET;
    }

    int getColor(TileEntityGreenware.ClayLump rc) {
        if (rc.raw_color == -1) {
            if (rc.icon_id == Core.registry.resource_block.field_71990_ca && rc.icon_md > 16) {
                for (BasicGlazes bg : BasicGlazes.values()) {
                    if (bg.metadata != rc.icon_md) continue;
                    if (bg.raw_color == -1) {
                        bg.raw_color = 0xFF00FF;
                    }
                    rc.raw_color = bg.raw_color;
                    break;
                }
            }
            if (rc.raw_color == -1) {
                rawMimicRandom.setSeed((rc.icon_id << 16) + rc.icon_md);
                int c = 0;
                for (int i = 0; i < 3; ++i) {
                    c += rawMimicRandom.nextInt(224) + 10;
                    c <<= 16;
                }
                rc.raw_color = c;
            }
        }
        return rc.raw_color;
    }

    void renderToTessellator(TileEntityGreenware greenware) {
        BlockRenderHelper block2 = BlockRenderHelper.instance;
        TileEntityGreenware.ClayState state = greenware.getState();
        if (state != TileEntityGreenware.ClayState.HIGHFIRED) {
            switch (state) {
                case WET: {
                    block2.useTexture(Block.field_72041_aW.func_71851_a(0));
                    break;
                }
                case DRY: {
                    block2.useTexture(BlockIcons.ceramics$dry);
                    break;
                }
                case BISQUED: {
                    block2.useTexture(BlockIcons.ceramics$bisque);
                    break;
                }
                case UNFIRED_GLAZED: {
                    block2.useTexture(BlockIcons.ceramics$rawglaze);
                    break;
                }
                default: {
                    block2.useTexture(BlockIcons.error);
                }
            }
        }
        boolean colors_changed = false;
        for (TileEntityGreenware.ClayLump rc : greenware.parts) {
            if (state == TileEntityGreenware.ClayState.HIGHFIRED) {
                Block it = Block.field_71973_m[rc.icon_id];
                if (it == null) {
                    block2.useTexture(BlockIcons.error);
                } else {
                    for (int i = 0; i < 6; ++i) {
                        block2.setTexture(i, it.func_71858_a(i, (int)rc.icon_md));
                        int color = 0xFFFFFF;
                        if (greenware.field_70331_k != null) {
                            try {
                                color = it.func_71920_b((IBlockAccess)greenware.field_70331_k, greenware.field_70329_l, greenware.field_70330_m, greenware.field_70327_n);
                            }
                            catch (Throwable t) {
                                if (!this.spammed) {
                                    this.spammed = true;
                                    Core.logWarning("%s could not give a Block.colorMultiplier", it);
                                    t.printStackTrace();
                                }
                            }
                        } else {
                            color = it.func_71889_f_(i);
                        }
                        if (color == 0xFFFFFF) continue;
                        colors_changed = true;
                        block2.setColor(i, color);
                    }
                }
            }
            if (state == TileEntityGreenware.ClayState.UNFIRED_GLAZED) {
                block2.setColor(this.getColor(rc));
                colors_changed = true;
            }
            rc.toBlockBounds(block2);
            block2.begin();
            block2.rotateMiddle(rc.quat);
            block2.renderRotated(Tessellator.field_78398_a, this.x, this.y, this.z);
        }
        if (colors_changed) {
            block2.resetColors();
        }
    }

    void renderDynamic(TileEntityGreenware greenware) {
        Tessellator.field_78398_a.func_78382_b();
        this.renderToTessellator(greenware);
        Tessellator.field_78398_a.func_78381_a();
    }

    void renderStatic(TileEntityGreenware greenware) {
        this.renderToTessellator(greenware);
    }

    BlockRenderHelper setupRenderStand() {
        BlockRenderHelper block2 = BlockRenderHelper.instance;
        block2.useTexture(BlockIcons.ceramics$stand);
        block2.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        return block2;
    }

    BlockRenderHelper setupRenderGenericLump() {
        BlockRenderHelper block2 = BlockRenderHelper.instance;
        block2.useTexture(Block.field_72041_aW.func_71851_a(0));
        block2.func_71905_a(0.1875f, 0.125f, 0.1875f, 0.8125f, 0.875f, 0.8125f);
        return block2;
    }

    @Override
    protected FactoryType getFactoryType() {
        return FactoryType.CERAMIC;
    }

    static {
        loader = new TileEntityGreenware();
        rawMimicRandom = new Random();
    }
}

