/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.common.Core;
import factorization.common.FactorizationUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;

public class ContainerPocket
extends ContainerWorkbench {
    EntityPlayer player;
    InventoryProxy inv;
    SlotCrafting slotCrafting;
    static final List craftArea = Arrays.asList(6, 7, 8, 15, 16, 17, 24, 25, 26);
    static final List inventoryArea = Arrays.asList(0, 1, 2, 3, 4, 5, 9, 10, 11, 12, 13, 14, 18, 19, 20, 21, 22, 23, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36);
    static final List playerNormalInvSlots = Arrays.asList(9, 10, 11, 12, 13, 14, 18, 19, 20, 21, 22, 23, 27, 28, 29, 30, 31, 32, 0, 1, 2, 3, 4, 5, 6, 7, 8);
    static final List playerNormalInvSlotsAlt = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 18, 19, 20, 21, 22, 23, 27, 28, 29, 30, 31, 32);
    static final List playerCraftInvSlots = Arrays.asList(15, 16, 17, 24, 25, 26, 33, 34, 35);

    public ContainerPocket(EntityPlayer player) {
        super(player.field_71071_by, player.field_70170_p, 0, 0, 0);
        this.player = player;
        this.inv = new InventoryProxy((IInventory)player.field_71071_by);
        this.field_75151_b.clear();
        this.field_75153_a.clear();
        this.addPlayerSlots(this.inv);
        this.slotCrafting = new RedirectedSlotCrafting(player, (IInventory)this.field_75162_e, this.field_75160_f, 0, 208, 28);
        this.func_75146_a((Slot)this.slotCrafting);
        this.func_75142_b();
        this.updateCraft();
    }

    void addPlayerSlots(IInventory inventoryplayer) {
        int x;
        int y;
        int invdx = 0;
        int invdy = 0;
        int col_limit = 6;
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot(inventoryplayer, x + y * 9 + 9, invdx + 8 + x * 18, invdy + 8 + y * 18));
            }
        }
        y = 3;
        for (x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot(inventoryplayer, x, invdx + 8 + x * 18, 4 + invdy + 8 + y * 18));
        }
    }

    void updateMatrix() {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack is = this.player.field_71071_by.func_70301_a(6 + x + (1 + y) * 9);
                this.field_75162_e.func_70299_a(x + y * 3, is);
            }
        }
    }

    public void updateCraft() {
        this.updateMatrix();
        this.func_75130_a((IInventory)this.player.field_71071_by);
    }

    public boolean func_75145_c(EntityPlayer player) {
        return Core.registry.pocket_table.findPocket(player) != null;
    }

    public void func_75141_a(int par1, ItemStack par2ItemStack) {
        super.func_75141_a(par1, par2ItemStack);
        this.updateCraft();
    }

    public void func_75131_a(ItemStack[] par1ArrayOfItemStack) {
        for (int var2 = 0; var2 < par1ArrayOfItemStack.length; ++var2) {
            this.func_75139_a(var2).func_75215_d(par1ArrayOfItemStack[var2]);
        }
        this.updateCraft();
    }

    public void func_75134_a(EntityPlayer par1EntityPlayer) {
        InventoryPlayer var2 = par1EntityPlayer.field_71071_by;
        if (var2.func_70445_o() != null) {
            par1EntityPlayer.func_71021_b(var2.func_70445_o());
            var2.func_70437_b((ItemStack)null);
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int i) {
        ItemStack ret = null;
        if (i == 36) {
            this.transferCraftResults(player);
        } else if (craftArea.contains(i)) {
            ret = FactorizationUtil.transferStackToArea((IInventory)player.field_71071_by, i + 9, (IInventory)player.field_71071_by, playerNormalInvSlots);
        } else if (inventoryArea.contains(i)) {
            ret = i >= 27 ? FactorizationUtil.transferStackToArea((IInventory)player.field_71071_by, i - 27, (IInventory)player.field_71071_by, playerCraftInvSlots) : FactorizationUtil.transferStackToArea((IInventory)player.field_71071_by, i + 9, (IInventory)player.field_71071_by, playerCraftInvSlots);
        }
        this.updateCraft();
        return null;
    }

    boolean spaceFreeFor(ItemStack res) {
        int freeSpace = 0;
        Iterator i$ = inventoryArea.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            if (freeSpace >= res.func_77976_d()) {
                return true;
            }
            ItemStack is = this.inv.func_70301_a(i);
            if (is == null) {
                freeSpace += res.func_77976_d();
                continue;
            }
            if (!FactorizationUtil.couldMerge(is, res)) continue;
            freeSpace += is.func_77976_d() - is.field_77994_a;
        }
        return freeSpace >= res.func_77976_d();
    }

    void transferCraftResults(EntityPlayer player) {
        ItemStack is;
        int i;
        Iterator i$;
        ItemStack res = this.field_75160_f.func_70301_a(0);
        if (res == null) {
            return;
        }
        if (player.field_71071_by.func_70445_o() != null) {
            int would_fit = 0;
            i$ = playerNormalInvSlots.iterator();
            while (i$.hasNext()) {
                i = (Integer)i$.next();
                is = this.inv.func_70301_a(i);
                if (is == null) {
                    would_fit += res.func_77976_d();
                    continue;
                }
                if (!FactorizationUtil.couldMerge(is, res)) continue;
                would_fit += is.func_77976_d() - is.field_77994_a;
            }
            if (would_fit < res.field_77994_a) {
                return;
            }
        }
        int materialRemaining = res.func_77976_d();
        i$ = playerCraftInvSlots.iterator();
        while (i$.hasNext()) {
            i = (Integer)i$.next();
            is = this.inv.func_70301_a(i);
            if (is == null || is.func_77976_d() == 1) continue;
            materialRemaining = Math.min(is.field_77994_a, materialRemaining);
        }
        int productRemaining = res.func_77976_d();
        while (this.spaceFreeFor(res) && productRemaining >= 0 && materialRemaining > 0 && (res = this.field_75160_f.func_70301_a(0)) != null && res.field_77994_a > 0) {
            productRemaining -= res.field_77994_a;
            --materialRemaining;
            assert (res != null);
            this.slotCrafting.func_82870_a(player, res);
            this.field_75160_f.func_70299_a(0, res);
            ItemStack remainder = FactorizationUtil.transferStackToArea(this.field_75160_f, 0, (IInventory)player.field_71071_by, playerNormalInvSlotsAlt);
            this.updateCraft();
            if (remainder != null && remainder.field_77994_a != 0) {
                player.field_71071_by.func_70437_b(remainder);
                break;
            }
            if (materialRemaining != 1) continue;
            break;
        }
    }

    class InventoryProxy
    implements IInventory {
        IInventory src;

        public InventoryProxy(IInventory src) {
            this.src = src;
        }

        int remapSlotId(int i) {
            return i;
        }

        public int func_70302_i_() {
            return this.src.func_70302_i_();
        }

        public ItemStack func_70301_a(int var1) {
            return this.src.func_70301_a(this.remapSlotId(var1));
        }

        public ItemStack func_70298_a(int var1, int var2) {
            ItemStack ret = this.src.func_70298_a(this.remapSlotId(var1), var2);
            ContainerPocket.this.updateCraft();
            return ret;
        }

        public ItemStack func_70304_b(int var1) {
            return this.src.func_70304_b(this.remapSlotId(var1));
        }

        public void func_70299_a(int var1, ItemStack var2) {
            this.src.func_70299_a(this.remapSlotId(var1), var2);
            ContainerPocket.this.updateCraft();
        }

        public String func_70303_b() {
            return this.src.func_70303_b();
        }

        public int func_70297_j_() {
            return this.src.func_70297_j_();
        }

        public void func_70296_d() {
            this.src.func_70296_d();
            ContainerPocket.this.updateCraft();
        }

        public boolean func_70300_a(EntityPlayer var1) {
            return this.src.func_70300_a(var1);
        }

        public void func_70295_k_() {
            this.src.func_70295_k_();
        }

        public void func_70305_f() {
            this.src.func_70305_f();
        }

        public boolean func_94042_c() {
            return false;
        }

        public boolean func_94041_b(int i, ItemStack itemstack) {
            return true;
        }
    }

    class RedirectedSlotCrafting
    extends SlotCrafting {
        public RedirectedSlotCrafting(EntityPlayer par1EntityPlayer, IInventory par2iInventory, IInventory par3iInventory, int par4, int par5, int par6) {
            super(par1EntityPlayer, par2iInventory, par3iInventory, par4, par5, par6);
        }

        public void func_82870_a(EntityPlayer player, ItemStack par1ItemStack) {
            ContainerPocket.this.updateMatrix();
            Iterator i$ = craftArea.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                player.field_71071_by.func_70299_a(i += 9, Core.registry.fake_is);
            }
            super.func_82870_a(player, par1ItemStack);
            int j = 0;
            Iterator i$2 = craftArea.iterator();
            while (i$2.hasNext()) {
                int i = (Integer)i$2.next();
                player.field_71071_by.func_70299_a(i += 9, ContainerPocket.this.field_75162_e.func_70301_a(j));
                ++j;
            }
            ContainerPocket.this.updateCraft();
        }
    }
}

