/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.util.Icon;

@SideOnly(value=Side.CLIENT)
public class FactorizationTextureLoader {
    public static void register(IconRegister reg, Class base) {
        FactorizationTextureLoader.register(reg, base, null, "factorization:");
    }

    public static void register(IconRegister reg, Class base, Object instance, String base_prefix) {
        try {
            Field[] fields;
            for (Field f : fields = base.getFields()) {
                String prefix = base_prefix;
                Directory dir = f.getAnnotation(Directory.class);
                if (dir != null) {
                    prefix = prefix + dir.value() + "/";
                }
                if (IconGroup.class.isAssignableFrom(f.getType())) {
                    IconGroup ig = (IconGroup)f.get(instance);
                    if (ig == null) {
                        ig = (IconGroup)f.getType().newInstance();
                    }
                    ig.prefix(f.getName());
                    f.set(instance, ig);
                    FactorizationTextureLoader.register(reg, f.getType(), ig, prefix + ig.group_prefix);
                    ig.afterRegister();
                }
                if (!Icon.class.isAssignableFrom(f.getType())) continue;
                String icon_file = prefix + f.getName();
                f.set(instance, reg.func_94245_a(icon_file.replace('$', '/')));
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static abstract class IconGroup {
        public String group_prefix;

        public IconGroup prefix(String prefix) {
            this.group_prefix = prefix + "_";
            return this;
        }

        public void afterRegister() {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Directory {
        public String value();
    }
}

