/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import cpw.mods.fml.common.registry.GameRegistry;
import factorization.common.Core;
import factorization.common.TileEntityBarrel;
import factorization.common.TileEntityBattery;
import factorization.common.TileEntityCommon;
import factorization.common.TileEntityCrystallizer;
import factorization.common.TileEntityExtension;
import factorization.common.TileEntityFactorization;
import factorization.common.TileEntityGreenware;
import factorization.common.TileEntityGrinder;
import factorization.common.TileEntityHeater;
import factorization.common.TileEntityLeydenJar;
import factorization.common.TileEntityMaker;
import factorization.common.TileEntityMirror;
import factorization.common.TileEntityMixer;
import factorization.common.TileEntityPackager;
import factorization.common.TileEntityParaSieve;
import factorization.common.TileEntityRocketEngine;
import factorization.common.TileEntityRouter;
import factorization.common.TileEntitySlagFurnace;
import factorization.common.TileEntitySolarBoiler;
import factorization.common.TileEntityStamper;
import factorization.common.TileEntitySteamTurbine;
import factorization.common.TileEntityWire;
import factorization.common.TileEntityWrathFire;
import factorization.common.TileEntityWrathLamp;
import factorization.common.servo.TileEntityServoRail;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;

public final class FactoryType
extends Enum {
    public static final /* enum */ FactoryType ROUTER = new FactoryType("ROUTER", 0, 0, true, TileEntityRouter.class, "factory_router");
    public static final /* enum */ FactoryType MAKER = new FactoryType("MAKER", 1, 2, true, TileEntityMaker.class, "factory_maker");
    public static final /* enum */ FactoryType STAMPER = new FactoryType("STAMPER", 2, 3, true, TileEntityStamper.class, "factory_stamper");
    public static final /* enum */ FactoryType BARREL = new FactoryType("BARREL", 3, 5, false, TileEntityBarrel.class, "factory_barrel");
    public static final /* enum */ FactoryType LAMP = new FactoryType("LAMP", 4, 6, false, TileEntityWrathLamp.class, "factory_lamp");
    public static final /* enum */ FactoryType PACKAGER = new FactoryType("PACKAGER", 5, 8, true, FactoryType.STAMPER.gui, TileEntityPackager.class, "factory_packager");
    public static final /* enum */ FactoryType WRATHFIRE = new FactoryType("WRATHFIRE", 6, 10, false, TileEntityWrathFire.class, "factory_fire");
    public static final /* enum */ FactoryType SLAGFURNACE = new FactoryType("SLAGFURNACE", 7, 11, true, TileEntitySlagFurnace.class, "factory_slag");
    public static final /* enum */ FactoryType BATTERY = new FactoryType("BATTERY", 8, 12, false, TileEntityBattery.class, "factory_battery");
    public static final /* enum */ FactoryType LEADWIRE = new FactoryType("LEADWIRE", 9, 14, false, TileEntityWire.class, "factory_solder");
    public static final /* enum */ FactoryType HEATER = new FactoryType("HEATER", 10, 15, false, TileEntityHeater.class, "factory_heater");
    public static final /* enum */ FactoryType MIRROR = new FactoryType("MIRROR", 11, 16, false, TileEntityMirror.class, "factory_mirror");
    public static final /* enum */ FactoryType GRINDER = new FactoryType("GRINDER", 12, 17, true, TileEntityGrinder.class, "factory_grinder");
    public static final /* enum */ FactoryType MIXER = new FactoryType("MIXER", 13, 18, true, TileEntityMixer.class, "factory_mixer");
    public static final /* enum */ FactoryType CRYSTALLIZER = new FactoryType("CRYSTALLIZER", 14, 19, true, TileEntityCrystallizer.class, "factory_crystal");
    public static final /* enum */ FactoryType STEAMTURBINE = new FactoryType("STEAMTURBINE", 15, 21, false, TileEntitySteamTurbine.class, "factory_steamturbine");
    public static final /* enum */ FactoryType SOLARBOILER = new FactoryType("SOLARBOILER", 16, 22, false, TileEntitySolarBoiler.class, "factory_solarfurnace");
    public static final /* enum */ FactoryType ROCKETENGINE = new FactoryType("ROCKETENGINE", 17, 23, false, TileEntityRocketEngine.class, "factory_rocketengine");
    public static final /* enum */ FactoryType EXTENDED = new FactoryType("EXTENDED", 18, 24, false, TileEntityExtension.class, "factory_ext");
    public static final /* enum */ FactoryType CERAMIC = new FactoryType("CERAMIC", 19, 25, false, TileEntityGreenware.class, "factory_ceramic");
    public static final /* enum */ FactoryType LEYDENJAR = new FactoryType("LEYDENJAR", 20, 26, false, TileEntityLeydenJar.class, "factory_leyjar");
    public static final /* enum */ FactoryType SERVORAIL = new FactoryType("SERVORAIL", 21, 27, false, TileEntityServoRail.class, "factory_rail");
    public static final /* enum */ FactoryType PARASIEVE = new FactoryType("PARASIEVE", 22, 28, true, TileEntityParaSieve.class, "factory_sieve");
    public static final /* enum */ FactoryType POCKETCRAFTGUI = new FactoryType("POCKETCRAFTGUI", 23, 101, true);
    public final int md;
    public final int gui;
    public final boolean hasGui;
    private final Class clazz;
    public final String te_id;
    private TileEntityCommon representative;
    private boolean can_represent = true;
    private boolean disabled = false;
    private static final /* synthetic */ FactoryType[] $VALUES;

    public static FactoryType[] values() {
        return (FactoryType[])$VALUES.clone();
    }

    public static FactoryType valueOf(String name2) {
        return Enum.valueOf(FactoryType.class, name2);
    }

    public TileEntityCommon getRepresentative() {
        if (!this.can_represent) {
            return null;
        }
        if (this.representative == null) {
            if (this.can_represent) {
                this.can_represent = TileEntityCommon.class.isAssignableFrom(this.clazz);
                if (!this.can_represent) {
                    return null;
                }
            }
            try {
                this.representative = (TileEntityCommon)this.clazz.newInstance();
            }
            catch (Throwable e) {
                throw new IllegalArgumentException(e);
            }
            MinecraftForge.EVENT_BUS.register((Object)this.representative);
        }
        return this.representative;
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private FactoryType(int metadata, Class use_gui, String gui_id) {
        void name2;
        void clazz;
        void var2_-1;
        void var1_-1;
        this.md = metadata;
        this.gui = use_gui != false ? (int)gui_id : -1;
        this.hasGui = use_gui;
        assert (mapper.mapping[this.md] == null);
        mapper.mapping[this.md] = this;
        this.clazz = clazz;
        this.te_id = name2;
        Object rep = null;
        this.representative = rep;
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private FactoryType(Class md, String use_gui) {
        this((String)var1_-1, (int)var2_-1, (int)md, (boolean)use_gui, (int)md, (Class)clazz, (String)name2);
        void name2;
        void clazz;
        void var2_-1;
        void var1_-1;
    }

    /*
     * WARNING - void declaration
     */
    private FactoryType() {
        this((String)var1_-1, (int)var2_-1, (int)md, (boolean)use_gui, (int)md, null, null);
        void use_gui;
        void md;
        void var2_-1;
        void var1_-1;
    }

    void disable() {
        this.disabled = true;
    }

    TileEntityCommon makeTileEntity() {
        if (this.clazz == null) {
            Core.logWarning("Note: " + (Object)((Object)this) + " is a FactoryType with no associated TE", new Object[0]);
            return null;
        }
        try {
            return (TileEntityCommon)this.clazz.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public boolean isInstance(TileEntityFactorization ent) {
        if (ent == null) {
            return false;
        }
        return ent.getFactoryType() == this;
    }

    public boolean is(int md) {
        return md == this.md;
    }

    public static FactoryType fromMd(int md) {
        if (md < 0) {
            return null;
        }
        if (md >= mapper.mapping.length) {
            return null;
        }
        return mapper.mapping[md];
    }

    ItemStack itemStack() {
        if (this.disabled) {
            return null;
        }
        ItemStack ret = new ItemStack((Item)Core.registry.item_factorization, 1, this.md);
        return ret;
    }

    public static void registerTileEntities() {
        for (FactoryType ft : FactoryType.values()) {
            if (ft.clazz == null || ft.te_id == null) continue;
            GameRegistry.registerTileEntity((Class)ft.clazz, (String)ft.te_id);
        }
    }

    public boolean connectRedstone() {
        return this == ROUTER || this == MAKER || this == STAMPER || this == PACKAGER;
    }

    static {
        $VALUES = new FactoryType[]{ROUTER, MAKER, STAMPER, BARREL, LAMP, PACKAGER, WRATHFIRE, SLAGFURNACE, BATTERY, LEADWIRE, HEATER, MIRROR, GRINDER, MIXER, CRYSTALLIZER, STEAMTURBINE, SOLARBOILER, ROCKETENGINE, EXTENDED, CERAMIC, LEYDENJAR, SERVORAIL, PARASIEVE, POCKETCRAFTGUI};
    }

    static class mapper {
        static FactoryType[] mapping = new FactoryType[128];

        mapper() {
        }
    }
}

