/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.common.ContainerPocket;
import factorization.common.Core;
import factorization.common.FactorizationTextureLoader;
import factorization.common.FactoryType;
import factorization.common.ItemIcons;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemPocketTable
extends Item {
    public static int NEI_status = -1;

    public ItemPocketTable(int id) {
        super(id);
        this.func_77625_d(1);
        Core.tab(this, Core.TabType.TOOLS);
        this.func_77664_n();
        this.func_77655_b("factorization:tool/pocket_crafting_table");
    }

    public void func_94581_a(IconRegister reg) {
        super.func_94581_a(reg);
        FactorizationTextureLoader.register(reg, ItemIcons.class);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        return this.activateTable(stack, world, player);
    }

    ItemStack activateTable(ItemStack stack, World world, EntityPlayer player) {
        ItemStack save = player.field_71071_by.func_70445_o();
        if (save != null) {
            player.field_71071_by.func_70437_b(null);
        }
        if (!world.field_72995_K) {
            player.openGui((Object)Core.instance, FactoryType.POCKETCRAFTGUI.gui, null, 0, 0, 0);
            if (save != null) {
                player.field_71071_by.func_70437_b(save);
                Core.proxy.updateHeldItem(player);
            }
        }
        return stack;
    }

    public ItemStack findPocket(EntityPlayer player) {
        InventoryPlayer inv = player.field_71071_by;
        int need_to_move = -1;
        int a_free_space = -1;
        for (int i = 0; i < inv.field_70462_a.length; ++i) {
            boolean in_crafting_area = i % 9 >= 6 && i > 9;
            ItemStack is = inv.field_70462_a[i];
            if (is == null) {
                if (in_crafting_area || a_free_space != -1 && a_free_space >= 9) continue;
                a_free_space = i;
                continue;
            }
            if (is.func_77973_b() != this) continue;
            if (in_crafting_area) {
                need_to_move = i;
                continue;
            }
            return is;
        }
        ItemStack mouse_item = player.field_71071_by.func_70445_o();
        if (mouse_item != null && mouse_item.func_77973_b() == this && player.field_71070_bA instanceof ContainerPocket) {
            return mouse_item;
        }
        if (need_to_move != -1 && a_free_space != -1) {
            ItemStack pocket = inv.func_70301_a(need_to_move);
            inv.func_70299_a(need_to_move, null);
            inv.func_70299_a(a_free_space, pocket);
            return pocket;
        }
        return null;
    }

    public boolean tryOpen(EntityPlayer player) {
        ItemStack is = this.findPocket(player);
        if (is == null) {
            return false;
        }
        this.activateTable(is, player.field_70170_p, player);
        return true;
    }

    public void func_77624_a(ItemStack is, EntityPlayer player, List infoList, boolean verbose) {
        if (player.field_70170_p.field_72995_K) {
            ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
            String key = Core.proxy.getPocketCraftingTableKey();
            if (key != null && key != "") {
                String enabled_or_installed;
                String string = enabled_or_installed = NEI_status == 1 ? "enabled" : "installed";
                if (NEI_status != -1) {
                    infoList.add("Press " + key + " to activate from anywhere.");
                } else {
                    infoList.add("Press " + key + " to activate.");
                }
            }
        }
        Core.brand(is, infoList);
    }
}

