/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.Coord;
import factorization.api.Quaternion;
import factorization.common.BlockRenderHelper;
import factorization.common.Core;
import factorization.common.FactorizationUtil;
import factorization.common.FactoryType;
import factorization.common.ItemIcons;
import factorization.common.TileEntityGreenware;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class ItemSculptingTool
extends Item {
    protected ItemSculptingTool(int id) {
        super(id);
        this.setNoRepair();
        this.func_77656_e(0);
        this.func_77625_d(4);
        this.func_77655_b("factorization:sculptTool");
        Core.tab(this, Core.TabType.ART);
        this.func_77664_n();
    }

    static void addModeChangeRecipes() {
        int length = ToolMode.values().length;
        ToolMode[] mode = ToolMode.values();
        for (int i = 0; i < length; ++i) {
            int j;
            for (j = i + 1; j < length && !mode[j].craftable; ++j) {
            }
            if (j == length) {
                j = 0;
            }
            Core.registry.shapelessRecipe(ItemSculptingTool.fromMode(mode[j]), ItemSculptingTool.fromMode(mode[i]));
        }
    }

    public void func_94581_a(IconRegister reg) {
    }

    ToolMode getMode(int damage) {
        if (damage < 0) {
            return ToolMode.MOVER;
        }
        if (damage >= ToolMode.values().length) {
            return ToolMode.MOVER;
        }
        return ToolMode.values()[damage];
    }

    static ItemStack fromMode(ToolMode mode) {
        return new ItemStack((Item)Core.registry.sculpt_tool, 1, mode.ordinal());
    }

    public Icon func_77617_a(int damage) {
        switch (this.getMode(damage)) {
            default: {
                return ItemIcons.move;
            }
            case RESETTER: {
                return ItemIcons.reset;
            }
            case ROTATE_LOCAL: {
                return ItemIcons.rotate_local;
            }
            case ROTATE_GLOBAL: {
                return ItemIcons.rotate_global;
            }
            case STRETCHER: {
                return ItemIcons.stretch;
            }
            case MOLD: 
        }
        return ItemIcons.mold;
    }

    public void func_77624_a(ItemStack is, EntityPlayer player, List list, boolean verbose) {
        ToolMode mode = this.getMode(is.func_77960_j());
        list.add(mode.name);
        ToolMode nextMode = mode.next;
        while (nextMode != mode) {
            list.add("(" + nextMode.name + ")");
            nextMode = nextMode.next;
        }
        Core.brand(is, list);
    }

    void changeMode(ItemStack is) {
        ToolMode mode = this.getMode(is.func_77960_j());
        is.func_77964_b(mode.next.ordinal());
    }

    public boolean func_77648_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7, float par8, float par9, float par10) {
        return this.tryPlaceIntoWorld(par1ItemStack, par2EntityPlayer, par3World, par4, par5, par6, par7, par8, par9, par10);
    }

    public static MovingObjectPosition doRayTrace(EntityPlayer player) {
        return Core.registry.sculpt_tool.func_77621_a(player.field_70170_p, player, true);
    }

    public boolean tryPlaceIntoWorld(ItemStack is, EntityPlayer player, World w, int x, int y, int z, int side, float vx, float vy, float vz) {
        if (w.field_72995_K) {
            return true;
        }
        Coord here = new Coord(w, x, y, z);
        TileEntityGreenware gw = (TileEntityGreenware)here.getTE(TileEntityGreenware.class);
        if (gw == null) {
            if (player.func_70093_af()) {
                this.changeMode(is);
                if (player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] == is) {
                    player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = is.func_77946_l();
                }
                return true;
            }
            return false;
        }
        TileEntityGreenware.ClayState state = gw.getState();
        ToolMode mode = this.getMode(is.func_77960_j());
        if (mode == ToolMode.MOLD) {
            int is_fired = state.compareTo(TileEntityGreenware.ClayState.BISQUED);
            if (is_fired < 0) {
                Core.notify(player, here, "Not fired", new String[0]);
                return true;
            }
            FactorizationUtil.FzInv inv = FactorizationUtil.openInventory((IInventory)player.field_71071_by, 0);
            if (!player.field_71075_bZ.field_75098_d) {
                boolean hasSlab = false;
                int materialCount = 0;
                int neededClay = gw.parts.size();
                for (int i = 0; i < inv.size(); ++i) {
                    ItemStack it = inv.get(i);
                    if (it == null) continue;
                    if (it.func_77973_b() == Item.field_77757_aI) {
                        materialCount += it.field_77994_a;
                    }
                    if (it.field_77993_c != Block.field_72092_bO.field_71990_ca) continue;
                    hasSlab = true;
                }
                if (!hasSlab || materialCount < neededClay) {
                    Core.notify(player, here, "Need wood slab\nAnd %s clay", "" + neededClay);
                    return false;
                }
                inv.pull(FactorizationUtil.makeWildcard((Block)Block.field_72092_bO), 1, false);
                inv.pull(new ItemStack(Item.field_77757_aI), gw.parts.size(), false);
            }
            TileEntityGreenware rep = (TileEntityGreenware)FactoryType.CERAMIC.getRepresentative();
            rep.loadParts(gw.getItem().func_77978_p());
            rep.totalHeat = 0;
            rep.glazesApplied = false;
            rep.lastTouched = 0;
            ItemStack toDrop = rep.getItem();
            if (gw.customName != null) {
                toDrop.func_82834_c(gw.customName);
            }
            if (inv.push(toDrop) != null) {
                player.func_71021_b(toDrop);
            }
            Core.proxy.updatePlayerInventory(player);
            return true;
        }
        if (state != TileEntityGreenware.ClayState.WET) {
            if (w.field_72995_K) {
                return false;
            }
            switch (state) {
                case DRY: {
                    Core.notify(player, gw.getCoord(), "The clay is dry\nUse a %s.", Core.getTranslationKey(Item.field_77786_ax));
                    break;
                }
                case BISQUED: 
                case HIGHFIRED: {
                    Core.notify(player, gw.getCoord(), "This has been fired", new String[0]);
                    break;
                }
                default: {
                    Core.notify(player, gw.getCoord(), "This clay can not be reshaped.", new String[0]);
                }
            }
            return false;
        }
        if (w.field_72995_K) {
            return true;
        }
        BlockRenderHelper hit = Core.registry.serverTraceHelper;
        MovingObjectPosition hitPart = this.func_77621_a(w, player, true);
        if (hitPart == null) {
            return false;
        }
        if (hitPart.subHit == -1) {
            return true;
        }
        int strength = Math.max(1, is.field_77994_a);
        TileEntityGreenware.ClayLump selection = (TileEntityGreenware.ClayLump)gw.parts.get(hitPart.subHit);
        TileEntityGreenware.ClayLump test = selection.copy();
        boolean sneaking = player.func_70093_af();
        switch (mode) {
            case MOVER: {
                this.move(test, sneaking, side, strength);
                break;
            }
            case STRETCHER: {
                this.stretch(test, sneaking, side, strength);
                break;
            }
            case ROTATE_LOCAL: {
                this.rotate_local(test, sneaking, side, strength);
                break;
            }
            case ROTATE_GLOBAL: {
                this.rotate_global(test, sneaking, side, strength);
                break;
            }
            case RESETTER: {
                if (sneaking) {
                    Quaternion orig = test.quat;
                    test.asDefault();
                    test.quat = orig;
                    break;
                }
                test.quat = new Quaternion();
                break;
            }
            case MOLD: {
                Core.notify(player, here, "Not fired", new String[0]);
                return true;
            }
        }
        if (gw.isValidLump(test)) {
            gw.changeLump(hitPart.subHit, test);
        }
        return true;
    }

    void rotate_local(TileEntityGreenware.ClayLump cube, boolean reverse, int side, int strength) {
        float delta = (float)Math.toRadians(-11.25f * (float)strength);
        if (reverse) {
            delta *= -1.0f;
        }
        ForgeDirection direction = ForgeDirection.getOrientation((int)side);
        cube.quat.incrMultiply(Quaternion.getRotationQuaternionRadians(delta, direction.offsetX, direction.offsetY, direction.offsetZ));
    }

    void rotate_global(TileEntityGreenware.ClayLump cube, boolean reverse, int side, int strength) {
        float delta = (float)Math.toRadians(-11.25f * (float)strength);
        if (reverse) {
            delta *= -1.0f;
        }
        ForgeDirection direction = ForgeDirection.getOrientation((int)side);
        Quaternion global = Quaternion.getRotationQuaternionRadians(delta, direction.offsetX, direction.offsetY, direction.offsetZ);
        global.incrMultiply(cube.quat);
        cube.quat = global;
    }

    void move(TileEntityGreenware.ClayLump cube, boolean reverse, int side, int strength) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        this.stretch(cube, reverse, dir.ordinal(), strength);
        this.stretch(cube, !reverse, dir.getOpposite().ordinal(), strength);
    }

    void stretch(TileEntityGreenware.ClayLump cube, boolean reverse, int side, int strength) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        int delta = reverse ? -strength : strength;
        switch (dir) {
            case SOUTH: {
                cube.maxZ = (byte)(cube.maxZ + delta);
                break;
            }
            case NORTH: {
                cube.minZ = (byte)(cube.minZ - delta);
                break;
            }
            case EAST: {
                cube.maxX = (byte)(cube.maxX + delta);
                break;
            }
            case WEST: {
                cube.minX = (byte)(cube.minX - delta);
                break;
            }
            case UP: {
                cube.maxY = (byte)(cube.maxY + delta);
                break;
            }
            case DOWN: {
                cube.minY = (byte)(cube.minY - delta);
            }
        }
    }

    static enum ToolMode {
        MOVER("move", true),
        STRETCHER("stretch", false),
        ROTATE_GLOBAL("rotate_global", true),
        ROTATE_LOCAL("rotate_local", false),
        RESETTER("reset", true),
        MOLD("mold", true);

        String name;
        boolean craftable;
        ToolMode next;

        /*
         * WARNING - void declaration
         */
        private ToolMode() {
            void craftable;
            void english;
            this.name = english;
            this.craftable = craftable;
            this.next = this;
        }

        static void group(ToolMode ... group) {
            ToolMode prev = group[group.length - 1];
            for (ToolMode me : group) {
                me.next = prev;
                prev = me;
            }
        }

        static {
            ToolMode.group(MOVER, STRETCHER);
            ToolMode.group(RESETTER);
            ToolMode.group(ROTATE_GLOBAL, ROTATE_LOCAL);
            ToolMode.group(MOLD);
        }
    }
}

