/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.common.Core;
import factorization.common.Sound;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemWandOfCooling
extends Item {
    static int[] changeArray = new int[Block.field_71973_m.length];
    final int max_change = 70;
    final int radius_tries = 50;
    final int max_radius = 3;
    int change_count = 0;
    int noise_count = 0;

    public ItemWandOfCooling(int par1) {
        super(par1);
        this.func_77625_d(1);
        this.func_77664_n();
        this.func_77656_e(13312);
        Arrays.fill(changeArray, -1);
        this.remove((Block)Block.field_72067_ar);
        Core.tab(this, Core.TabType.TOOLS);
        this.func_77655_b("factorization:tool/wand_of_cooling");
    }

    public void cool(Block src, Block dest) {
        ItemWandOfCooling.changeArray[src.field_71990_ca] = dest.field_71990_ca;
    }

    public void remove(Block src) {
        ItemWandOfCooling.changeArray[src.field_71990_ca] = 0;
    }

    int getRadius(ItemStack is) {
        return 4;
    }

    void setBlock(World world, int x, int y, int z, int id) {
        world.func_72832_d(x, y, z, id, 0, 3);
        this.soundCool(world, x, y, z);
    }

    int makeSafe(World world, int x, int y, int z) {
        int id = world.func_72798_a(x, y, z);
        if (id == Block.field_71944_C.field_71990_ca || id == Block.field_71938_D.field_71990_ca) {
            int md = world.func_72805_g(x, y, z);
            if (md == 0) {
                this.setBlock(world, x, y, z, 0);
                return 41;
            }
            this.setBlock(world, x, y, z, 0);
            return 10;
        }
        if (id == Block.field_72067_ar.field_71990_ca) {
            this.setBlock(world, x, y, z, 0);
            return 10;
        }
        return 0;
    }

    void safetyFirst(Entity player, int d) {
        boolean hit = false;
        int x = (int)(player.field_70165_t - (double)d);
        while ((double)x <= player.field_70165_t + (double)d) {
            int y = (int)(player.field_70163_u - (double)d);
            while ((double)y <= player.field_70163_u + (double)d) {
                int z = (int)(player.field_70161_v - (double)d);
                while ((double)z <= player.field_70161_v + (double)d) {
                    this.change_count -= this.makeSafe(player.field_70170_p, x, y, z);
                    if (this.change_count <= 0) {
                        return;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        if (player.func_70027_ad()) {
            this.change_count -= 20;
            player.func_70066_B();
        }
    }

    int transformBlock(World world, int x, int y, int z) {
        int id = world.func_72798_a(x, y, z);
        int md = world.func_72805_g(x, y, z);
        if (id > 255) {
            return 0;
        }
        if (id == 0) {
            return 0;
        }
        int newid = changeArray[id];
        boolean water = id == Block.field_71942_A.field_71990_ca || id == Block.field_71943_B.field_71990_ca;
        boolean lava = id == Block.field_71944_C.field_71990_ca || id == Block.field_71938_D.field_71990_ca;
        int cost = 10;
        if (water || lava) {
            if (md == 0) {
                if (water) {
                    newid = Block.field_72036_aT.field_71990_ca;
                }
                if (lava) {
                    newid = Block.field_72089_ap.field_71990_ca;
                    cost = 15;
                }
            } else {
                newid = 0;
                cost = 1;
            }
        }
        if (id == Core.registry.lightair_block.field_71990_ca && md == 1) {
            newid = 0;
            cost = 1;
            world.func_72932_q(x, y, z);
        }
        if (newid == -1) {
            return 0;
        }
        this.setBlock(world, x, y, z, newid);
        return cost;
    }

    void changeRadius(World world, int x, int y, int z, int r) {
        if (this.change_count <= 0) {
            return;
        }
        int tries = 50;
        while (this.change_count >= 0) {
            int dz;
            int dy;
            int dx = (int)(field_77697_d.nextGaussian() * (double)r);
            int delta = this.transformBlock(world, x + dx, y + (dy = (int)(field_77697_d.nextGaussian() * (double)r)), z + (dz = (int)(field_77697_d.nextGaussian() * (double)r)));
            if (delta != 0) {
                this.change_count -= delta;
            } else {
                --tries;
            }
            if (tries > 0) continue;
        }
    }

    void changeArea(World world, int x, int y, int z, int r) {
        for (int dx = -r; dx <= r; ++dx) {
            for (int dy = -r; dy <= r; ++dy) {
                for (int dz = -r; dz <= r; ++dz) {
                    if (this.change_count < 0) {
                        return;
                    }
                    this.change_count -= this.transformBlock(world, x + dx, y + dy, z + dz);
                }
            }
        }
    }

    void reset() {
        this.change_count = 70;
        this.noise_count = 0;
    }

    void soundCool(World world, int x, int y, int z) {
        ++this.noise_count;
        if (this.noise_count > 1) {
            return;
        }
        Sound.wandCool.playAt(world, x, y, z);
    }

    public boolean func_77648_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7, float par8, float par9, float par10) {
        return this.tryPlaceIntoWorld(par1ItemStack, par2EntityPlayer, par3World, par4, par5, par6, par7, par8, par9, par10);
    }

    public boolean tryPlaceIntoWorld(ItemStack is, EntityPlayer player, World w, int x, int y, int z, int side, float vecx, float vecy, float vecz) {
        if (w.field_72995_K) {
            return true;
        }
        this.reset();
        this.safetyFirst((Entity)player, 0);
        this.safetyFirst((Entity)player, 1);
        this.changeArea(w, x, y, z, 1);
        int real_max_radius = 3;
        if (player.func_70093_af()) {
            ++real_max_radius;
        }
        for (int r = 2; r < real_max_radius; ++r) {
            for (int i = 0; i < 3; ++i) {
                this.changeRadius(w, x, y, z, r);
            }
        }
        int damage = Math.min(70 - this.change_count, 1);
        if (damage > 0) {
            is.func_77972_a(damage, (EntityLiving)player);
        }
        return true;
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer player) {
        this.tryPlaceIntoWorld(is, player, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, 0, 0.0f, 0.0f, 0.0f);
        return is;
    }

    public void func_77624_a(ItemStack is, EntityPlayer player, List infoList, boolean verbose) {
        Core.brand(is, infoList);
    }
}

