/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.api.Quaternion;
import factorization.common.BlockClass;
import factorization.common.BlockIcons;
import factorization.common.BlockRenderHelper;
import factorization.common.Core;
import factorization.common.FactorizationUtil;
import factorization.common.FactoryType;
import factorization.common.ItemSculptingTool;
import factorization.common.ResourceType;
import factorization.common.TileEntityCommon;
import factorization.common.TileEntityExtension;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3Pool;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.event.ForgeSubscribe;
import org.lwjgl.opengl.GL11;

public class TileEntityGreenware
extends TileEntityCommon {
    public static int MAX_PARTS = 32;
    public ArrayList parts = new ArrayList();
    public int lastTouched = 0;
    int totalHeat = 0;
    boolean glazesApplied = false;
    private boolean partsValidated = false;
    public static int dryTime = 2400;
    public static int bisqueHeat = 1000;
    public static int highfireHeat = bisqueHeat * 20;
    public static final int clayIconStart = 192;
    public boolean shouldRenderTesr = false;
    private ClayState lastState = null;
    private static final Vec3 zeroVec = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.CERAMIC;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Ceramic;
    }

    public ClayState getState() {
        if (this.totalHeat > highfireHeat) {
            return ClayState.HIGHFIRED;
        }
        if (this.totalHeat > bisqueHeat) {
            if (this.glazesApplied) {
                return ClayState.UNFIRED_GLAZED;
            }
            return ClayState.BISQUED;
        }
        if (this.lastTouched > dryTime) {
            return ClayState.DRY;
        }
        return ClayState.WET;
    }

    public Icon getIcon(ClayLump lump, int side) {
        switch (this.getState()) {
            case WET: {
                return Block.field_72041_aW.func_71851_a(side);
            }
            case DRY: {
                return BlockIcons.ceramics$dry;
            }
            case BISQUED: 
            case UNFIRED_GLAZED: {
                return BlockIcons.error;
            }
            case HIGHFIRED: {
                Item it = Item.field_77698_e[lump.icon_id];
                if (it == null) {
                    return BlockIcons.error;
                }
                return it.func_77617_a((int)lump.icon_md);
            }
        }
        return BlockIcons.error;
    }

    public void touch() {
        if (this.getState() == ClayState.WET) {
            this.lastTouched = 0;
        }
    }

    public boolean renderEfficient() {
        return this.getState() != ClayState.WET;
    }

    public boolean canEdit() {
        return this.getState() == ClayState.WET;
    }

    void initialize() {
        this.parts = new ArrayList();
        this.parts.add(new ClayLump().asDefault());
        this.touch();
    }

    void writeParts(NBTTagCompound tag) {
        NBTTagList l = new NBTTagList();
        for (ClayLump lump : this.parts) {
            NBTTagCompound rc_tag = new NBTTagCompound();
            lump.write(rc_tag);
            l.func_74742_a((NBTBase)rc_tag);
        }
        tag.func_74782_a("parts", (NBTBase)l);
        tag.func_74768_a("touch", this.lastTouched);
        tag.func_74768_a("heat", this.totalHeat);
        tag.func_74757_a("glazed", this.glazesApplied);
    }

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        this.writeParts(tag);
        if (this.parts.size() == 0) {
            this.getCoord().setId(0);
        }
    }

    public void loadParts(NBTTagCompound tag) {
        if (tag == null) {
            this.initialize();
            return;
        }
        NBTTagList partList = tag.func_74761_m("parts");
        if (partList == null) {
            this.initialize();
            return;
        }
        int tagCount = partList.func_74745_c();
        this.parts = new ArrayList(tagCount);
        for (int i = 0; i < tagCount; ++i) {
            NBTTagCompound rc_tag = (NBTTagCompound)partList.func_74743_b(i);
            this.parts.add(new ClayLump().read(rc_tag));
        }
        this.lastTouched = tag.func_74762_e("touch");
        this.totalHeat = tag.func_74762_e("heat");
        this.glazesApplied = tag.func_74767_n("glazed");
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.loadParts(tag);
    }

    @Override
    public Packet getAuxillaryInfoPacket() {
        ArrayList<Integer> args = new ArrayList<Integer>(2 + this.parts.size() * 9);
        args.add(130);
        args.add(this.getState().ordinal());
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        for (ClayLump lump : this.parts) {
            lump.write(args);
        }
        return this.getDescriptionPacketWith(args.toArray());
    }

    @Override
    void onPlacedBy(EntityPlayer player, ItemStack is, int side) {
        super.onPlacedBy(player, is, side);
        this.loadParts(is.func_77978_p());
    }

    ItemStack getItem() {
        ItemStack ret = Core.registry.greenware_item.func_77946_l();
        NBTTagCompound tag = new NBTTagCompound();
        this.writeParts(tag);
        ret.func_77982_d(tag);
        if (this.customName != null) {
            ret.func_82834_c(this.customName);
        }
        return ret;
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        if (!this.partsValidated) {
            this.partsValidated = true;
            Iterator it = this.parts.iterator();
            while (it.hasNext()) {
                ClayLump lump = (ClayLump)it.next();
                if (this.isValidLump(lump)) continue;
                if (this.parts.size() == 1) {
                    lump.asDefault();
                    continue;
                }
                it.remove();
                FactorizationUtil.spawnItemStack(this.getCoord(), new ItemStack(Item.field_77757_aI));
            }
        }
        switch (this.getState()) {
            case WET: {
                if (!this.field_70331_k.func_72896_J()) {
                    ++this.lastTouched;
                }
                if (this.totalHeat <= 0) break;
                --this.totalHeat;
                ++this.lastTouched;
            }
        }
        if (this.getState() != this.lastState) {
            this.lastState = this.getState();
            this.broadcastMessage(null, 135, this.lastState.ordinal());
        }
    }

    @Override
    public boolean activate(EntityPlayer player, ForgeDirection side) {
        ItemStack held;
        ClayState state = this.getState();
        if (state == ClayState.WET) {
            this.touch();
        }
        if ((held = player.func_71045_bC()) == null) {
            return false;
        }
        int heldId = held.func_77973_b().field_77779_bT;
        boolean creative = player.field_71075_bZ.field_75098_d;
        if (heldId == Item.field_77786_ax.field_77779_bT && state == ClayState.DRY) {
            this.lastTouched = 0;
            if (creative) {
                return true;
            }
            int ci = player.field_71071_by.field_70461_c;
            player.field_71071_by.field_70462_a[ci] = new ItemStack(Item.field_77788_aw);
            return true;
        }
        if (heldId == Block.field_72101_ab.field_71990_ca) {
            this.lastTouched = dryTime + 1;
            return true;
        }
        if (held.func_77973_b() != Item.field_77757_aI || held.field_77994_a == 0) {
            return false;
        }
        if (state != ClayState.WET) {
            Core.notify(player, this.getCoord(), "Not wet", new String[0]);
            return false;
        }
        if (!creative) {
            --held.field_77994_a;
        }
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        if (this.parts.size() >= MAX_PARTS) {
            Core.notify(player, this.getCoord(), "Too complex", new String[0]);
            ++held.field_77994_a;
            return false;
        }
        ClayLump toAdd = this.addLump();
        MovingObjectPosition hit = ItemSculptingTool.doRayTrace(player);
        if (hit == null || hit.subHit == -1) {
            return true;
        }
        ClayLump against = (ClayLump)this.parts.get(hit.subHit);
        ClayLump extrusion = this.extrudeLump(against, hit.field_72310_e);
        if (this.isValidLump(extrusion)) {
            this.changeLump(this.parts.size() - 1, extrusion);
        }
        return true;
    }

    ClayLump addLump() {
        ClayLump ret = new ClayLump().asDefault();
        this.parts.add(ret);
        if (!this.field_70331_k.field_72995_K) {
            this.broadcastMessage(null, 132, new Object[0]);
            this.touch();
        }
        return ret;
    }

    void removeLump(int id) {
        if (id < 0 || id >= this.parts.size()) {
            return;
        }
        this.parts.remove(id);
        if (!this.field_70331_k.field_72995_K) {
            this.broadcastMessage(null, 134, id);
            this.touch();
        }
    }

    ClayLump extrudeLump(ClayLump against, int side) {
        ClayLump lump = against.copy();
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        BlockRenderHelper b = Core.registry.serverTraceHelper;
        against.toBlockBounds(b);
        int wX = lump.maxX - lump.minX;
        int wY = lump.maxY - lump.minY;
        int wZ = lump.maxZ - lump.minZ;
        lump.maxX = (byte)(lump.maxX + wX * dir.offsetX);
        lump.maxY = (byte)(lump.maxY + wY * dir.offsetY);
        lump.maxZ = (byte)(lump.maxZ + wZ * dir.offsetZ);
        lump.minX = (byte)(lump.minX + wX * dir.offsetX);
        lump.minY = (byte)(lump.minY + wY * dir.offsetY);
        lump.minZ = (byte)(lump.minZ + wZ * dir.offsetZ);
        return lump;
    }

    public boolean isValidLump(ClayLump lump) {
        if (!Core.cheat) {
            int wX = lump.maxX - lump.minX;
            int wY = lump.maxY - lump.minY;
            int wZ = lump.maxZ - lump.minZ;
            int area = wX * wY * wZ;
            int max_area = 4096;
            if (!Core.stretchy_clay) {
                max_area /= 4;
            }
            if (area <= 0 || area > max_area) {
                return false;
            }
        }
        int B = 48;
        if (lump.minX < 0) {
            return false;
        }
        if (lump.minY < 0) {
            return false;
        }
        if (lump.minZ < 0) {
            return false;
        }
        if (lump.maxX > 48) {
            return false;
        }
        if (lump.maxY > 48) {
            return false;
        }
        if (lump.maxZ > 48) {
            return false;
        }
        for (Coord c : lump.getOccupiedBlocks(this.getCoord())) {
            TileEntityExtension tex;
            if (c.isAir() || c.isReplacable()) {
                c.setId((Block)Core.registry.factory_block);
                TileEntityExtension tex2 = new TileEntityExtension(this);
                c.setTE(tex2);
                tex2.getBlockClass().enforce(c);
                continue;
            }
            TileEntity te = c.getTE();
            if (te == this || te instanceof TileEntityExtension && (tex = (TileEntityExtension)te).getParent() == this) continue;
            Core.notify(null, c, "!", new String[0]);
        }
        return true;
    }

    @Override
    protected void onRemove() {
        super.onRemove();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    Coord c = this.getCoord().add(x, y, z);
                    TileEntityExtension tex = (TileEntityExtension)c.getTE(TileEntityExtension.class);
                    if (tex == null || tex.getParent() != this) continue;
                    c.setId(0);
                }
            }
        }
    }

    private void updateLump(int id, ClayLump lump) {
        if (id < 0 || id >= this.parts.size()) {
            return;
        }
        ClayLump old = (ClayLump)this.parts.get(id);
        if (old.equals(lump)) {
            return;
        }
        this.parts.set(id, lump);
        this.touch();
        if (this.field_70331_k.field_72995_K) {
            return;
        }
    }

    private void shareLump(int id, ClayLump selection) {
        ArrayList<Integer> toSend = new ArrayList<Integer>();
        toSend.add(id);
        selection.write(toSend);
        this.broadcastMessage(null, 133, toSend.toArray());
    }

    void changeLump(int id, ClayLump newValue) {
        this.updateLump(id, newValue);
        this.shareLump(id, newValue);
    }

    private float getFloat(DataInput input) throws IOException {
        int r = (int)(input.readFloat() * 2.0f);
        return (float)r / 2.0f;
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInputStream input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        switch (messageType) {
            case 130: {
                this.readStateChange(input);
                this.parts.clear();
                ArrayList args = new ArrayList();
                try {
                    while (true) {
                        this.parts.add(new ClayLump().read(input));
                    }
                }
                catch (IOException e) {
                    this.shouldRenderTesr = this.getState() == ClayState.WET;
                    break;
                }
            }
            case 133: {
                this.updateLump(input.readInt(), new ClayLump().read(input));
                break;
            }
            case 132: {
                this.addLump();
                break;
            }
            case 134: {
                this.removeLump(input.readInt());
                break;
            }
            case 135: {
                this.readStateChange(input);
                break;
            }
            default: {
                return false;
            }
        }
        if (this.renderEfficient()) {
            this.getCoord().redraw();
        }
        return true;
    }

    private void readStateChange(DataInput input) throws IOException {
        switch (ClayState.values()[input.readInt()]) {
            case WET: {
                this.lastTouched = 0;
                break;
            }
            case DRY: {
                this.lastTouched = dryTime + 10;
                break;
            }
            case BISQUED: {
                this.totalHeat = bisqueHeat + 1;
                break;
            }
            case UNFIRED_GLAZED: {
                this.totalHeat = bisqueHeat + 2;
                this.glazesApplied = true;
                break;
            }
            case HIGHFIRED: {
                this.totalHeat = highfireHeat + 1;
            }
        }
        this.getCoord().redraw();
    }

    @Override
    boolean removeBlockByPlayer(EntityPlayer player) {
        boolean shouldDestroy;
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        MovingObjectPosition hit = ItemSculptingTool.doRayTrace(player);
        if (hit == null || hit.subHit == -1 || this.parts.size() < 1) {
            return super.removeBlockByPlayer(player);
        }
        Coord here = this.getCoord();
        ClayState state = this.getState();
        boolean bl = shouldDestroy = player.func_70093_af() || this.parts.size() == 1;
        if (player.field_71075_bZ.field_75098_d) {
            if (shouldDestroy) {
                return super.removeBlockByPlayer(player);
            }
            this.removeLump(hit.subHit);
            return true;
        }
        if (shouldDestroy |= state != ClayState.WET) {
            FactorizationUtil.spawnItemStack(here, this.getItem());
            here.setId(0);
        } else {
            this.removeLump(hit.subHit);
            FactorizationUtil.spawnItemStack(here, new ItemStack(Item.field_77757_aI));
        }
        return false;
    }

    @Override
    public MovingObjectPosition collisionRayTrace(Vec3 startVec, Vec3 endVec) {
        BlockRenderHelper block2 = FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT ? Core.registry.clientTraceHelper : Core.registry.serverTraceHelper;
        double dx = startVec.field_72450_a - endVec.field_72450_a;
        double dy = startVec.field_72448_b - endVec.field_72448_b;
        double dz = startVec.field_72449_c - endVec.field_72449_c;
        double scale = 5.2;
        startVec.field_72450_a += dx * scale;
        startVec.field_72448_b += dy * scale;
        startVec.field_72449_c += dz * scale;
        MovingObjectPosition shortest = null;
        for (int i = 0; i < this.parts.size(); ++i) {
            ClayLump lump = (ClayLump)this.parts.get(i);
            lump.toRotatedBlockBounds(block2);
            block2.beginNoIcons();
            block2.rotateMiddle(lump.quat);
            block2.setBlockBoundsBasedOnRotation();
            MovingObjectPosition mop = block2.func_71878_a(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, startVec, endVec);
            Vec3Pool vp = this.field_70331_k.func_82732_R();
            if (mop == null) continue;
            mop.subHit = i;
            if (shortest == null) {
                shortest = mop;
                continue;
            }
            Vec3 s = shortest.field_72307_f;
            Vec3 m = mop.field_72307_f;
            s = vp.func_72345_a(s.field_72450_a, s.field_72448_b, s.field_72449_c);
            m = vp.func_72345_a(m.field_72450_a, m.field_72448_b, m.field_72449_c);
            this.offsetVector(startVec, s);
            this.offsetVector(startVec, m);
            if (!(m.func_72433_c() < s.func_72433_c())) continue;
            shortest = mop;
        }
        return shortest;
    }

    private void offsetVector(Vec3 player, Vec3 v) {
        v.field_72450_a -= player.field_72450_a;
        v.field_72448_b -= player.field_72448_b;
        v.field_72449_c -= player.field_72449_c;
    }

    @ForgeSubscribe
    @SideOnly(value=Side.CLIENT)
    public void renderCeramicsSelection(DrawBlockHighlightEvent event) {
        if (event.subID == -1) {
            return;
        }
        Coord c = new Coord(event.player.field_70170_p, event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d);
        TileEntityGreenware clay = (TileEntityGreenware)c.getTE(TileEntityGreenware.class);
        if (clay == null) {
            return;
        }
        event.setCanceled(true);
        ClayLump lump = (ClayLump)clay.parts.get(event.target.subHit);
        BlockRenderHelper block2 = BlockRenderHelper.instance;
        lump.toBlockBounds(block2);
        EntityPlayer player = event.player;
        double partial = event.partialTicks;
        double widen = 0.002;
        double oX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * partial;
        double oY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * partial;
        double oZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * partial;
        AxisAlignedBB bb = block2.func_71911_a_(c.w, c.x, c.y, c.z).func_72314_b(widen, widen, widen).func_72325_c(-oX, -oY, -oZ);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3553);
        GL11.glDepthMask((boolean)false);
        float r = 255.0f;
        GL11.glLineWidth((float)2.0f);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
        TileEntityGreenware.drawOutlinedBoundingBox(bb);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    private static void drawOutlinedBoundingBox(AxisAlignedBB aabb) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78371_b(3);
        tessellator.func_78377_a(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c);
        tessellator.func_78377_a(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c);
        tessellator.func_78377_a(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f);
        tessellator.func_78377_a(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f);
        tessellator.func_78377_a(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c);
        tessellator.func_78381_a();
        tessellator.func_78371_b(3);
        tessellator.func_78377_a(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c);
        tessellator.func_78377_a(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c);
        tessellator.func_78377_a(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
        tessellator.func_78377_a(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f);
        tessellator.func_78377_a(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c);
        tessellator.func_78381_a();
        tessellator.func_78371_b(1);
        tessellator.func_78377_a(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c);
        tessellator.func_78377_a(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c);
        tessellator.func_78377_a(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c);
        tessellator.func_78377_a(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c);
        tessellator.func_78377_a(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f);
        tessellator.func_78377_a(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
        tessellator.func_78377_a(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f);
        tessellator.func_78377_a(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f);
        tessellator.func_78381_a();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bb = AxisAlignedBB.func_72332_a().func_72299_a((double)(this.field_70329_l - 1), (double)(this.field_70330_m - 1), (double)(this.field_70327_n - 1), (double)(this.field_70329_l + 1), (double)(this.field_70330_m + 1), (double)(this.field_70327_n + 1));
        return bb;
    }

    @Override
    public void setBlockBounds(Block b) {
        super.setBlockBounds(b);
    }

    @Override
    public boolean addCollisionBoxesToList(Block ignore, AxisAlignedBB aabb, List list, Entity entity) {
        AxisAlignedBB a;
        boolean remote = entity != null && entity.field_70170_p != null ? entity.field_70170_p.field_72995_K : FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
        BlockRenderHelper block2 = remote ? Core.registry.clientTraceHelper : Core.registry.serverTraceHelper;
        block2.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        ClayState state = this.getState();
        if ((state == ClayState.WET || state == ClayState.DRY) && aabb.func_72326_a(a = block2.func_71872_e(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n))) {
            list.add(a);
        }
        for (ClayLump lump : this.parts) {
            lump.toRotatedBlockBounds(block2);
            AxisAlignedBB a2 = block2.func_71872_e(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            if (!aabb.func_72326_a(a2)) continue;
            list.add(a2);
        }
        return true;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return null;
    }

    @Override
    public boolean isBlockSolidOnSide(int side) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(ForgeDirection dir) {
        if (this.parts.size() == 0) {
            return Block.field_72041_aW.func_71851_a(0);
        }
        return this.getIcon((ClayLump)this.parts.get(0), dir.ordinal());
    }

    public static enum ClayState {
        WET("Wet Clay"),
        DRY("Bone-Dry Greenware"),
        BISQUED("Bisqued"),
        UNFIRED_GLAZED("Glazed Bisqueware"),
        HIGHFIRED("Highfire Glazed");

        public String english;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private ClayState() {
            void en;
            this.english = en;
        }
    }

    public static class ClayLump {
        public byte minX;
        public byte minY;
        public byte minZ;
        public byte maxX;
        public byte maxY;
        public byte maxZ;
        public short icon_id;
        public byte icon_md;
        public Quaternion quat;
        public int raw_color = -1;
        private static HashSet cache = new HashSet();
        private static DeltaCoord m1 = new DeltaCoord(-1, -1, -1);
        private static DeltaCoord d = new DeltaCoord();

        void write(ByteArrayDataOutput out) {
            out.writeByte((int)this.minX);
            out.writeByte((int)this.minY);
            out.writeByte((int)this.minZ);
            out.writeByte((int)this.maxX);
            out.writeByte((int)this.maxY);
            out.writeByte((int)this.maxZ);
            out.writeShort((int)this.icon_id);
            out.writeByte((int)this.icon_md);
            this.quat.write(out);
        }

        void write(NBTTagCompound tag) {
            tag.func_74774_a("lx", this.minX);
            tag.func_74774_a("ly", this.minY);
            tag.func_74774_a("lz", this.minZ);
            tag.func_74774_a("hx", this.maxX);
            tag.func_74774_a("hy", this.maxY);
            tag.func_74774_a("hz", this.maxZ);
            tag.func_74777_a("icon_id", this.icon_id);
            tag.func_74774_a("icon_md", this.icon_md);
            this.quat.writeToTag(tag, "r");
        }

        void write(ArrayList out) {
            out.add(this.minX);
            out.add(this.minY);
            out.add(this.minZ);
            out.add(this.maxX);
            out.add(this.maxY);
            out.add(this.maxZ);
            out.add(this.icon_id);
            out.add(this.icon_md);
            out.add(this.quat);
        }

        ClayLump read(DataInput in) throws IOException {
            this.minX = in.readByte();
            this.minY = in.readByte();
            this.minZ = in.readByte();
            this.maxX = in.readByte();
            this.maxY = in.readByte();
            this.maxZ = in.readByte();
            this.icon_id = in.readShort();
            this.icon_md = in.readByte();
            this.quat = Quaternion.read(in);
            return this;
        }

        ClayLump read(NBTTagCompound tag) {
            this.minX = tag.func_74771_c("lx");
            this.minY = tag.func_74771_c("ly");
            this.minZ = tag.func_74771_c("lz");
            this.maxX = tag.func_74771_c("hx");
            this.maxY = tag.func_74771_c("hy");
            this.maxZ = tag.func_74771_c("hz");
            this.icon_id = tag.func_74765_d("icon_id");
            this.icon_md = tag.func_74771_c("icon_md");
            this.quat = Quaternion.loadFromTag(tag, "r");
            return this;
        }

        void offset(int dx, int dy, int dz) {
            this.minX = (byte)(this.minX + dx);
            this.maxX = (byte)(this.maxX + dx);
            this.minY = (byte)(this.minY + dy);
            this.maxY = (byte)(this.maxY + dy);
            this.minZ = (byte)(this.minZ + dz);
            this.maxZ = (byte)(this.maxZ + dz);
        }

        ClayLump asDefault() {
            this.minZ = (byte)4;
            this.minX = (byte)4;
            this.minY = 0;
            this.maxZ = (byte)12;
            this.maxX = (byte)12;
            this.maxY = (byte)10;
            this.offset(16, 17, 16);
            this.icon_id = (short)Core.resource_id;
            this.icon_md = (byte)ResourceType.BISQUE.md;
            this.quat = new Quaternion();
            return this;
        }

        public void toBlockBounds(Block b) {
            b.func_71905_a((float)(this.minX - 16) / 16.0f, (float)(this.minY - 16) / 16.0f, (float)(this.minZ - 16) / 16.0f, (float)(this.maxX - 16) / 16.0f, (float)(this.maxY - 16) / 16.0f, (float)(this.maxZ - 16) / 16.0f);
        }

        public void toRotatedBlockBounds(BlockRenderHelper b) {
            this.toBlockBounds(b);
        }

        public ClayLump copy() {
            ClayLump ret = new ClayLump();
            ret.minX = this.minX;
            ret.minY = this.minY;
            ret.minZ = this.minZ;
            ret.maxX = this.maxX;
            ret.maxY = this.maxY;
            ret.maxZ = this.maxZ;
            ret.icon_id = this.icon_id;
            ret.icon_md = this.icon_md;
            ret.quat = new Quaternion(this.quat);
            return ret;
        }

        public Collection getOccupiedBlocks(Coord base) {
            cache.clear();
            DeltaCoord min = new DeltaCoord(this.minX / 16, this.minY / 16, this.minZ / 16);
            min = min.add(m1);
            DeltaCoord max = new DeltaCoord(this.maxX / 16, this.maxY / 16, this.maxZ / 16);
            max = max.add(m1);
            for (int dx = min.x; dx <= max.x; ++dx) {
                for (int dy = min.y; dy <= max.y; ++dy) {
                    for (int dz = min.z; dz <= max.z; ++dz) {
                        d.init(dx, dy, dz);
                        cache.add(base.add(d));
                    }
                }
            }
            return cache;
        }
    }
}

