/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Charge;
import factorization.api.IChargeConductor;
import factorization.common.BlockClass;
import factorization.common.BlockIcons;
import factorization.common.Core;
import factorization.common.FactorizationUtil;
import factorization.common.FactoryType;
import factorization.common.TileEntityFactorization;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityGrinder
extends TileEntityFactorization
implements IChargeConductor {
    ItemStack input;
    ItemStack output;
    Charge charge = new Charge(this);
    int progress = 0;
    float energy = 0.0f;
    int speed = 0;
    final int grind_time = 75;
    private static final int[] INPUT_s = new int[]{0};
    private static final int[] OUT_s = new int[]{1};
    int last_speed = 0;
    public int rotation;
    public static ArrayList recipes = new ArrayList();

    public int func_70302_i_() {
        return 2;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot == 0) {
            return this.input;
        }
        if (slot == 1) {
            return this.output;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack is) {
        if (slot == 0) {
            this.input = is;
        }
        if (slot == 1) {
            this.output = is;
        }
        this.func_70296_d();
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.readSlotsFromNBT(tag);
        this.charge.readFromNBT(tag);
        this.progress = tag.func_74762_e("progress");
        this.energy = tag.func_74760_g("fenergy");
        this.speed = tag.func_74762_e("speed");
    }

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        this.writeSlotsToNBT(tag);
        this.charge.writeToNBT(tag);
        tag.func_74768_a("progress", this.progress);
        tag.func_74776_a("fenergy", this.energy);
        tag.func_74768_a("speed", this.speed);
    }

    public String func_70303_b() {
        return "Grinder";
    }

    public int[] func_94128_d(int s) {
        ForgeDirection side = ForgeDirection.getOrientation((int)s);
        if (side == ForgeDirection.DOWN) {
            return OUT_s;
        }
        return INPUT_s;
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemstack) {
        return slotIndex == 0;
    }

    @Override
    public Charge getCharge() {
        return this.charge;
    }

    @Override
    public String getInfo() {
        float p = (float)(this.speed * 100) / 50.0f;
        return "Speed: " + (int)p + "%";
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.GRINDER;
    }

    void slowDown() {
        if (this.speed > 0) {
            --this.speed;
        }
    }

    void shareSpeed() {
        if (this.speed != this.last_speed) {
            this.last_speed = this.speed;
            this.broadcastMessage(null, 90, this.speed);
        }
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInputStream input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == 90) {
            this.speed = input.readInt();
            return true;
        }
        return false;
    }

    @Override
    public void func_70316_g() {
        this.rotation += this.speed;
        this.charge.update();
        super.func_70316_g();
    }

    @Override
    byte getExtraInfo2() {
        return (byte)this.speed;
    }

    @Override
    void useExtraInfo2(byte b) {
        this.speed = b;
    }

    @Override
    void doLogic() {
        this.shareSpeed();
        this.needLogic();
        if (this.energy < 30.0f && this.charge.getValue() >= 15) {
            this.energy += (float)(this.charge.deplete(60) / 10);
        }
        if (this.energy <= 0.0f) {
            this.slowDown();
            if (this.progress > 0) {
                --this.progress;
            }
            this.energy = 0.0f;
            return;
        }
        boolean powered = this.getCoord().isPowered();
        boolean grind_flag = this.canGrind();
        if (grind_flag || powered) {
            if (this.speed < 50) {
                ++this.speed;
                this.energy -= 2.0f;
            } else if (grind_flag) {
                if (this.progress == 75 || Core.cheat) {
                    this.progress = 0;
                    this.grind();
                } else {
                    ++this.progress;
                }
                this.energy -= 1.0f;
            }
        } else {
            this.slowDown();
        }
        if (!grind_flag) {
            this.progress = 0;
        }
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    public static void addRecipe(ItemStack input, ItemStack output, float probability) {
        GrinderRecipe toAdd = new GrinderRecipe(input, output, probability);
        for (GrinderRecipe gr : recipes) {
            if (!gr.input.equals(toAdd.input)) continue;
            return;
        }
        recipes.add(toAdd);
    }

    boolean canGrind() {
        this.input = FactorizationUtil.normalize(this.input);
        if (this.input == null) {
            return false;
        }
        GrinderRecipe gr = this.getRecipe();
        if (gr == null) {
            return false;
        }
        if (FactorizationUtil.couldMerge(gr.input, this.input)) {
            if (this.output == null) {
                return true;
            }
            if (!FactorizationUtil.couldMerge(this.output, gr.output)) {
                return false;
            }
            return !((double)this.output.field_77994_a + Math.ceil(gr.probability) > (double)this.output.func_77976_d());
        }
        return false;
    }

    GrinderRecipe getRecipe() {
        for (GrinderRecipe gr : recipes) {
            if (!FactorizationUtil.couldMerge(gr.input, this.input)) continue;
            return gr;
        }
        return null;
    }

    void grind() {
        GrinderRecipe gr = this.getRecipe();
        if (gr == null) {
            return;
        }
        if (FactorizationUtil.couldMerge(gr.input, this.input)) {
            if (this.output == null) {
                this.output = gr.output.func_77946_l();
                this.output.field_77994_a = 0;
            }
            int min = (int)gr.probability;
            this.output.field_77994_a += min;
            this.output.field_77994_a = this.output.field_77994_a + (rand.nextFloat() < gr.probability - (float)min ? 1 : 0);
            --this.input.field_77994_a;
            this.input = FactorizationUtil.normalize(this.input);
            return;
        }
    }

    public int getGrindProgressScaled(int total) {
        return total * this.progress / 75;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(ForgeDirection dir) {
        return BlockIcons.grinder_top;
    }

    public static class GrinderRecipe {
        public ItemStack input;
        public ItemStack output;
        public float probability;

        GrinderRecipe(ItemStack input, ItemStack output, float probability) {
            this.input = input;
            this.output = output;
            this.probability = probability;
        }
    }
}

