/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.Charge;
import factorization.api.Coord;
import factorization.api.IChargeConductor;
import factorization.common.BlockClass;
import factorization.common.BlockIcons;
import factorization.common.Core;
import factorization.common.FactoryType;
import factorization.common.TileEntityCommon;
import factorization.common.TileEntityCrystallizer;
import factorization.common.TileEntityExtension;
import factorization.common.TileEntityGreenware;
import factorization.common.TileEntitySlagFurnace;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import net.minecraft.block.BlockFurnace;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityHeater
extends TileEntityCommon
implements IChargeConductor {
    Charge charge = new Charge(this);
    public byte heat = 0;
    public static final byte maxHeat = 32;
    byte last_heat = (byte)-99;
    static Class rpAlloyFurnace = null;

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.HEATER;
    }

    @Override
    public Icon getIcon(ForgeDirection dir) {
        return BlockIcons.heater_spiral;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    @Override
    public Charge getCharge() {
        return this.charge;
    }

    @Override
    public String getInfo() {
        return null;
    }

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        this.charge.writeToNBT(tag);
        tag.func_74774_a("heat", this.heat);
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.charge.readFromNBT(tag);
        this.heat = tag.func_74771_c("heat");
    }

    int charge2heat(int i) {
        return (int)((double)i / 1.5);
    }

    void updateClient() {
        int delta = Math.abs(this.heat - this.last_heat);
        if (delta > 2) {
            this.broadcastMessage(null, 80, this.heat);
            this.last_heat = this.heat;
        }
    }

    @Override
    byte getExtraInfo() {
        return this.heat;
    }

    @Override
    void useExtraInfo(byte b) {
        this.heat = b;
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInputStream input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == 80) {
            this.heat = input.readByte();
            return true;
        }
        return false;
    }

    public void func_70316_g() {
        TileEntity te;
        int heatToRemove;
        int avail;
        int rate;
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        this.updateClient();
        Coord here = this.getCoord();
        if (here.isPowered()) {
            this.charge.update();
            return;
        }
        long now = this.field_70331_k.func_72820_D() + (long)here.seed();
        if (now % (long)(rate = 4) == 0L && (avail = Math.min(heatToRemove = 32 - this.heat, this.charge.getValue())) > 0 && this.charge2heat(heatToRemove) > 0) {
            this.heat = (byte)(this.heat + this.charge2heat(this.charge.deplete(heatToRemove)));
        }
        this.charge.update();
        if (this.heat <= 0) {
            return;
        }
        int recurs = 0;
        int action = 0;
        for (Coord c : here.getRandomNeighborsAdjacent()) {
            te = c.getTE();
            if (te == null) continue;
            if (te instanceof TileEntityHeater) {
                ++recurs;
                continue;
            }
            if (!this.sendHeat(te, false)) continue;
            ++action;
            if (this.heat > 0) continue;
            return;
        }
        if (recurs > 0 && action == 0) {
            for (Coord c : here.getRandomNeighborsAdjacent()) {
                te = c.getTE();
                if (te == null || !(te instanceof TileEntityHeater)) continue;
                this.sendHeat(te, true);
            }
        }
    }

    boolean shouldHeat(int cookTime) {
        if ((double)this.heat >= 16.0) {
            return true;
        }
        return cookTime > 0;
    }

    int addGraceHeat(int burnTime) {
        return Math.max(4, burnTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean sendHeat(TileEntity te, boolean canRecurse) {
        if (te instanceof TileEntityExtension && (te = ((TileEntityExtension)te).getParent()) == null) {
            return false;
        }
        if (te instanceof TileEntityFurnace) {
            TileEntityFurnace furnace = (TileEntityFurnace)te;
            if (!this.TEF_canSmelt(furnace)) {
                return false;
            }
            ProxiedHeatingResult pf = new ProxiedHeatingResult(new Coord(te), furnace.field_70407_a, furnace.field_70406_c);
            furnace.field_70407_a = pf.burnTime;
            furnace.field_70406_c = Math.min(pf.cookTime, 199);
            BlockFurnace.func_72286_a((furnace.field_70406_c > 0 ? 1 : 0) != 0, (World)this.field_70331_k, (int)te.field_70329_l, (int)te.field_70330_m, (int)te.field_70327_n);
            return true;
        }
        if (te instanceof TileEntitySlagFurnace) {
            TileEntitySlagFurnace furnace = (TileEntitySlagFurnace)te;
            if (!furnace.canSmelt()) {
                return false;
            }
            ProxiedHeatingResult pf = new ProxiedHeatingResult(new Coord(te), furnace.furnaceBurnTime, furnace.furnaceCookTime);
            furnace.furnaceBurnTime = pf.burnTime;
            furnace.furnaceCookTime = pf.cookTime;
            return true;
        }
        if (te instanceof TileEntityCrystallizer) {
            TileEntityCrystallizer crys = (TileEntityCrystallizer)te;
            if (!crys.needHeat()) {
                return false;
            }
            ++crys.heat;
            this.heat = (byte)(this.heat - 1);
            return true;
        }
        if (rpAlloyFurnace != null && rpAlloyFurnace.isInstance(te)) {
            Exception err = null;
            try {
                Field burntimeField = rpAlloyFurnace.getField("burntime");
                ProxiedHeatingResult pf = new ProxiedHeatingResult(new Coord(te), burntimeField.getInt(te), 0);
                burntimeField.setInt(te, pf.burnTime);
                boolean bl = true;
                return bl;
            }
            catch (SecurityException e) {
                err = e;
            }
            catch (NoSuchFieldException e) {
                err = e;
            }
            catch (IllegalArgumentException e) {
                err = e;
            }
            catch (IllegalAccessException e) {
                err = e;
            }
            finally {
                if (err != null) {
                    rpAlloyFurnace = null;
                    Core.logWarning("Failed to reflect into RedPower AlloyFurnace; heating disabled.", new Object[0]);
                    err.printStackTrace();
                }
            }
            return false;
        }
        if (te instanceof TileEntityGreenware) {
            TileEntityGreenware teg = (TileEntityGreenware)te;
            TileEntityGreenware.ClayState state = teg.getState();
            if (state == TileEntityGreenware.ClayState.DRY || state == TileEntityGreenware.ClayState.UNFIRED_GLAZED) {
                ++teg.totalHeat;
                this.heat = (byte)(this.heat - 3);
                return true;
            }
            if (state == TileEntityGreenware.ClayState.WET) {
                ++teg.lastTouched;
                this.heat = (byte)(this.heat - 6);
                return true;
            }
            return false;
        }
        if (canRecurse && te instanceof TileEntityHeater) {
            byte to_take = 2;
            if (this.heat < to_take) {
                return false;
            }
            TileEntityHeater heater = (TileEntityHeater)te;
            for (Coord c : heater.getCoord().getRandomNeighborsAdjacent()) {
                TileEntity it = c.getTE();
                if (it == this || it == null || it instanceof TileEntityHeater || !heater.sendHeat(it, false)) continue;
                this.heat = (byte)(this.heat - to_take);
                return true;
            }
            return false;
        }
        return false;
    }

    boolean TEF_canSmelt(TileEntityFurnace diss) {
        if (diss.func_70301_a(0) == null) {
            return false;
        }
        ItemStack var1 = FurnaceRecipes.func_77602_a().getSmeltingResult(diss.func_70301_a(0));
        if (var1 == null) {
            return false;
        }
        if (diss.func_70301_a(2) == null) {
            return true;
        }
        if (!diss.func_70301_a(2).func_77969_a(var1)) {
            return false;
        }
        int result = diss.func_70301_a((int)2).field_77994_a + var1.field_77994_a;
        return result <= diss.func_70297_j_() && result <= var1.func_77976_d();
    }

    private class ProxiedHeatingResult {
        int burnTime;
        int cookTime;
        int topBurnTime;

        public ProxiedHeatingResult(Coord furnace, int burnTime, int cookTime) {
            this.burnTime = burnTime;
            this.cookTime = cookTime;
            this.topBurnTime = 200;
            this.calculate(furnace);
        }

        private void calculate(Coord furnace) {
            for (int i = 0; i < 2; ++i) {
                if (TileEntityHeater.this.heat <= 16) {
                    return;
                }
                if (this.burnTime < this.topBurnTime) {
                    ++this.burnTime;
                } else {
                    ++this.cookTime;
                }
                TileEntityHeater.this.heat = (byte)(TileEntityHeater.this.heat - 1);
            }
        }
    }
}

