/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.Charge;
import factorization.api.Coord;
import factorization.api.IChargeConductor;
import factorization.common.BlockClass;
import factorization.common.BlockIcons;
import factorization.common.Core;
import factorization.common.FactorizationUtil;
import factorization.common.FactoryType;
import factorization.common.TileEntityFactorization;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class TileEntityMixer
extends TileEntityFactorization
implements IChargeConductor {
    private static final int INPUT_SIZE = 4;
    ItemStack[] input = new ItemStack[4];
    ItemStack[] output = new ItemStack[4];
    private static final int[] IN_s = new int[]{0, 1, 2, 3};
    private static final int[] OUT_s = new int[]{4, 5, 6, 7};
    ArrayList outputBuffer = new ArrayList();
    int progress = 0;
    int speed = 0;
    Charge charge = new Charge(this);
    int last_speed = -1;
    float rotation = 0.0f;
    private static ArrayList recipe_cache = null;
    RecipeMatchInfo cache = null;
    boolean dirty = true;

    @Override
    public Icon getIcon(ForgeDirection dir) {
        switch (dir) {
            case UP: {
                return BlockIcons.cauldron_top;
            }
        }
        return BlockIcons.cauldron_side;
    }

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        this.charge.writeToNBT(tag);
        tag.func_74768_a("progress", this.progress);
        tag.func_74768_a("speed", this.speed);
        this.writeSlotsToNBT(tag);
        NBTTagList buffer = new NBTTagList();
        for (ItemStack is : this.outputBuffer) {
            NBTTagCompound itag = new NBTTagCompound();
            is.func_77955_b(itag);
            buffer.func_74742_a((NBTBase)itag);
        }
        tag.func_74782_a("outBuffer", (NBTBase)buffer);
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.charge.readFromNBT(tag);
        this.progress = tag.func_74762_e("progress");
        this.speed = tag.func_74762_e("speed");
        this.readSlotsFromNBT(tag);
        NBTTagList outBuffer = tag.func_74761_m("outBuffer");
        if (outBuffer != null) {
            for (int i = 0; i < outBuffer.func_74745_c(); ++i) {
                NBTBase base = outBuffer.func_74743_b(i);
                if (!(base instanceof NBTTagCompound)) continue;
                ItemStack is = ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)base));
                this.outputBuffer.add(is);
            }
        }
        this.setDirty();
    }

    void setDirty() {
        if (this.field_70331_k != null && this.field_70331_k.field_72995_K) {
            return;
        }
        this.dirty = true;
        this.cache = null;
        this.func_70296_d();
    }

    @Override
    public void dropContents() {
        super.dropContents();
        Coord here = this.getCoord();
        for (ItemStack is : this.outputBuffer) {
            FactorizationUtil.spawnItemStack(here, is);
        }
        this.setDirty();
    }

    public int func_70302_i_() {
        return this.input.length + this.output.length;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot >= 0 && slot < this.input.length) {
            return this.input[slot];
        }
        if ((slot -= this.input.length) >= 0 && slot < this.output.length) {
            return this.output[slot];
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack is) {
        this.setDirty();
        if (slot >= 0 && slot < this.input.length) {
            this.input[slot] = is;
            return;
        }
        if ((slot -= this.input.length) >= 0 && slot < this.output.length) {
            this.output[slot] = is;
            return;
        }
    }

    public String func_70303_b() {
        return "Mixer";
    }

    public int[] func_94128_d(int s) {
        ForgeDirection side = ForgeDirection.getOrientation((int)s);
        if (side == ForgeDirection.DOWN) {
            return OUT_s;
        }
        return IN_s;
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemstack) {
        return slotIndex < this.input.length;
    }

    @Override
    public Charge getCharge() {
        return this.charge;
    }

    @Override
    public String getInfo() {
        return null;
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.MIXER;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        this.charge.update();
        this.rotation += (float)this.speed;
        this.shareRotationSpeed();
    }

    void shareRotationSpeed() {
        if (this.speed != this.last_speed) {
            this.broadcastMessage(null, 100, this.speed);
            this.last_speed = this.speed;
        }
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInputStream input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == 100) {
            this.speed = input.readInt();
            return true;
        }
        return false;
    }

    @Override
    int getLogicSpeed() {
        return 4;
    }

    int getRemainingProgress() {
        return 250 - this.progress;
    }

    public float getRotation() {
        return this.rotation;
    }

    boolean removeMatching(ItemStack[] hay, ItemStack needle) {
        needle = needle.func_77946_l();
        for (int i = 0; i < hay.length; ++i) {
            if (!FactorizationUtil.wildcardSimilar(needle, hay[i])) continue;
            int delta = Math.min(hay[i].field_77994_a, needle.field_77994_a);
            hay[i].field_77994_a -= delta;
            needle.field_77994_a -= delta;
            hay[i] = FactorizationUtil.normalize(hay[i]);
            if (needle.field_77994_a > 0) continue;
            return true;
        }
        return false;
    }

    boolean recipeMatches(List recipeItems) {
        int i;
        ItemStack[] in = new ItemStack[this.input.length];
        for (i = 0; i < this.input.length; ++i) {
            if (this.input[i] == null) continue;
            in[i] = this.input[i].func_77946_l();
        }
        for (i = 0; i < recipeItems.size(); ++i) {
            Object o = recipeItems.get(i);
            List<ItemStack> all = o instanceof ItemStack ? Arrays.asList((ItemStack)o) : (List<ItemStack>)o;
            boolean found = false;
            for (int R = 0; R < all.size(); ++R) {
                ItemStack recipeItem = all.get(R);
                if (!this.removeMatching(in, recipeItem)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static ArrayList getRecipes() {
        ArrayList<RecipeMatchInfo> cache = new ArrayList<RecipeMatchInfo>();
        block2: for (Object o : CraftingManager.func_77594_a().func_77592_b()) {
            ShapelessRecipes sr;
            IRecipe recipe = (IRecipe)o;
            List inputList = null;
            ItemStack output = null;
            if (recipe.getClass() == ShapelessRecipes.class) {
                sr = (ShapelessRecipes)recipe;
                inputList = sr.field_77579_b;
                output = sr.func_77571_b();
            }
            if (recipe.getClass() == ShapelessOreRecipe.class) {
                sr = (ShapelessOreRecipe)recipe;
                inputList = sr.getInput();
                output = sr.func_77571_b();
            }
            if (inputList == null || output == null) continue;
            output = output.func_77946_l();
            int s = inputList.size();
            if (s <= 1 || s > 9) continue;
            for (int i = 0; i < inputList.size(); ++i) {
                Object p = inputList.get(i);
                if (p instanceof String) {
                    ArrayList ores = OreDictionary.getOres((String)((String)p));
                    for (int X = 0; X < ores.size(); ++X) {
                        ores.set(X, ((ItemStack)ores.get(X)).func_77946_l());
                    }
                    p = ores;
                }
                if (p instanceof List) {
                    for (ItemStack is : (List)p) {
                        if (TileEntityMixer.isOkayRecipeItem(is)) continue;
                        continue block2;
                    }
                }
                if (p instanceof ItemStack && !TileEntityMixer.isOkayRecipeItem((ItemStack)p)) continue block2;
            }
            try {
                cache.add(new RecipeMatchInfo(inputList, output, recipe));
            }
            catch (WeirdRecipeException e) {}
        }
        return cache;
    }

    private static boolean isOkayRecipeItem(ItemStack is) {
        if (is == null) {
            return false;
        }
        Item item2 = (is = is.func_77946_l()).func_77973_b();
        if (item2 == null) {
            return false;
        }
        if (item2 == Item.field_77759_aK || item2 == Item.field_77760_aL) {
            return false;
        }
        if (item2.func_77634_r()) {
            ItemStack container = FactorizationUtil.normalize(item2.getContainerItemStack(is));
            if (container == null) {
                return true;
            }
            if (container.func_77973_b() != item2) {
                return true;
            }
            if (container.func_77984_f() || container.func_77951_h()) {
                return false;
            }
            if (container.func_77969_a(is)) {
                return false;
            }
        }
        return true;
    }

    RecipeMatchInfo getRecipe() {
        boolean empty = true;
        for (int i = 0; i < this.input.length; ++i) {
            if (this.input[i] == null) continue;
            empty = false;
            break;
        }
        if (empty) {
            return null;
        }
        if (recipe_cache == null) {
            recipe_cache = TileEntityMixer.getRecipes();
        }
        RecipeMatchInfo longest = null;
        for (int i = 0; i < recipe_cache.size(); ++i) {
            RecipeMatchInfo recipe = (RecipeMatchInfo)recipe_cache.get(i);
            if (!this.recipeMatches(recipe.inputs) || longest != null && longest.size >= recipe.size) continue;
            longest = recipe;
        }
        return longest;
    }

    static ItemStack[] copyArray(ItemStack[] src) {
        ItemStack[] clone = new ItemStack[src.length];
        for (int i = 0; i < src.length; ++i) {
            if (src[i] == null) continue;
            clone[i] = src[i].func_77946_l();
        }
        return clone;
    }

    boolean addItems(ItemStack[] out, ItemStack[] src) {
        for (ItemStack is : src) {
            int i;
            for (i = 0; i < out.length; ++i) {
                if (out[i] == null || !FactorizationUtil.couldMerge(is, out[i])) continue;
                int free = out[i].func_77976_d() - out[i].field_77994_a;
                int delta = Math.min(free, is.field_77994_a);
                is.field_77994_a -= delta;
                out[i].field_77994_a += delta;
                if ((is = FactorizationUtil.normalize(is)) == null) break;
            }
            if (is == null) continue;
            for (i = 0; i < out.length; ++i) {
                if (out[i] != null) continue;
                out[i] = is.func_77946_l();
                is = null;
                break;
            }
            if (is == null) continue;
            this.normalize(out);
            this.normalize(src);
            return false;
        }
        this.normalize(out);
        this.normalize(src);
        return true;
    }

    boolean hasFreeSpace(RecipeMatchInfo mr) {
        return this.addItems(TileEntityMixer.copyArray(this.output), new ItemStack[]{mr.output.func_77946_l()});
    }

    RecipeMatchInfo getCachedRecipe() {
        if (!this.dirty) {
            return this.cache;
        }
        this.dirty = false;
        this.cache = this.getRecipe();
        return this.cache;
    }

    void slow() {
        if (this.progress > 0) {
            this.progress = (int)Math.max(0.0, (double)this.progress * 0.8 - 5.0);
        }
        if (this.speed > 0) {
            --this.speed;
        }
    }

    boolean extractEnergy() {
        int i = Math.max(2, this.speed);
        return this.charge.tryTake(i) > 0;
    }

    int add(InventoryCrafting craft, int craft_slot, ItemStack is) {
        if (is == null) {
            return craft_slot;
        }
        if (is.field_77994_a > is.func_77976_d() || is.field_77994_a < 1) {
            Core.logWarning("%s: Trying to craft with %s, which has a stack size of %s", this.getCoord(), is, is.field_77994_a);
            craft.func_70299_a(craft_slot++, is);
            return craft_slot;
        }
        while (is.field_77994_a > 0) {
            craft.func_70299_a(craft_slot++, is.func_77979_a(1));
        }
        return craft_slot;
    }

    void craftRecipe(RecipeMatchInfo mr) {
        InventoryCrafting craft = FactorizationUtil.makeCraftingGrid();
        int craft_slot = 0;
        FactorizationUtil.FzInv inv = FactorizationUtil.openInventory((IInventory)this, ForgeDirection.UP);
        for (int i_input = 0; i_input < mr.inputs.size(); ++i_input) {
            Object o = mr.inputs.get(i_input);
            if (o instanceof ItemStack) {
                ItemStack is = (ItemStack)o;
                craft_slot = this.add(craft, craft_slot, inv.pull(is, is.field_77994_a, false));
                continue;
            }
            for (ItemStack is : (Iterable)o) {
                ItemStack got = FactorizationUtil.normalize(inv.pull(is, 1, false));
                if (got == null) continue;
                craft_slot = this.add(craft, craft_slot, got);
            }
        }
        EntityPlayer fakePlayer = FactorizationUtil.makePlayer(this.getCoord(), "Mixer");
        InventoryCraftResult craftResult = new InventoryCraftResult();
        ItemStack out = mr.output.func_77946_l();
        if (out.field_77994_a < 1) {
            out.field_77994_a = 1;
        }
        craftResult.func_70299_a(0, out);
        SlotCrafting slot = new SlotCrafting(fakePlayer, (IInventory)craft, (IInventory)craftResult, 0, 0, 0);
        slot.func_82870_a(fakePlayer, out);
        this.outputBuffer.add(out);
        FactorizationUtil.addInventoryToArray((IInventory)craft, this.outputBuffer);
        FactorizationUtil.addInventoryToArray((IInventory)fakePlayer.field_71071_by, this.outputBuffer);
        this.setDirty();
    }

    boolean dumpBuffer() {
        if (this.outputBuffer.size() > 0) {
            ItemStack toAdd = (ItemStack)this.outputBuffer.get(0);
            FactorizationUtil.FzInv out = FactorizationUtil.openInventory((IInventory)this, ForgeDirection.DOWN);
            out.setInsertForce(true);
            toAdd = out.push(toAdd);
            if (toAdd == null) {
                this.outputBuffer.remove(0);
                return this.outputBuffer.size() > 0;
            }
            return false;
        }
        return false;
    }

    @Override
    void doLogic() {
        this.needLogic();
        if (this.dumpBuffer()) {
            return;
        }
        RecipeMatchInfo mr = this.getCachedRecipe();
        if (mr == null) {
            this.slow();
            return;
        }
        if (!this.hasFreeSpace(mr)) {
            this.slow();
            return;
        }
        if (this.speed < 5 && this.extractEnergy()) {
            ++this.speed;
        } else if (!this.extractEnergy() && this.speed > 0) {
            int ns = Math.min(this.speed - 1, (int)((double)this.speed * 0.8));
            this.speed = ns = Math.max(ns, 0);
        }
        this.progress += this.speed;
        if (this.getRemainingProgress() <= 0 || Core.cheat) {
            this.progress = 0;
            this.craftRecipe(mr);
            this.normalize(this.input);
            int count = 8;
            while (this.dumpBuffer() && count-- > 0) {
            }
            this.speed = Math.min(50, this.speed + 1);
            this.dumpBuffer();
        }
    }

    void normalize(ItemStack[] is) {
        for (int i = 0; i < is.length; ++i) {
            is[i] = FactorizationUtil.normalize(is[i]);
        }
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    public int getMixProgressScaled(int scale) {
        return this.progress * scale / (this.progress + this.getRemainingProgress());
    }

    @Override
    byte getExtraInfo2() {
        return (byte)this.speed;
    }

    @Override
    void useExtraInfo(byte b) {
        this.speed = b;
    }

    public static class RecipeMatchInfo {
        public ArrayList inputs = new ArrayList();
        public ItemStack output;
        public IRecipe theRecipe;
        public int size = 0;

        void add(Object o) {
            if (o instanceof ItemStack) {
                int s;
                ItemStack it = (ItemStack)o;
                it = it.func_77946_l();
                o = it;
                it.field_77994_a = s = Math.min(1, it.field_77994_a);
                for (int i = 0; i < this.inputs.size(); ++i) {
                    ItemStack here;
                    Object h = this.inputs.get(i);
                    if (!(h instanceof ItemStack) || !FactorizationUtil.couldMerge(here = (ItemStack)h, it)) continue;
                    here.field_77994_a += s;
                    this.size += s;
                    return;
                }
                this.inputs.add(it);
                this.size += s;
                return;
            }
            this.inputs.add(o);
            ++this.size;
        }

        public RecipeMatchInfo(List recipeInput, ItemStack recipeOutput, IRecipe theRecipe) throws WeirdRecipeException {
            for (Object o : recipeInput) {
                if (o instanceof ItemStack) {
                    this.add((ItemStack)o);
                    continue;
                }
                if (o instanceof Collection) {
                    if (((Collection)o).size() == 0) {
                        throw new WeirdRecipeException();
                    }
                    ArrayList<ItemStack> parts = new ArrayList<ItemStack>();
                    for (Object p : (Collection)o) {
                        if (!(p instanceof ItemStack)) continue;
                        parts.add((ItemStack)p);
                    }
                    this.add(parts);
                    continue;
                }
                Core.logSevere("Don't know how to use %s in a recipe", o);
                throw new WeirdRecipeException();
            }
            this.output = recipeOutput;
            this.theRecipe = theRecipe;
        }
    }

    private static class WeirdRecipeException
    extends Throwable {
        private WeirdRecipeException() {
        }
    }
}

