/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.common.BlockClass;
import factorization.common.BlockIcons;
import factorization.common.FactorizationUtil;
import factorization.common.FactoryType;
import factorization.common.TileEntityFactorization;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;
import org.bouncycastle.util.Arrays;

public class TileEntityParaSieve
extends TileEntityFactorization
implements ISidedInventory {
    ItemStack[] filters = new ItemStack[8];
    private boolean putting_nbt = false;
    private boolean recursing = false;

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.PARASIEVE;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        this.putting_nbt = true;
        this.writeSlotsToNBT(tag);
        this.putting_nbt = false;
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.putting_nbt = true;
        this.readSlotsFromNBT(tag);
        this.putting_nbt = false;
    }

    public ForgeDirection getFacing() {
        return ForgeDirection.getOrientation((int)this.facing_direction).getOpposite();
    }

    @Override
    boolean canFaceVert() {
        return true;
    }

    boolean itemPassesFilter(ItemStack stranger) {
        for (int i = 0; i < this.filters.length / 2; ++i) {
            ItemStack a = this.filters[i * 2];
            ItemStack b = this.filters[i * 2 + 1];
            if (a == b && b == null || !FactorizationUtil.itemInRange(a, b, stranger)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IInventory getTarget() {
        if (this.recursing || this.putting_nbt || this.field_70331_k == null || this.field_70331_k.field_72995_K) {
            return null;
        }
        this.recursing = true;
        try {
            ForgeDirection facing = this.getFacing();
            if (facing == ForgeDirection.UNKNOWN) {
                IInventory iInventory = null;
                return iInventory;
            }
            TileEntity te = this.field_70331_k.func_72796_p(this.field_70329_l + facing.offsetX, this.field_70330_m + facing.offsetY, this.field_70327_n + facing.offsetZ);
            if (te instanceof IInventory) {
                if (te instanceof TileEntityParaSieve) {
                    IInventory iInventory = null;
                    return iInventory;
                }
                IInventory iInventory = FactorizationUtil.openDoubleChest((IInventory)te, true);
                return iInventory;
            }
            IInventory iInventory = null;
            return iInventory;
        }
        finally {
            this.recursing = false;
        }
    }

    public int func_70302_i_() {
        if (this.putting_nbt) {
            return this.filters.length;
        }
        IInventory target = this.getTarget();
        if (target == null) {
            return this.filters.length;
        }
        return this.filters.length + target.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        if (i < this.filters.length) {
            return this.filters[i];
        }
        IInventory target = this.getTarget();
        if (target == null) {
            return null;
        }
        return target.func_70301_a(i - this.filters.length);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        if (i < this.filters.length) {
            this.filters[i] = itemstack;
            return;
        }
        IInventory target = this.getTarget();
        if (target == null) {
            return;
        }
        target.func_70299_a(i - this.filters.length, itemstack);
    }

    public String func_70303_b() {
        return "Parasieve";
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (i < this.filters.length) {
            return true;
        }
        IInventory target = this.getTarget();
        if (target == null) {
            return false;
        }
        return target.func_94041_b(i - this.filters.length, itemstack) && this.itemPassesFilter(itemstack);
    }

    public int[] func_94128_d(int side) {
        IInventory target = this.getTarget();
        if (target == null) {
            return new int[0];
        }
        if (target instanceof ISidedInventory) {
            int[] ret = Arrays.clone((int[])((ISidedInventory)target).func_94128_d(side));
            int i = 0;
            while (i < ret.length) {
                int n = i++;
                ret[n] = ret[n] + this.filters.length;
            }
            return ret;
        }
        int len = target.func_70302_i_();
        int[] ret = new int[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = i + this.filters.length;
        }
        return ret;
    }

    @Override
    public boolean func_102007_a(int slot, ItemStack itemstack, int side) {
        if (slot < this.filters.length) {
            return true;
        }
        IInventory target = this.getTarget();
        if (target == null) {
            return true;
        }
        if (target instanceof ISidedInventory) {
            return ((ISidedInventory)target).func_102007_a(slot - this.filters.length, itemstack, side) && this.itemPassesFilter(itemstack);
        }
        return this.itemPassesFilter(itemstack);
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack itemstack, int side) {
        if (slot < this.filters.length) {
            return true;
        }
        IInventory target = this.getTarget();
        if (target == null) {
            return true;
        }
        if (target instanceof ISidedInventory) {
            return ((ISidedInventory)target).func_102008_b(slot - this.filters.length, itemstack, side) && this.itemPassesFilter(itemstack);
        }
        return this.itemPassesFilter(itemstack);
    }

    @Override
    void doLogic() {
    }

    public boolean canUpdate() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(ForgeDirection dir) {
        ForgeDirection face = this.getFacing();
        if (dir == face) {
            return BlockIcons.parasieve_front;
        }
        if (dir == face.getOpposite()) {
            return BlockIcons.parasieve_back;
        }
        return BlockIcons.parasieve_side;
    }
}

