/*
 * Decompiled with CFR 0.152.
 */
package factorization.fzds;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.network.ITinyPacketHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import factorization.api.Coord;
import factorization.api.Quaternion;
import factorization.common.Core;
import factorization.fzds.DeltaChunk;
import factorization.fzds.DimensionSliceEntity;
import factorization.fzds.Hammer;
import factorization.fzds.InteractionProxyingPlayer;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemInWorldManager;
import net.minecraft.item.ItemStack;
import net.minecraft.logging.ILogAgent;
import net.minecraft.network.NetServerHandler;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet131MapData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;

public class HammerNet
implements ITinyPacketHandler {
    static Socket fakeSocket = new Socket();

    public void handle(NetHandler handler, Packet131MapData mapData) {
        if (!handler.getPlayer().field_70170_p.field_72995_K) {
            try {
                this.handleDseClick(handler, mapData);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(mapData.field_73437_c);
        DataInputStream dis = new DataInputStream(bais);
        World world = handler.getPlayer().field_70170_p;
        try {
            short type = mapData.field_73436_b;
            int e_id = dis.readInt();
            Entity ent = world.func_73045_a(e_id);
            DimensionSliceEntity dse = null;
            if (ent instanceof DimensionSliceEntity) {
                dse = (DimensionSliceEntity)ent;
            }
            switch (type) {
                case 0: {
                    this.setRotation(dis, dse);
                    break;
                }
                case 1: {
                    this.setRotationalVelocity(dis, dse);
                    break;
                }
                case 2: {
                    this.setRotation(dis, dse);
                    this.setRotationalVelocity(dis, dse);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void handleDseClick(NetHandler handler, Packet131MapData mapData) throws IOException {
        World world = handler.getPlayer().field_70170_p;
        World shadow = DeltaChunk.getServerShadowWorld();
        MinecraftServer server = MinecraftServer.func_71276_C();
        EntityPlayerMP player = (EntityPlayerMP)handler.getPlayer();
        InteractionProxyingPlayer ipp = new InteractionProxyingPlayer(server, player, new ItemInWorldManager(shadow));
        ByteArrayInputStream bais = new ByteArrayInputStream(mapData.field_73437_c);
        DataInputStream dis = new DataInputStream(bais);
        short packetType = mapData.field_73436_b;
        switch (packetType) {
            case 3: 
            case 4: {
                int entityId = dis.readInt();
                Entity smacked = shadow.func_73045_a(entityId);
                if (smacked == null) {
                    Core.logWarning("%s clicked unknown entity %s", player, entityId);
                    return;
                }
                if (packetType == 3) {
                    ipp.func_70998_m(smacked);
                    break;
                }
                ipp.func_71059_n(smacked);
                break;
            }
            case 5: 
            case 6: {
                int hitX = dis.readInt();
                int hitY = dis.readInt();
                int hitZ = dis.readInt();
                int sideHit = dis.readInt();
                float xOffset = dis.readFloat();
                float yOffset = dis.readFloat();
                float zOffset = dis.readFloat();
                ItemStack is = player.func_70694_bm();
                if (packetType == 5) {
                    ipp.field_71134_c.func_73078_a((EntityPlayer)ipp, shadow, is, hitX, hitY, hitZ, sideHit, xOffset, yOffset, zOffset);
                    break;
                }
                Coord here = new Coord(shadow, hitX, hitY, hitZ);
                Block b = here.getBlock();
                if (b == null || !b.canHarvestBlock((EntityPlayer)player, here.getMd())) break;
                ipp.field_71134_c.func_73084_b(hitX, hitY, hitZ);
                break;
            }
            case 7: {
                System.out.println("We've gotten a wrapped up dig packet");
                Packet p = Packet.func_73272_a((ILogAgent)server.func_98033_al(), (DataInputStream)dis, (boolean)true, (Socket)fakeSocket);
                System.out.println("Dig packet> " + p);
                if (p == null) break;
                p.func_73279_a(handler);
                break;
            }
            default: {
                ((NetServerHandler)handler).func_72565_c("DeltaChunk: bad interaction packet");
            }
        }
    }

    void setRotation(DataInputStream dis, DimensionSliceEntity dse) throws IOException {
        Quaternion q = Quaternion.read(dis);
        if (dse != null) {
            dse.setRotation(q);
        }
    }

    void setRotationalVelocity(DataInputStream dis, DimensionSliceEntity dse) throws IOException {
        Quaternion q = Quaternion.read(dis);
        if (dse != null) {
            dse.setRotationalVelocity(q);
        }
    }

    static Packet131MapData makePacket(short type, Object ... items) {
        ByteArrayDataOutput dos = ByteStreams.newDataOutput();
        for (int i = 0; i < items.length; ++i) {
            Object obj = items[i];
            if (obj instanceof Quaternion) {
                ((Quaternion)obj).write(dos);
                continue;
            }
            if (obj instanceof Integer) {
                dos.writeInt(((Integer)obj).intValue());
                continue;
            }
            if (obj instanceof Float) {
                dos.writeFloat(((Float)obj).floatValue());
                continue;
            }
            throw new IllegalArgumentException("Can only do Quaternions/Integers/Floats!");
        }
        return PacketDispatcher.getTinyPacket((Object)Hammer.instance, (short)type, (byte[])dos.toByteArray());
    }

    public static class HammerNetType {
        public static final short rotation = 0;
        public static final short rotationVelocity = 1;
        public static final short rotationBoth = 2;
        public static final short rightClickEntity = 3;
        public static final short leftClickEntity = 4;
        public static final short rightClickBlock = 5;
        public static final short leftClickBlock = 6;
        public static final short digPacket = 7;
    }
}

