/*
 * Decompiled with CFR 0.152.
 */
package factorization.fzds;

import factorization.api.Quaternion;
import factorization.common.FactorizationUtil;
import java.util.List;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class MetaAxisAlignedBB
extends AxisAlignedBB {
    World shadowWorld;
    AxisAlignedBB shadowAABB;
    Vec3 offset;
    Quaternion rotation;
    Vec3 shadow2rotationOrigin;

    public MetaAxisAlignedBB(World shadowWorld, AxisAlignedBB shadowAABB, Vec3 offset, Quaternion rotation, Vec3 shadow2rotationOrigin) {
        super(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.shadowWorld = shadowWorld;
        this.shadowAABB = shadowAABB;
        this.offset = offset;
        this.rotation = rotation;
        this.shadow2rotationOrigin = shadow2rotationOrigin;
    }

    public MetaAxisAlignedBB setUnderlying(AxisAlignedBB bb) {
        this.func_72328_c(bb);
        return this;
    }

    List getUnderlying(AxisAlignedBB aabb) {
        return this.shadowWorld.func_72840_a(aabb);
    }

    private void shadow2rotation(Vec3 v) {
        v.field_72450_a -= this.shadow2rotationOrigin.field_72450_a;
        v.field_72448_b -= this.shadow2rotationOrigin.field_72448_b;
        v.field_72449_c -= this.shadow2rotationOrigin.field_72449_c;
    }

    private void rotation2shadow(Vec3 v) {
        v.field_72450_a += this.shadow2rotationOrigin.field_72450_a;
        v.field_72448_b += this.shadow2rotationOrigin.field_72448_b;
        v.field_72449_c += this.shadow2rotationOrigin.field_72449_c;
    }

    private AxisAlignedBB AabbReal2Shadow(AxisAlignedBB real) {
        AxisAlignedBB shadow = real.func_72325_c(-this.offset.field_72450_a, -this.offset.field_72448_b, -this.offset.field_72449_c);
        Vec3 shadowMax = FactorizationUtil.getMax(shadow);
        Vec3 shadowMin = FactorizationUtil.getMin(shadow);
        Vec3 centerInShadowSpace = FactorizationUtil.averageVec(shadowMax, shadowMin);
        Vec3 center = centerInShadowSpace.func_72441_c(0.0, 0.0, 0.0);
        this.shadow2rotation(center);
        this.rotation.applyRotation(center);
        this.rotation2shadow(center);
        Vec3 diff = centerInShadowSpace.func_72441_c(-center.field_72450_a, -center.field_72448_b, -center.field_72449_c);
        AxisAlignedBB moved = shadow.func_72325_c(diff.field_72450_a, diff.field_72448_b, diff.field_72449_c);
        double d = 0.0625;
        moved.field_72340_a -= d;
        moved.field_72338_b -= d;
        moved.field_72339_c -= d;
        moved.field_72336_d += d;
        moved.field_72337_e += d;
        moved.field_72334_f += d;
        return moved;
    }

    private AxisAlignedBB mutateLocal(AxisAlignedBB bb) {
        return bb;
    }

    public double func_72316_a(AxisAlignedBB collider, double currentOffset) {
        AxisAlignedBB shadow_version = this.AabbReal2Shadow(collider);
        List bbs = this.getUnderlying(shadow_version.func_72321_a(currentOffset, 0.0, 0.0));
        for (int i = 0; i < bbs.size(); ++i) {
            AxisAlignedBB here = this.mutateLocal((AxisAlignedBB)bbs.get(i));
            currentOffset = here.func_72316_a(shadow_version, currentOffset);
        }
        return currentOffset;
    }

    public double func_72323_b(AxisAlignedBB collider, double currentOffset) {
        AxisAlignedBB shadow_version = this.AabbReal2Shadow(collider);
        List bbs = this.getUnderlying(shadow_version.func_72321_a(0.0, currentOffset, 0.0));
        for (int i = 0; i < bbs.size(); ++i) {
            AxisAlignedBB here = this.mutateLocal((AxisAlignedBB)bbs.get(i));
            currentOffset = here.func_72323_b(shadow_version, currentOffset);
        }
        return currentOffset;
    }

    public double func_72322_c(AxisAlignedBB collider, double currentOffset) {
        AxisAlignedBB shadow_version = this.AabbReal2Shadow(collider);
        List bbs = this.getUnderlying(shadow_version.func_72321_a(0.0, 0.0, currentOffset));
        for (int i = 0; i < bbs.size(); ++i) {
            AxisAlignedBB here = this.mutateLocal((AxisAlignedBB)bbs.get(i));
            currentOffset = here.func_72322_c(shadow_version, currentOffset);
        }
        return currentOffset;
    }

    public boolean func_72326_a(AxisAlignedBB collider) {
        AxisAlignedBB shadow_version = this.AabbReal2Shadow(collider);
        List bbs = this.getUnderlying(shadow_version);
        for (int i = 0; i < bbs.size(); ++i) {
            AxisAlignedBB here = this.mutateLocal((AxisAlignedBB)bbs.get(i));
            if (!here.func_72326_a(shadow_version)) continue;
            return true;
        }
        return false;
    }
}

