/*
 * Decompiled with CFR 0.152.
 */
package factorization.fzds;

import factorization.api.Quaternion;
import factorization.fzds.Range;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.ForgeDirection;

public class RotatedBB
extends AxisAlignedBB {
    Quaternion rotation;
    AxisAlignedBB basis;
    ForgeDirection[] axes = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.SOUTH, ForgeDirection.EAST};
    private static ThreadLocal vertexBuffer = new ThreadLocal(){

        protected Vec3[] initialValue() {
            Vec3[] ret = new Vec3[8];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
            }
            return ret;
        }
    };

    protected RotatedBB() {
        super(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public void set(Quaternion rotation, AxisAlignedBB basis) {
        this.rotation = rotation;
        this.basis = basis;
    }

    public double func_72316_a(AxisAlignedBB collider, double deltaX) {
        return super.func_72316_a(collider, deltaX);
    }

    public double func_72323_b(AxisAlignedBB collider, double deltaY) {
        return super.func_72323_b(collider, deltaY);
    }

    public double func_72322_c(AxisAlignedBB collider, double deltaZ) {
        return super.func_72322_c(collider, deltaZ);
    }

    public boolean func_72326_a(AxisAlignedBB other) {
        ForgeDirection dir;
        int i;
        for (i = 0; i < this.axes.length; ++i) {
            Range otherNative;
            dir = this.axes[i];
            Range thisConverted = this.project(dir);
            if (thisConverted.intersects(otherNative = RotatedBB.getUnalteredRange(other, dir))) continue;
            return false;
        }
        for (i = 0; i < this.axes.length; ++i) {
            Range thisNative;
            dir = this.axes[i];
            Range otherConverted = RotatedBB.project(other, dir, this.rotation);
            if (otherConverted.intersects(thisNative = RotatedBB.getUnalteredRange(this.basis, dir))) continue;
            return false;
        }
        return true;
    }

    private static void set(Vec3 v, double x, double y, double z) {
        v.field_72450_a = x;
        v.field_72448_b = y;
        v.field_72449_c = z;
    }

    private static void yoink(Vec3[] ret, int i, int X, int Y, int Z) {
        RotatedBB.set(ret[i], ret[X].field_72450_a, ret[Y].field_72448_b, ret[Z].field_72449_c);
    }

    static Vec3[] getAabbVertices(AxisAlignedBB ab) {
        Vec3[] ret = (Vec3[])vertexBuffer.get();
        RotatedBB.set(ret[0], ab.field_72340_a, ab.field_72338_b, ab.field_72339_c);
        RotatedBB.set(ret[1], ab.field_72336_d, ab.field_72337_e, ab.field_72334_f);
        RotatedBB.yoink(ret, 2, 1, 0, 0);
        RotatedBB.yoink(ret, 3, 0, 1, 0);
        RotatedBB.yoink(ret, 4, 0, 0, 1);
        RotatedBB.yoink(ret, 5, 0, 1, 1);
        RotatedBB.yoink(ret, 6, 1, 0, 1);
        RotatedBB.yoink(ret, 7, 1, 1, 0);
        return ret;
    }

    private Range project(ForgeDirection dir) {
        Range range = new Range();
        Vec3[] verts = RotatedBB.getAabbVertices(this);
        for (int i = 0; i < verts.length; ++i) {
            Vec3 v = verts[i];
            this.rotation.applyRotation(v);
            range.include(v, dir);
        }
        return range;
    }

    private static Range project(AxisAlignedBB bb, ForgeDirection dir, Quaternion rotation) {
        Range range = new Range();
        Vec3[] verts = RotatedBB.getAabbVertices(bb);
        rotation.incrConjugate();
        for (int i = 0; i < verts.length; ++i) {
            Vec3 v = verts[i];
            rotation.applyRotation(v);
            range.include(v, dir);
        }
        rotation.incrConjugate();
        return range;
    }

    private static Range getUnalteredRange(AxisAlignedBB aabb, ForgeDirection dir) {
        switch (dir) {
            case EAST: 
            case WEST: {
                return new Range(aabb.field_72340_a, aabb.field_72336_d);
            }
            case UP: 
            case DOWN: {
                return new Range(aabb.field_72338_b, aabb.field_72337_e);
            }
            case NORTH: 
            case SOUTH: {
                return new Range(aabb.field_72339_c, aabb.field_72334_f);
            }
        }
        return null;
    }
}

