package mods.immibis.redlogic;

import mods.immibis.cobaltite.AssignedBlock;
import mods.immibis.cobaltite.AssignedItem;
import mods.immibis.cobaltite.CobaltiteMod;
import mods.immibis.cobaltite.ModBase;
import mods.immibis.cobaltite.TileGUI;
import mods.immibis.cobaltite.CobaltiteMod.RegisteredTile;
import mods.immibis.core.api.FMLModInfo;
import mods.immibis.core.api.util.Colour;
import mods.immibis.redlogic.gates.*;
import mods.immibis.redlogic.wires.EnumWires;
import mods.immibis.redlogic.wires.PlainRedAlloyTile;
import mods.immibis.redlogic.wires.WireBlock;
import mods.immibis.redlogic.wires.WireItem;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.Instance;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid="RedLogic", name="RedLogic", version="55.0.2", dependencies="required-after:ImmibisCore")
@NetworkMod(clientSideRequired = true, serverSideRequired = true)
@CobaltiteMod(
		tiles = {
				@RegisteredTile(id="immibis.redlogic.gate", tile=GateTile.class, render="mods.immibis.redlogic.gates.GateDynamicRenderer"),
				@RegisteredTile(id="immibis.redlogic.wire.redalloy", tile=PlainRedAlloyTile.class)
		}
	)
@FMLModInfo(authors = "immibis", description = "Replacement for RP2 Wiring, Logic and Control",
	url="http://www.minecraftforum.net/topic/1852277-152-redlogic-wip-replacement-for-rp2-wiringlogiccontrollighting/")
public class RedLogicMod extends ModBase {

	@TileGUI(container=TimerContainer.class, gui=TimerGui.class)
	public static final int GUI_TIMER = 0;

	@TileGUI(container=CounterContainer.class, gui=CounterGui.class)
	public static final int GUI_COUNTER = 1;

	public static final String CHANNEL = "RedLogic";

	@Instance("RedLogic")
	public static RedLogicMod instance;

	@AssignedBlock(id="gates", item=GateItem.class)
	public static GateBlock gates;

	@AssignedBlock(id="wire", item=WireItem.class)
	public static WireBlock wire;

	@AssignedItem(id="screwdriver")
	public static ItemScrewdriver screwdriver;

	@Init public void init(FMLInitializationEvent evt) {super._init(evt);}
	@PreInit public void preinit(FMLPreInitializationEvent evt) {super._preinit(evt);}

	@Override
	protected void initBlocksAndItems() {
		for(EnumGates g : EnumGates.VALUES)
			LanguageRegistry.addName(new ItemStack(gates, 1, g.ordinal()), g.name);

		for(EnumWires w : EnumWires.VALUES)
			LanguageRegistry.addName(new ItemStack(wire, 1, w.ordinal()), w.name);
	}
	
	@Override
	protected void addRecipes() throws Exception {
		GameRegistry.addRecipe(new ItemStack(screwdriver),
			" YI",
			" IB",
			"/  ",
			'Y', new ItemStack(Item.dyePowder, 1, Colour.YELLOW.dyeId()),
			'B', new ItemStack(Item.dyePowder, 1, Colour.BLACK.dyeId()),
			'/', Item.stick,
			'I', Item.ingotIron
			);
		
		GameRegistry.addRecipe(new ItemStack(wire, 16, EnumWires.RED_ALLOY.ordinal()),
			"R R",
			"RIR",
			"R R",
			'R', Item.redstone,
			'I', Item.ingotIron
			);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.AND.ordinal()),
			" T ",
			"TTT",
			" R ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.OR.ordinal()),
			" T ",
			"RTR",
			" R ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.NOT.ordinal()),
			" R ",
			"RTR",
			" R ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.RSLATCH.ordinal()),
			"STR",
			"R R",
			"RTS",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.cobblestone);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.TOGGLE.ordinal()),
			" T ",
			"RLR",
			" T ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'L', Block.lever);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.NOR.ordinal()),
			" T ",
			"RRR",
			" R ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.NAND.ordinal()),
			" R ",
			"TTT",
			" R ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.XOR.ordinal()),
			"RRR",
			"TRT",
			"RTR",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.XNOR.ordinal()),
			"RTR",
			"TRT",
			"RTR",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.Buffer.ordinal()),
			"RTR",
			"RTR",
			" R ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.Multiplexer.ordinal()),
			"RTR",
			"T T",
			"RTR",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.Repeater.ordinal()),
			"RRR",
			"R_R",
			"RRR",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'_', Item.redstoneRepeater);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.Timer.ordinal()),
			" T ",
			"RIR",
			"   ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'I', Item.ingotIron);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.Counter.ordinal()),
			"T  ",
			"IRR",
			"T  ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'I', Item.ingotIron);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.Sequencer.ordinal()),
			" T ",
			"TIT",
			" T ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'I', Item.ingotIron);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.PulseFormer.ordinal()),
			"RTR",
			"TRT",
			"RR ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.Randomizer.ordinal()),
			" T ",
			"TGT",
			" R ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'G', Item.lightStoneDust);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.StateCell.ordinal()),
			" RT",
			"RXI",
			" R ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'X', new ItemStack(gates, 1, EnumGates.RSLATCH.ordinal()),
			'I', Item.ingotIron);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.Synchronizer.ordinal()),
			"RTR",
			"XRX",
			"R R",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'X', new ItemStack(gates, 1, EnumGates.RSLATCH.ordinal()));
		
		/*GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.DLatch.ordinal()),
			"   ",
			"   ",
			"   ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone);*/
	}
}
