package mods.immibis.redlogic.gates;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public enum EnumGates {
	AND("AND gate", GateLogic.AND.class, GateRendering.AND.class),
	OR("OR gate", GateLogic.OR.class, GateRendering.OR.class),
	NOT("NOT gate", GateLogic.NOT.class, GateRendering.NOT.class),
	RSLATCH("RS-Latch", GateLogic.RSLatch.class, GateRendering.RSLatch.class),
	TOGGLE("T-Latch", GateLogic.ToggleLatch.class, GateRendering.ToggleLatch.class),
	NOR("NOR gate", GateLogic.NOR.class, GateRendering.NOR.class),
	NAND("NAND gate", GateLogic.NAND.class, GateRendering.NAND.class),
	XOR("XOR gate", GateLogic.XOR.class, GateRendering.XOR.class),
	XNOR("XNOR gate", GateLogic.XNOR.class, GateRendering.XNOR.class),
	Buffer("Buffer gate", GateLogic.Buffer.class, GateRendering.Buffer.class),
	Multiplexer("Multiplexer", GateLogic.Multiplexer.class, GateRendering.Multiplexer.class),
	Repeater("Repeater", GateLogic.Repeater.class, GateRendering.Repeater.class),
	Timer("Timer", GateLogic.Timer.class, GateRendering.Timer.class),
	Counter("Counter", GateLogic.Counter.class, GateRendering.Counter.class),
	Sequencer("Sequencer", GateLogic.Sequencer.class, GateRendering.Sequencer.class),
	PulseFormer("Pulse Former", GateLogic.PulseFormer.class, GateRendering.PulseFormer.class),
	Randomizer("Randomizer", GateLogic.Randomizer.class, GateRendering.Randomizer.class),
	StateCell("State Cell", GateLogic.StateCell.class, GateRendering.StateCell.class),
	Synchronizer("Synchronizer", GateLogic.Synchronizer.class, GateRendering.Synchronizer.class),
	//DLatch("D-Latch", GateLogic.DLatch.class, GateRendering.DLatch.class),
	;
	
	private Class<? extends GateLogic> logicClass;
	private Class<? extends GateRendering> renderClass;
	private GateLogic logicInst;
	private GateRendering renderInst;
	public final String name;
	
	private EnumGates(String name, Class<? extends GateLogic> logicClass, Class<? extends GateRendering> renderClass) {
		this.name = name;
		
		this.logicClass = logicClass;
		this.renderClass = renderClass;
		
		if(GateLogic.Stateless.class.isAssignableFrom(logicClass))
			logicInst = createLogic();
	}
	
	public GateLogic createLogic() {
		if(logicInst != null)
			return logicInst;
		try {
			return logicClass.getConstructor().newInstance();
		} catch(Exception e) {
			throw new RuntimeException(e);
		}
	}
	
	@SideOnly(Side.CLIENT)
	public GateRendering getRendering() {
		if(renderInst != null)
			return renderInst;
		try {
			renderInst = renderClass.getConstructor().newInstance(); 
		} catch(Exception e) {
			throw new RuntimeException(e);
		}
		return renderInst;
	}

	public Class<? extends GateLogic> getLogicClass() {
		return logicClass;
	}
	
	public static final EnumGates[] VALUES = values();
}
