package mods.immibis.redlogic.wires;

import mods.immibis.core.api.porting.PortableBlockRenderer;
import mods.immibis.core.api.util.Dir;
import mods.immibis.redlogic.RotatedTessellator;
import mods.immibis.redlogic.Utils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class StaticRenderer implements PortableBlockRenderer {
	
	private RotatedTessellator rt = new RotatedTessellator();
	
	public final static StaticRenderer instance = new StaticRenderer();
	
	public void renderWorld(RenderBlocks render, EnumWires type, WireTile wt, int sideMask) {
		
		int x = wt.xCoord, y = wt.yCoord, z = wt.zCoord;
		
		rt.base = Tessellator.instance;
		rt.flipped = false;
		rt.x = x;
		rt.y = y;
		rt.z = z;
		
		mods.immibis.core.RenderUtilsIC.setBrightness(wt.worldObj, x, y, z);
		rt.base.setColorOpaque_I(wt.getWireColour());
		
		
		for(int side = 0; side < 6; side++) {
			if((sideMask & (1 << side)) == 0)
				continue;
			
			rt.front = side < 2 ? 2 : 0; // anything not parallel to side
			rt.side = side;
			
			//System.out.println("rendering side "+side);
			
			int[] dirMap = Utils.dirMap[rt.side][rt.front];
			
			boolean front = wt.connectsInDirection(side, dirMap[Utils.FRONT]);
			boolean back = wt.connectsInDirection(side, dirMap[Utils.BACK]);
			boolean left = wt.connectsInDirection(side, dirMap[Utils.LEFT]);
			boolean right = wt.connectsInDirection(side, dirMap[Utils.RIGHT]);
			
			boolean frontCorner = front && wt.connectsInDirectionAroundCorner(side, dirMap[Utils.FRONT]);
			boolean backCorner = back && wt.connectsInDirectionAroundCorner(side, dirMap[Utils.BACK]);
			boolean leftCorner = left && wt.connectsInDirectionAroundCorner(side, dirMap[Utils.LEFT]);
			boolean rightCorner = right && wt.connectsInDirectionAroundCorner(side, dirMap[Utils.RIGHT]);
			
			boolean forceEndCaps = true; // TODO optimize if necessary
			
			renderWireSide(type, front, back, left, right, frontCorner, backCorner, leftCorner, rightCorner, forceEndCaps);
		}
	}

	@Override
	public boolean renderWorldBlock(RenderBlocks render, IBlockAccess world, int x, int y, int z, Block block, int model) {
		WireTile wt = (WireTile)world.getBlockTileEntity(x, y, z);
		EnumWires type = wt.getType();
		//System.out.println("render wire with type "+type+", sidemask "+wt.getSideMask());
		if(type == null)
			return false;
		
		byte sideMask = wt.getSideMask();
		
		renderWorld(render, type, wt, sideMask);
		
		return true;
	}

	@Override
	public void renderInvBlock(RenderBlocks render, Block block, int meta, int model) {
		if(meta < 0 || meta >= EnumWires.VALUES.length)
			return;
		EnumWires type = EnumWires.VALUES[meta];
		
		Minecraft.getMinecraft().renderEngine.bindTexture("/terrain.png");
		
		rt.base = Tessellator.instance;
		rt.flipped = false;
		rt.x = -0.5;
		rt.y = 0;
		rt.z = -0.5;
		rt.front = 2; // anything not parallel to side
		rt.side = Dir.NY;
		rt.base.startDrawingQuads();
		rt.base.setBrightness(0x00F000F0);
		rt.base.setColorOpaque_I(type.itemColour);
		renderWireSide(type, true, true, true, true, false, false, false, false, true);
		rt.base.draw();
	}
	
	private void renderWireSide(EnumWires type, boolean front, boolean back, boolean left, boolean right, boolean frontCorner, boolean backCorner, boolean leftCorner, boolean rightCorner, boolean forceEndCaps) {
		Icon tex = type.texture;
		double u1 = tex.getMinU();
		double v1 = tex.getMinV();
		double u2 = tex.getMaxU();
		double v2 = tex.getMaxV();
		
		double thick = type.thickness;
		double w = type.width / 2;
		double W = type.width * 16 / 2;
		
		boolean unconnected = !front && !back && !left && !right;
		
		double minX = left ? 0 : right && !front && !back ? 0.25 : 0.5-w;
		double maxX = right ? 1 : left && !front && !back ? 0.75 : 0.5+w;
		double minZ = front ? 0 : unconnected || (back && !left && !right) ? 0.25 : 0.5-w;
		double maxZ = back ? 1 : unconnected || (front && !left && !right) ? 0.75 : 0.5+w;
		
		if(leftCorner) minX -= thick;
		if(rightCorner) maxX += thick;
		if(frontCorner) minZ -= thick;
		if(backCorner) maxZ += thick;
		
		// +/- Z
		if(front || back || unconnected) {
			rt.base.setNormal(0, 1, 0);
			rt.addVertexWithUV(0.5-w, thick, minZ, tex.getInterpolatedU(8-W), v1);
			rt.addVertexWithUV(0.5-w, thick, maxZ, tex.getInterpolatedU(8-W), v2);
			rt.addVertexWithUV(0.5+w, thick, maxZ, tex.getInterpolatedU(8+W), v2);
			rt.addVertexWithUV(0.5+w, thick, minZ, tex.getInterpolatedU(8+W), v1);
			
			rt.base.setNormal(-1, 0, 0);
			rt.addVertexWithUV(0.5-w,     0, minZ, tex.getInterpolatedU(8-W+thick*16), v1);
			rt.addVertexWithUV(0.5-w,     0, maxZ, tex.getInterpolatedU(8-W+thick*16), v2);
			rt.addVertexWithUV(0.5-w, thick, maxZ, tex.getInterpolatedU(8-W), v2);
			rt.addVertexWithUV(0.5-w, thick, minZ, tex.getInterpolatedU(8-W), v1);
			
			rt.base.setNormal(1, 0, 0);
			rt.addVertexWithUV(0.5+w,     0, maxZ, tex.getInterpolatedU(8-W+thick*16), v2);
			rt.addVertexWithUV(0.5+w,     0, minZ, tex.getInterpolatedU(8-W+thick*16), v1);
			rt.addVertexWithUV(0.5+w, thick, minZ, tex.getInterpolatedU(8-W), v1);
			rt.addVertexWithUV(0.5+w, thick, maxZ, tex.getInterpolatedU(8-W), v2);
			
			if(!front || forceEndCaps) {
				rt.base.setNormal(0, 0, -1);
				rt.addVertexWithUV(0.5-w, thick, minZ, tex.getInterpolatedU(8-W), tex.getInterpolatedV(8-W));
				rt.addVertexWithUV(0.5+w, thick, minZ, tex.getInterpolatedU(8+W), tex.getInterpolatedV(8-W));
				rt.addVertexWithUV(0.5+w,     0, minZ, tex.getInterpolatedU(8+W), tex.getInterpolatedV(8-W+thick*16));
				rt.addVertexWithUV(0.5-w,     0, minZ, tex.getInterpolatedU(8-W), tex.getInterpolatedV(8-W+thick*16));
			}
			
			if(!back || forceEndCaps) {
				rt.base.setNormal(0, 0, 1);
				rt.addVertexWithUV(0.5-w,     0, maxZ, tex.getInterpolatedU(8-W), tex.getInterpolatedV(8-W+thick*16));
				rt.addVertexWithUV(0.5+w,     0, maxZ, tex.getInterpolatedU(8+W), tex.getInterpolatedV(8-W+thick*16));
				rt.addVertexWithUV(0.5+w, thick, maxZ, tex.getInterpolatedU(8+W), tex.getInterpolatedV(8-W));
				rt.addVertexWithUV(0.5-w, thick, maxZ, tex.getInterpolatedU(8-W), tex.getInterpolatedV(8-W));
			}
		}
		
		
		// +/- X
		if(left || right) {
			rt.base.setNormal(0, 1, 0);
			rt.addVertexWithUV(minX, thick, 0.5-w, tex.getInterpolatedU(8-W), v1);
			rt.addVertexWithUV(minX, thick, 0.5+w, tex.getInterpolatedU(8+W), v1);
			rt.addVertexWithUV(maxX, thick, 0.5+w, tex.getInterpolatedU(8+W), v2);
			rt.addVertexWithUV(maxX, thick, 0.5-w, tex.getInterpolatedU(8-W), v2);
			
			rt.base.setNormal(0, 0, -1);
			rt.addVertexWithUV(maxX,     0, 0.5-w, tex.getInterpolatedU(8-W+thick*16), v1);
			rt.addVertexWithUV(minX,     0, 0.5-w, tex.getInterpolatedU(8-W+thick*16), v2);
			rt.addVertexWithUV(minX, thick, 0.5-w, tex.getInterpolatedU(8-W), v2);
			rt.addVertexWithUV(maxX, thick, 0.5-w, tex.getInterpolatedU(8-W), v1);
			
			rt.base.setNormal(0, 0, 1);
			rt.addVertexWithUV(minX,     0, 0.5+w, tex.getInterpolatedU(8-W+thick*16), v2);
			rt.addVertexWithUV(maxX,     0, 0.5+w, tex.getInterpolatedU(8-W+thick*16), v1);
			rt.addVertexWithUV(maxX, thick, 0.5+w, tex.getInterpolatedU(8-W), v1);
			rt.addVertexWithUV(minX, thick, 0.5+w, tex.getInterpolatedU(8-W), v2);
			
			if(forceEndCaps || !left) {
				rt.base.setNormal(0, 0, -1);
				rt.addVertexWithUV(minX, thick, 0.5+w, tex.getInterpolatedU(8-W), tex.getInterpolatedV(8-W));
				rt.addVertexWithUV(minX, thick, 0.5-w, tex.getInterpolatedU(8+W), tex.getInterpolatedV(8-W));
				rt.addVertexWithUV(minX,     0, 0.5-w, tex.getInterpolatedU(8+W), tex.getInterpolatedV(8-W+thick*16));
				rt.addVertexWithUV(minX,     0, 0.5+w, tex.getInterpolatedU(8-W), tex.getInterpolatedV(8-W+thick*16));
			}
			
			if(forceEndCaps || !right) {
				rt.base.setNormal(0, 0, 1);
				rt.addVertexWithUV(maxX,     0, 0.5+w, tex.getInterpolatedU(8-W), tex.getInterpolatedV(8-W+thick*16));
				rt.addVertexWithUV(maxX,     0, 0.5-w, tex.getInterpolatedU(8+W), tex.getInterpolatedV(8-W+thick*16));
				rt.addVertexWithUV(maxX, thick, 0.5-w, tex.getInterpolatedU(8+W), tex.getInterpolatedV(8-W));
				rt.addVertexWithUV(maxX, thick, 0.5+w, tex.getInterpolatedU(8-W), tex.getInterpolatedV(8-W));
			}
		}
		
	}

}
