/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.impl.hash;

import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.PrimeFinder;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class THash
implements Externalizable {
    static final long serialVersionUID = -1792948471915530295L;
    protected static final float DEFAULT_LOAD_FACTOR = 0.5f;
    protected static final int DEFAULT_CAPACITY = 10;
    protected transient int _size;
    protected transient int _free;
    protected float _loadFactor;
    protected int _maxSize;
    protected int _autoCompactRemovesRemaining;
    protected float _autoCompactionFactor;
    protected transient boolean _autoCompactTemporaryDisable = false;

    public THash() {
        this(10, 0.5f);
    }

    public THash(int n) {
        this(n, 0.5f);
    }

    public THash(int n, float f) {
        this._loadFactor = f;
        this._autoCompactionFactor = f;
        this.setUp(HashFunctions.fastCeil((float)n / f));
    }

    public boolean isEmpty() {
        return 0 == this._size;
    }

    public int size() {
        return this._size;
    }

    public abstract int capacity();

    public void ensureCapacity(int n) {
        if (n > this._maxSize - this.size()) {
            this.rehash(PrimeFinder.nextPrime(Math.max(this.size() + 1, HashFunctions.fastCeil((float)(n + this.size()) / this._loadFactor) + 1)));
            this.computeMaxSize(this.capacity());
        }
    }

    public void compact() {
        this.rehash(PrimeFinder.nextPrime(Math.max(this._size + 1, HashFunctions.fastCeil((float)this.size() / this._loadFactor) + 1)));
        this.computeMaxSize(this.capacity());
        if (this._autoCompactionFactor != 0.0f) {
            this.computeNextAutoCompactionAmount(this.size());
        }
    }

    public void setAutoCompactionFactor(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("Factor must be >= 0: " + f);
        }
        this._autoCompactionFactor = f;
    }

    public float getAutoCompactionFactor() {
        return this._autoCompactionFactor;
    }

    public final void trimToSize() {
        this.compact();
    }

    protected void removeAt(int n) {
        --this._size;
        if (this._autoCompactionFactor != 0.0f) {
            --this._autoCompactRemovesRemaining;
            if (!this._autoCompactTemporaryDisable && this._autoCompactRemovesRemaining <= 0) {
                this.compact();
            }
        }
    }

    public void clear() {
        this._size = 0;
        this._free = this.capacity();
    }

    protected int setUp(int n) {
        int n2 = PrimeFinder.nextPrime(n);
        this.computeMaxSize(n2);
        this.computeNextAutoCompactionAmount(n);
        return n2;
    }

    protected abstract void rehash(int var1);

    public void tempDisableAutoCompaction() {
        this._autoCompactTemporaryDisable = true;
    }

    public void reenableAutoCompaction(boolean bl) {
        this._autoCompactTemporaryDisable = false;
        if (bl && this._autoCompactRemovesRemaining <= 0 && this._autoCompactionFactor != 0.0f) {
            this.compact();
        }
    }

    protected void computeMaxSize(int n) {
        this._maxSize = Math.min(n - 1, (int)((float)n * this._loadFactor));
        this._free = n - this._size;
    }

    protected void computeNextAutoCompactionAmount(int n) {
        if (this._autoCompactionFactor != 0.0f) {
            this._autoCompactRemovesRemaining = (int)((float)n * this._autoCompactionFactor + 0.5f);
        }
    }

    protected final void postInsertHook(boolean bl) {
        if (bl) {
            --this._free;
        }
        if (++this._size > this._maxSize || this._free == 0) {
            int n = this._size > this._maxSize ? PrimeFinder.nextPrime(this.capacity() << 1) : this.capacity();
            this.rehash(n);
            this.computeMaxSize(this.capacity());
        }
    }

    protected int calculateGrownCapacity() {
        return this.capacity() << 1;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(0);
        objectOutput.writeFloat(this._loadFactor);
        objectOutput.writeFloat(this._autoCompactionFactor);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        objectInput.readByte();
        float f = this._loadFactor;
        this._loadFactor = objectInput.readFloat();
        this._autoCompactionFactor = objectInput.readFloat();
        if (f != this._loadFactor) {
            this.setUp((int)Math.ceil(10.0f / this._loadFactor));
        }
    }
}

