/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.impl.hash;

import gnu.trove.impl.hash.THash;
import gnu.trove.impl.hash.TObjectHash;
import gnu.trove.iterator.TIterator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class THashIterator
implements TIterator,
Iterator {
    private final TObjectHash _object_hash;
    protected final THash _hash;
    protected int _expectedSize;
    protected int _index;

    protected THashIterator(TObjectHash tObjectHash) {
        this._hash = tObjectHash;
        this._expectedSize = this._hash.size();
        this._index = this._hash.capacity();
        this._object_hash = tObjectHash;
    }

    public Object next() {
        this.moveToNextIndex();
        return this.objectAtIndex(this._index);
    }

    @Override
    public boolean hasNext() {
        return this.nextIndex() >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove() {
        if (this._expectedSize != this._hash.size()) {
            throw new ConcurrentModificationException();
        }
        try {
            this._hash.tempDisableAutoCompaction();
            this._hash.removeAt(this._index);
        }
        finally {
            this._hash.reenableAutoCompaction(false);
        }
        --this._expectedSize;
    }

    protected final void moveToNextIndex() {
        this._index = this.nextIndex();
        if (this._index < 0) {
            throw new NoSuchElementException();
        }
    }

    protected final int nextIndex() {
        if (this._expectedSize != this._hash.size()) {
            throw new ConcurrentModificationException();
        }
        Object[] objectArray = this._object_hash._set;
        int n = this._index;
        while (n-- > 0 && (objectArray[n] == TObjectHash.FREE || objectArray[n] == TObjectHash.REMOVED)) {
        }
        return n;
    }

    protected abstract Object objectAtIndex(int var1);
}

