/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.impl.hash;

import gnu.trove.impl.hash.THash;
import gnu.trove.procedure.TObjectProcedure;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public abstract class TObjectHash
extends THash {
    static final long serialVersionUID = -3461112548087185871L;
    public transient Object[] _set;
    public static final Object REMOVED = new Object();
    public static final Object FREE = new Object();
    protected boolean consumeFreeSlot;

    public TObjectHash() {
    }

    public TObjectHash(int n) {
        super(n);
    }

    public TObjectHash(int n, float f) {
        super(n, f);
    }

    @Override
    public int capacity() {
        return this._set.length;
    }

    @Override
    protected void removeAt(int n) {
        this._set[n] = REMOVED;
        super.removeAt(n);
    }

    @Override
    public int setUp(int n) {
        int n2 = super.setUp(n);
        this._set = new Object[n2];
        Arrays.fill(this._set, FREE);
        return n2;
    }

    public boolean forEach(TObjectProcedure tObjectProcedure) {
        Object[] objectArray = this._set;
        int n = objectArray.length;
        while (n-- > 0) {
            if (objectArray[n] == FREE || objectArray[n] == REMOVED || tObjectProcedure.execute(objectArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Object object) {
        return this.index(object) >= 0;
    }

    protected int index(Object object) {
        if (object == null) {
            return this.indexForNull();
        }
        int n = this.hash(object) & Integer.MAX_VALUE;
        int n2 = n % this._set.length;
        Object object2 = this._set[n2];
        if (object2 == FREE) {
            return -1;
        }
        if (object2 == object || this.equals(object, object2)) {
            return n2;
        }
        return this.indexRehashed(object, n2, n, object2);
    }

    private int indexRehashed(Object object, int n, int n2, Object object2) {
        Object[] objectArray = this._set;
        int n3 = objectArray.length;
        int n4 = 1 + n2 % (n3 - 2);
        int n5 = n;
        do {
            if ((n -= n4) < 0) {
                n += n3;
            }
            if ((object2 = objectArray[n]) == FREE) {
                return -1;
            }
            if (object2 != object && !this.equals(object, object2)) continue;
            return n;
        } while (n != n5);
        return -1;
    }

    private int indexForNull() {
        int n = 0;
        for (Object object : this._set) {
            if (object == null) {
                return n;
            }
            if (object == FREE) {
                return -1;
            }
            ++n;
        }
        return -1;
    }

    @Deprecated
    protected int insertionIndex(Object object) {
        return this.insertKey(object);
    }

    protected int insertKey(Object object) {
        this.consumeFreeSlot = false;
        if (object == null) {
            return this.insertKeyForNull();
        }
        int n = this.hash(object) & Integer.MAX_VALUE;
        int n2 = n % this._set.length;
        Object object2 = this._set[n2];
        if (object2 == FREE) {
            this.consumeFreeSlot = true;
            this._set[n2] = object;
            return n2;
        }
        if (object2 == object || this.equals(object, object2)) {
            return -n2 - 1;
        }
        return this.insertKeyRehash(object, n2, n, object2);
    }

    private int insertKeyRehash(Object object, int n, int n2, Object object2) {
        Object[] objectArray = this._set;
        int n3 = objectArray.length;
        int n4 = 1 + n2 % (n3 - 2);
        int n5 = n;
        int n6 = -1;
        do {
            if (object2 == REMOVED && n6 == -1) {
                n6 = n;
            }
            if ((n -= n4) < 0) {
                n += n3;
            }
            if ((object2 = objectArray[n]) == FREE) {
                if (n6 != -1) {
                    this._set[n6] = object;
                    return n6;
                }
                this.consumeFreeSlot = true;
                this._set[n] = object;
                return n;
            }
            if (object2 != object && !this.equals(object, object2)) continue;
            return -n - 1;
        } while (n != n5);
        if (n6 != -1) {
            this._set[n6] = object;
            return n6;
        }
        throw new IllegalStateException("No free or removed slots available. Key set full?!!");
    }

    private int insertKeyForNull() {
        int n = 0;
        int n2 = -1;
        for (Object object : this._set) {
            if (object == REMOVED && n2 == -1) {
                n2 = n;
            }
            if (object == FREE) {
                if (n2 != -1) {
                    this._set[n2] = null;
                    return n2;
                }
                this.consumeFreeSlot = true;
                this._set[n] = null;
                return n;
            }
            if (object == null) {
                return -n - 1;
            }
            ++n;
        }
        if (n2 != -1) {
            this._set[n2] = null;
            return n2;
        }
        throw new IllegalStateException("Could not find insertion index for null key. Key set full!?!!");
    }

    protected final void throwObjectContractViolation(Object object, Object object2) throws IllegalArgumentException {
        throw this.buildObjectContractViolation(object, object2, "");
    }

    protected final void throwObjectContractViolation(Object object, Object object2, int n, int n2, Object[] objectArray) throws IllegalArgumentException {
        String string = this.dumpExtraInfo(object, object2, this.size(), n2, objectArray);
        throw this.buildObjectContractViolation(object, object2, string);
    }

    protected final IllegalArgumentException buildObjectContractViolation(Object object, Object object2, String string) {
        return new IllegalArgumentException("Equal objects must have equal hashcodes. During rehashing, Trove discovered that the following two objects claim to be equal (as in java.lang.Object.equals()) but their hashCodes (or those calculated by your TObjectHashingStrategy) are not equal.This violates the general contract of java.lang.Object.hashCode().  See bullet point two in that method's documentation. object #1 =" + TObjectHash.objectInfo(object) + "; object #2 =" + TObjectHash.objectInfo(object2) + "\n" + string);
    }

    protected boolean equals(Object object, Object object2) {
        if (object2 == null || object2 == REMOVED) {
            return false;
        }
        return object.equals(object2);
    }

    protected int hash(Object object) {
        return object.hashCode();
    }

    protected static String reportPotentialConcurrentMod(int n, int n2) {
        if (n != n2) {
            return "[Warning] apparent concurrent modification of the key set. Size before and after rehash() do not match " + n2 + " vs " + n;
        }
        return "";
    }

    protected String dumpExtraInfo(Object object, Object object2, int n, int n2, Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.dumpKeyTypes(object, object2));
        stringBuilder.append(TObjectHash.reportPotentialConcurrentMod(n, n2));
        stringBuilder.append(TObjectHash.detectKeyLoss(objectArray, n2));
        if (object == object2) {
            stringBuilder.append("Inserting same object twice, rehashing bug. Object= ").append(object2);
        }
        return stringBuilder.toString();
    }

    private static String detectKeyLoss(Object[] objectArray, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        Set set = TObjectHash.makeKeySet(objectArray);
        if (set.size() != n) {
            stringBuilder.append("\nhashCode() and/or equals() have inconsistent implementation");
            stringBuilder.append("\nKey set lost entries, now got ").append(set.size()).append(" instead of ").append(n);
            stringBuilder.append(". This can manifest itself as an apparent duplicate key.");
        }
        return stringBuilder.toString();
    }

    private static Set makeKeySet(Object[] objectArray) {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Object object : objectArray) {
            if (object == FREE || object == REMOVED) continue;
            hashSet.add(object);
        }
        return hashSet;
    }

    private static String equalsSymmetryInfo(Object object, Object object2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (object == object2) {
            return "a == b";
        }
        if (object.getClass() != object2.getClass()) {
            stringBuilder.append("Class of objects differ a=").append(object.getClass()).append(" vs b=").append(object2.getClass());
            boolean bl = object.equals(object2);
            boolean bl2 = object2.equals(object);
            if (bl != bl2) {
                stringBuilder.append("\nequals() of a or b object are asymmetric");
                stringBuilder.append("\na.equals(b) =").append(bl);
                stringBuilder.append("\nb.equals(a) =").append(bl2);
            }
        }
        return stringBuilder.toString();
    }

    protected static String objectInfo(Object object) {
        return (object == null ? "class null" : object.getClass()) + " id= " + System.identityHashCode(object) + " hashCode= " + (object == null ? 0 : object.hashCode()) + " toString= " + String.valueOf(object);
    }

    private String dumpKeyTypes(Object object, Object object2) {
        StringBuilder stringBuilder = new StringBuilder();
        HashSet hashSet = new HashSet();
        for (Object object3 : this._set) {
            if (object3 == FREE || object3 == REMOVED) continue;
            if (object3 != null) {
                hashSet.add(object3.getClass());
                continue;
            }
            hashSet.add(null);
        }
        if (hashSet.size() > 1) {
            stringBuilder.append("\nMore than one type used for keys. Watch out for asymmetric equals(). Read about the 'Liskov substitution principle' and the implications for equals() in java.");
            stringBuilder.append("\nKey types: ").append(hashSet);
            stringBuilder.append(TObjectHash.equalsSymmetryInfo(object, object2));
        }
        return stringBuilder.toString();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(0);
        super.writeExternal(objectOutput);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        objectInput.readByte();
        super.readExternal(objectInput);
    }
}

