/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.list.array;

import gnu.trove.TIntCollection;
import gnu.trove.function.TIntFunction;
import gnu.trove.impl.HashFunctions;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.TIntList;
import gnu.trove.procedure.TIntProcedure;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.Random;

public class TIntArrayList
implements TIntList,
Externalizable {
    static final long serialVersionUID = 1L;
    protected int[] _data;
    protected int _pos;
    protected static final int DEFAULT_CAPACITY = 10;
    protected int no_entry_value;

    public TIntArrayList() {
        this(10, 0);
    }

    public TIntArrayList(int n) {
        this(n, 0);
    }

    public TIntArrayList(int n, int n2) {
        this._data = new int[n];
        this._pos = 0;
        this.no_entry_value = n2;
    }

    public TIntArrayList(TIntCollection tIntCollection) {
        this(tIntCollection.size());
        this.addAll(tIntCollection);
    }

    public TIntArrayList(int[] nArray) {
        this(nArray.length);
        this.add(nArray);
    }

    protected TIntArrayList(int[] nArray, int n, boolean bl) {
        if (!bl) {
            throw new IllegalStateException("Wrong call");
        }
        if (nArray == null) {
            throw new IllegalArgumentException("values can not be null");
        }
        this._data = nArray;
        this._pos = nArray.length;
        this.no_entry_value = n;
    }

    public static TIntArrayList wrap(int[] nArray) {
        return TIntArrayList.wrap(nArray, 0);
    }

    public static TIntArrayList wrap(int[] nArray, int n) {
        return new TIntArrayList(nArray, n, true){

            @Override
            public void ensureCapacity(int n) {
                if (n > this._data.length) {
                    throw new IllegalStateException("Can not grow ArrayList wrapped external array");
                }
            }
        };
    }

    @Override
    public int getNoEntryValue() {
        return this.no_entry_value;
    }

    public void ensureCapacity(int n) {
        if (n > this._data.length) {
            int n2 = Math.max(this._data.length << 1, n);
            int[] nArray = new int[n2];
            System.arraycopy(this._data, 0, nArray, 0, this._data.length);
            this._data = nArray;
        }
    }

    @Override
    public int size() {
        return this._pos;
    }

    @Override
    public boolean isEmpty() {
        return this._pos == 0;
    }

    public void trimToSize() {
        if (this._data.length > this.size()) {
            int[] nArray = new int[this.size()];
            this.toArray(nArray, 0, nArray.length);
            this._data = nArray;
        }
    }

    @Override
    public boolean add(int n) {
        this.ensureCapacity(this._pos + 1);
        this._data[this._pos++] = n;
        return true;
    }

    @Override
    public void add(int[] nArray) {
        this.add(nArray, 0, nArray.length);
    }

    @Override
    public void add(int[] nArray, int n, int n2) {
        this.ensureCapacity(this._pos + n2);
        System.arraycopy(nArray, n, this._data, this._pos, n2);
        this._pos += n2;
    }

    @Override
    public void insert(int n, int n2) {
        if (n == this._pos) {
            this.add(n2);
            return;
        }
        this.ensureCapacity(this._pos + 1);
        System.arraycopy(this._data, n, this._data, n + 1, this._pos - n);
        this._data[n] = n2;
        ++this._pos;
    }

    @Override
    public void insert(int n, int[] nArray) {
        this.insert(n, nArray, 0, nArray.length);
    }

    @Override
    public void insert(int n, int[] nArray, int n2, int n3) {
        if (n == this._pos) {
            this.add(nArray, n2, n3);
            return;
        }
        this.ensureCapacity(this._pos + n3);
        System.arraycopy(this._data, n, this._data, n + n3, this._pos - n);
        System.arraycopy(nArray, n2, this._data, n, n3);
        this._pos += n3;
    }

    @Override
    public int get(int n) {
        if (n >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this._data[n];
    }

    public int getQuick(int n) {
        return this._data[n];
    }

    @Override
    public int set(int n, int n2) {
        if (n >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n3 = this._data[n];
        this._data[n] = n2;
        return n3;
    }

    @Override
    public int replace(int n, int n2) {
        if (n >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n3 = this._data[n];
        this._data[n] = n2;
        return n3;
    }

    @Override
    public void set(int n, int[] nArray) {
        this.set(n, nArray, 0, nArray.length);
    }

    @Override
    public void set(int n, int[] nArray, int n2, int n3) {
        if (n < 0 || n + n3 > this._pos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        System.arraycopy(nArray, n2, this._data, n, n3);
    }

    public void setQuick(int n, int n2) {
        this._data[n] = n2;
    }

    @Override
    public void clear() {
        this.clear(10);
    }

    public void clear(int n) {
        this._data = new int[n];
        this._pos = 0;
    }

    public void reset() {
        this._pos = 0;
        Arrays.fill(this._data, this.no_entry_value);
    }

    public void resetQuick() {
        this._pos = 0;
    }

    @Override
    public boolean remove(int n) {
        for (int i = 0; i < this._pos; ++i) {
            if (n != this._data[i]) continue;
            this.remove(i, 1);
            return true;
        }
        return false;
    }

    @Override
    public int removeAt(int n) {
        int n2 = this.get(n);
        this.remove(n, 1);
        return n2;
    }

    @Override
    public void remove(int n, int n2) {
        if (n2 == 0) {
            return;
        }
        if (n < 0 || n >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n == 0) {
            System.arraycopy(this._data, n2, this._data, 0, this._pos - n2);
        } else if (this._pos - n2 != n) {
            System.arraycopy(this._data, n + n2, this._data, n, this._pos - (n + n2));
        }
        this._pos -= n2;
    }

    @Override
    public TIntIterator iterator() {
        return new TIntArrayIterator(0);
    }

    @Override
    public boolean containsAll(Collection collection) {
        for (Object e : collection) {
            if (e instanceof Integer) {
                int n = (Integer)e;
                if (this.contains(n)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(TIntCollection tIntCollection) {
        if (this == tIntCollection) {
            return true;
        }
        TIntIterator tIntIterator = tIntCollection.iterator();
        while (tIntIterator.hasNext()) {
            int n = tIntIterator.next();
            if (this.contains(n)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(int[] nArray) {
        int n = nArray.length;
        while (n-- > 0) {
            if (this.contains(nArray[n])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection collection) {
        boolean bl = false;
        for (Integer n : collection) {
            int n2 = n;
            if (!this.add(n2)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean addAll(TIntCollection tIntCollection) {
        boolean bl = false;
        TIntIterator tIntIterator = tIntCollection.iterator();
        while (tIntIterator.hasNext()) {
            int n = tIntIterator.next();
            if (!this.add(n)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean addAll(int[] nArray) {
        boolean bl = false;
        for (int n : nArray) {
            if (!this.add(n)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection collection) {
        boolean bl = false;
        TIntIterator tIntIterator = this.iterator();
        while (tIntIterator.hasNext()) {
            if (collection.contains(tIntIterator.next())) continue;
            tIntIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(TIntCollection tIntCollection) {
        if (this == tIntCollection) {
            return false;
        }
        boolean bl = false;
        TIntIterator tIntIterator = this.iterator();
        while (tIntIterator.hasNext()) {
            if (tIntCollection.contains(tIntIterator.next())) continue;
            tIntIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(int[] nArray) {
        boolean bl = false;
        Arrays.sort(nArray);
        int[] nArray2 = this._data;
        int n = this._pos;
        while (n-- > 0) {
            if (Arrays.binarySearch(nArray, nArray2[n]) >= 0) continue;
            this.remove(n, 1);
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection collection) {
        boolean bl = false;
        for (Object e : collection) {
            int n;
            if (!(e instanceof Integer) || !this.remove(n = ((Integer)e).intValue())) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean removeAll(TIntCollection tIntCollection) {
        if (tIntCollection == this) {
            this.clear();
            return true;
        }
        boolean bl = false;
        TIntIterator tIntIterator = tIntCollection.iterator();
        while (tIntIterator.hasNext()) {
            int n = tIntIterator.next();
            if (!this.remove(n)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean removeAll(int[] nArray) {
        boolean bl = false;
        int n = nArray.length;
        while (n-- > 0) {
            if (!this.remove(nArray[n])) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public void transformValues(TIntFunction tIntFunction) {
        int n = this._pos;
        while (n-- > 0) {
            this._data[n] = tIntFunction.execute(this._data[n]);
        }
    }

    @Override
    public void reverse() {
        this.reverse(0, this._pos);
    }

    @Override
    public void reverse(int n, int n2) {
        if (n == n2) {
            return;
        }
        if (n > n2) {
            throw new IllegalArgumentException("from cannot be greater than to");
        }
        int n3 = n;
        for (int i = n2 - 1; n3 < i; ++n3, --i) {
            this.swap(n3, i);
        }
    }

    @Override
    public void shuffle(Random random) {
        int n = this._pos;
        while (n-- > 1) {
            this.swap(n, random.nextInt(n));
        }
    }

    private void swap(int n, int n2) {
        int n3 = this._data[n];
        this._data[n] = this._data[n2];
        this._data[n2] = n3;
    }

    @Override
    public TIntList subList(int n, int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("end index " + n2 + " greater than begin index " + n);
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("begin index can not be < 0");
        }
        if (n2 > this._data.length) {
            throw new IndexOutOfBoundsException("end index < " + this._data.length);
        }
        TIntArrayList tIntArrayList = new TIntArrayList(n2 - n);
        for (int i = n; i < n2; ++i) {
            tIntArrayList.add(this._data[i]);
        }
        return tIntArrayList;
    }

    @Override
    public int[] toArray() {
        return this.toArray(0, this._pos);
    }

    @Override
    public int[] toArray(int n, int n2) {
        int[] nArray = new int[n2];
        this.toArray(nArray, n, n2);
        return nArray;
    }

    @Override
    public int[] toArray(int[] nArray) {
        int n = nArray.length;
        if (nArray.length > this._pos) {
            n = this._pos;
            nArray[n] = this.no_entry_value;
        }
        this.toArray(nArray, 0, n);
        return nArray;
    }

    @Override
    public int[] toArray(int[] nArray, int n, int n2) {
        if (n2 == 0) {
            return nArray;
        }
        if (n < 0 || n >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        System.arraycopy(this._data, n, nArray, 0, n2);
        return nArray;
    }

    @Override
    public int[] toArray(int[] nArray, int n, int n2, int n3) {
        if (n3 == 0) {
            return nArray;
        }
        if (n < 0 || n >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        System.arraycopy(this._data, n, nArray, n2, n3);
        return nArray;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof TIntArrayList) {
            TIntArrayList tIntArrayList = (TIntArrayList)object;
            if (tIntArrayList.size() != this.size()) {
                return false;
            }
            int n = this._pos;
            while (n-- > 0) {
                if (this._data[n] == tIntArrayList._data[n]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 0;
        int n2 = this._pos;
        while (n2-- > 0) {
            n += HashFunctions.hash(this._data[n2]);
        }
        return n;
    }

    @Override
    public boolean forEach(TIntProcedure tIntProcedure) {
        for (int i = 0; i < this._pos; ++i) {
            if (tIntProcedure.execute(this._data[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachDescending(TIntProcedure tIntProcedure) {
        int n = this._pos;
        while (n-- > 0) {
            if (tIntProcedure.execute(this._data[n])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void sort() {
        Arrays.sort(this._data, 0, this._pos);
    }

    @Override
    public void sort(int n, int n2) {
        Arrays.sort(this._data, n, n2);
    }

    @Override
    public void fill(int n) {
        Arrays.fill(this._data, 0, this._pos, n);
    }

    @Override
    public void fill(int n, int n2, int n3) {
        if (n2 > this._pos) {
            this.ensureCapacity(n2);
            this._pos = n2;
        }
        Arrays.fill(this._data, n, n2, n3);
    }

    @Override
    public int binarySearch(int n) {
        return this.binarySearch(n, 0, this._pos);
    }

    @Override
    public int binarySearch(int n, int n2, int n3) {
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        if (n3 > this._pos) {
            throw new ArrayIndexOutOfBoundsException(n3);
        }
        int n4 = n2;
        int n5 = n3 - 1;
        while (n4 <= n5) {
            int n6 = n4 + n5 >>> 1;
            int n7 = this._data[n6];
            if (n7 < n) {
                n4 = n6 + 1;
                continue;
            }
            if (n7 > n) {
                n5 = n6 - 1;
                continue;
            }
            return n6;
        }
        return -(n4 + 1);
    }

    @Override
    public int indexOf(int n) {
        return this.indexOf(0, n);
    }

    @Override
    public int indexOf(int n, int n2) {
        for (int i = n; i < this._pos; ++i) {
            if (this._data[i] != n2) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(int n) {
        return this.lastIndexOf(this._pos, n);
    }

    @Override
    public int lastIndexOf(int n, int n2) {
        int n3 = n;
        while (n3-- > 0) {
            if (this._data[n3] != n2) continue;
            return n3;
        }
        return -1;
    }

    @Override
    public boolean contains(int n) {
        return this.lastIndexOf(n) >= 0;
    }

    @Override
    public TIntList grep(TIntProcedure tIntProcedure) {
        TIntArrayList tIntArrayList = new TIntArrayList();
        for (int i = 0; i < this._pos; ++i) {
            if (!tIntProcedure.execute(this._data[i])) continue;
            tIntArrayList.add(this._data[i]);
        }
        return tIntArrayList;
    }

    @Override
    public TIntList inverseGrep(TIntProcedure tIntProcedure) {
        TIntArrayList tIntArrayList = new TIntArrayList();
        for (int i = 0; i < this._pos; ++i) {
            if (tIntProcedure.execute(this._data[i])) continue;
            tIntArrayList.add(this._data[i]);
        }
        return tIntArrayList;
    }

    @Override
    public int max() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find maximum of an empty list");
        }
        int n = Integer.MIN_VALUE;
        for (int i = 0; i < this._pos; ++i) {
            if (this._data[i] <= n) continue;
            n = this._data[i];
        }
        return n;
    }

    @Override
    public int min() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find minimum of an empty list");
        }
        int n = Integer.MAX_VALUE;
        for (int i = 0; i < this._pos; ++i) {
            if (this._data[i] >= n) continue;
            n = this._data[i];
        }
        return n;
    }

    @Override
    public int sum() {
        int n = 0;
        for (int i = 0; i < this._pos; ++i) {
            n += this._data[i];
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        int n = this._pos - 1;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this._data[i]);
            stringBuilder.append(", ");
        }
        if (this.size() > 0) {
            stringBuilder.append(this._data[this._pos - 1]);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(0);
        objectOutput.writeInt(this._pos);
        objectOutput.writeInt(this.no_entry_value);
        int n = this._data.length;
        objectOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            objectOutput.writeInt(this._data[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        objectInput.readByte();
        this._pos = objectInput.readInt();
        this.no_entry_value = objectInput.readInt();
        int n = objectInput.readInt();
        this._data = new int[n];
        for (int i = 0; i < n; ++i) {
            this._data[i] = objectInput.readInt();
        }
    }

    class TIntArrayIterator
    implements TIntIterator {
        private int cursor = 0;
        int lastRet = -1;

        TIntArrayIterator(int n) {
            this.cursor = n;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < TIntArrayList.this.size();
        }

        @Override
        public int next() {
            try {
                int n = TIntArrayList.this.get(this.cursor);
                this.lastRet = this.cursor++;
                return n;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            try {
                TIntArrayList.this.remove(this.lastRet, 1);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

